/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase.fieldmanager;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import org.apache.hadoop.hbase.client.Result;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.Relation;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.hbase.HBaseUtils;
import org.datanucleus.store.hbase.fieldmanager.FetchFieldManager;
import org.datanucleus.store.types.ObjectLongConverter;
import org.datanucleus.store.types.ObjectStringConverter;
import org.datanucleus.store.types.sco.SCOUtils;

public class FetchEmbeddedFieldManager
extends FetchFieldManager {
    private final AbstractMemberMetaData ownerMmd;
    private final String tableName;

    public FetchEmbeddedFieldManager(ObjectProvider sm, Result result, AbstractMemberMetaData mmd, String tableName) {
        super(sm, result);
        this.ownerMmd = mmd;
        this.tableName = tableName;
    }

    protected String getFamilyName(int fieldNumber) {
        return HBaseUtils.getFamilyName(this.ownerMmd, fieldNumber, this.tableName);
    }

    protected String getQualifierName(int fieldNumber) {
        return HBaseUtils.getQualifierName(this.ownerMmd, fieldNumber);
    }

    protected AbstractMemberMetaData getMemberMetaData(int fieldNumber) {
        return this.ownerMmd.getEmbeddedMetaData().getMemberMetaData()[fieldNumber];
    }

    public Object fetchObjectField(int fieldNumber) {
        Object value;
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        AbstractMemberMetaData embMmd = this.ownerMmd.getEmbeddedMetaData().getMemberMetaData()[fieldNumber];
        int relationType = embMmd.getRelationType(clr);
        if (embMmd.isEmbedded() && Relation.isRelationSingleValued((int)relationType)) {
            Class embcls = embMmd.getType();
            AbstractClassMetaData embcmd = this.ec.getMetaDataManager().getMetaDataForClass(embcls, clr);
            if (embcmd != null) {
                EmbeddedMetaData embmd = this.ownerMmd.getEmbeddedMetaData();
                AbstractMemberMetaData[] embmmds = embmd.getMemberMetaData();
                boolean isNull = true;
                for (int i = 0; i < embmmds.length; ++i) {
                    String familyName = HBaseUtils.getFamilyName(this.ownerMmd, i, this.tableName);
                    String columnName = HBaseUtils.getQualifierName(this.ownerMmd, i);
                    if (this.result.getValue(familyName.getBytes(), columnName.getBytes()) == null) continue;
                    isNull = false;
                    break;
                }
                if (isNull) {
                    return null;
                }
                ObjectProvider embSM = this.ec.newObjectProviderForEmbedded(embMmd, embcmd, this.sm, fieldNumber);
                FetchEmbeddedFieldManager ffm = new FetchEmbeddedFieldManager(embSM, this.result, embMmd, this.tableName);
                embSM.replaceFields(embcmd.getAllMemberPositions(), (FieldManager)ffm);
                return embSM.getObject();
            }
            throw new NucleusUserException("Field " + this.ownerMmd.getFullFieldName() + " marked as embedded but no such metadata");
        }
        String familyName = this.getFamilyName(fieldNumber);
        String columnName = this.getQualifierName(fieldNumber);
        try {
            byte[] bytes = this.result.getValue(familyName.getBytes(), columnName.getBytes());
            if (bytes == null) {
                return null;
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            value = ois.readObject();
            ois.close();
            bis.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        if (Relation.isRelationSingleValued((int)relationType)) {
            if (embMmd.isSerialized()) {
                return value;
            }
            return this.ec.findObject(value, true, true, null);
        }
        if (Relation.isRelationMultiValued((int)relationType)) {
            if (embMmd.hasCollection()) {
                Collection coll;
                if (embMmd.isSerialized()) {
                    return value;
                }
                try {
                    Class instanceType = SCOUtils.getContainerInstanceType((Class)embMmd.getType(), (Boolean)(embMmd.getOrderMetaData() != null ? 1 : 0));
                    coll = (Collection)instanceType.newInstance();
                }
                catch (Exception e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
                Collection collIds = (Collection)value;
                for (Object elementId : collIds) {
                    coll.add(this.ec.findObject(elementId, true, true, null));
                }
                if (this.sm != null) {
                    return this.sm.wrapSCOField(fieldNumber, (Object)coll, false, false, true);
                }
                return coll;
            }
            if (embMmd.hasMap()) {
                if (embMmd.isSerialized()) {
                    return value;
                }
            } else if (embMmd.hasArray()) {
                if (embMmd.isSerialized()) {
                    return value;
                }
                Collection arrIds = (Collection)value;
                Object array = Array.newInstance(embMmd.getType().getComponentType(), arrIds.size());
                Iterator idIter = arrIds.iterator();
                int i = 0;
                while (idIter.hasNext()) {
                    Object elementId = idIter.next();
                    Array.set(array, i, this.ec.findObject(elementId, true, true, null));
                }
                return array;
            }
            throw new NucleusUserException("No container that isnt collection/map/array");
        }
        ObjectStringConverter strConv = this.sm.getExecutionContext().getNucleusContext().getTypeManager().getStringConverter(value.getClass());
        ObjectLongConverter longConv = this.sm.getExecutionContext().getNucleusContext().getTypeManager().getLongConverter(value.getClass());
        Object returnValue = null;
        if (!embMmd.isSerialized()) {
            if (strConv != null) {
                String strValue = (String)value;
                returnValue = strConv.toObject(strValue);
            }
            if (longConv != null) {
                Long longValue = (Long)value;
                returnValue = longConv.toObject(longValue);
            }
        }
        if (this.sm != null) {
            return this.sm.wrapSCOField(fieldNumber, returnValue, false, false, true);
        }
        return returnValue;
    }
}

