/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.hadoop.hbase.client.Result;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.hbase.HBaseUtils;

public class HBaseFetchFieldManager
extends AbstractFieldManager {
    Result result;
    StateManager sm;

    public HBaseFetchFieldManager(StateManager sm, Result result) {
        this.sm = sm;
        this.result = result;
    }

    public boolean fetchBooleanField(int fieldNumber) {
        boolean value;
        String familyName = HBaseUtils.getFamilyName(this.sm.getClassMetaData(), fieldNumber);
        String columnName = HBaseUtils.getQualifierName(this.sm.getClassMetaData(), fieldNumber);
        try {
            byte[] bytes = this.result.getValue(familyName.getBytes(), columnName.getBytes());
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            value = ois.readBoolean();
            ois.close();
            bis.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        return value;
    }

    public byte fetchByteField(int fieldNumber) {
        byte value;
        String familyName = HBaseUtils.getFamilyName(this.sm.getClassMetaData(), fieldNumber);
        String columnName = HBaseUtils.getQualifierName(this.sm.getClassMetaData(), fieldNumber);
        try {
            byte[] bytes = this.result.getValue(familyName.getBytes(), columnName.getBytes());
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            value = ois.readByte();
            ois.close();
            bis.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        return value;
    }

    public char fetchCharField(int fieldNumber) {
        char value;
        String familyName = HBaseUtils.getFamilyName(this.sm.getClassMetaData(), fieldNumber);
        String columnName = HBaseUtils.getQualifierName(this.sm.getClassMetaData(), fieldNumber);
        try {
            byte[] bytes = this.result.getValue(familyName.getBytes(), columnName.getBytes());
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            value = ois.readChar();
            ois.close();
            bis.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        return value;
    }

    public double fetchDoubleField(int fieldNumber) {
        double value;
        String familyName = HBaseUtils.getFamilyName(this.sm.getClassMetaData(), fieldNumber);
        String columnName = HBaseUtils.getQualifierName(this.sm.getClassMetaData(), fieldNumber);
        try {
            byte[] bytes = this.result.getValue(familyName.getBytes(), columnName.getBytes());
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            value = ois.readDouble();
            ois.close();
            bis.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        return value;
    }

    public float fetchFloatField(int fieldNumber) {
        float value;
        String familyName = HBaseUtils.getFamilyName(this.sm.getClassMetaData(), fieldNumber);
        String columnName = HBaseUtils.getQualifierName(this.sm.getClassMetaData(), fieldNumber);
        try {
            byte[] bytes = this.result.getValue(familyName.getBytes(), columnName.getBytes());
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            value = ois.readFloat();
            ois.close();
            bis.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        return value;
    }

    public int fetchIntField(int fieldNumber) {
        int value;
        String familyName = HBaseUtils.getFamilyName(this.sm.getClassMetaData(), fieldNumber);
        String columnName = HBaseUtils.getQualifierName(this.sm.getClassMetaData(), fieldNumber);
        try {
            byte[] bytes = this.result.getValue(familyName.getBytes(), columnName.getBytes());
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            value = ois.readInt();
            ois.close();
            bis.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        return value;
    }

    public long fetchLongField(int fieldNumber) {
        long value;
        String familyName = HBaseUtils.getFamilyName(this.sm.getClassMetaData(), fieldNumber);
        String columnName = HBaseUtils.getQualifierName(this.sm.getClassMetaData(), fieldNumber);
        try {
            byte[] bytes = this.result.getValue(familyName.getBytes(), columnName.getBytes());
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            value = ois.readLong();
            ois.close();
            bis.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        return value;
    }

    public Object fetchObjectField(int fieldNumber) {
        Object value;
        String familyName = HBaseUtils.getFamilyName(this.sm.getClassMetaData(), fieldNumber);
        String columnName = HBaseUtils.getQualifierName(this.sm.getClassMetaData(), fieldNumber);
        try {
            try {
                byte[] bytes = this.result.getValue(familyName.getBytes(), columnName.getBytes());
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                value = ois.readObject();
                ois.close();
                bis.close();
            }
            catch (NullPointerException ex) {
                return null;
            }
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        return value;
    }

    public short fetchShortField(int fieldNumber) {
        short value;
        String familyName = HBaseUtils.getFamilyName(this.sm.getClassMetaData(), fieldNumber);
        String columnName = HBaseUtils.getQualifierName(this.sm.getClassMetaData(), fieldNumber);
        try {
            byte[] bytes = this.result.getValue(familyName.getBytes(), columnName.getBytes());
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            value = ois.readShort();
            ois.close();
            bis.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        return value;
    }

    public String fetchStringField(int fieldNumber) {
        String value;
        String familyName = HBaseUtils.getFamilyName(this.sm.getClassMetaData(), fieldNumber);
        String columnName = HBaseUtils.getQualifierName(this.sm.getClassMetaData(), fieldNumber);
        try {
            try {
                byte[] bytes = this.result.getValue(familyName.getBytes(), columnName.getBytes());
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                value = (String)ois.readObject();
                ois.close();
                bis.close();
            }
            catch (NullPointerException ex) {
                return null;
            }
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        return value;
    }
}

