/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase;

import java.util.Map;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManager;
import org.datanucleus.store.connection.AbstractConnectionFactory;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.hbase.HBaseConnectionPool;
import org.datanucleus.store.hbase.HBaseManagedConnection;
import org.datanucleus.store.hbase.HBaseStoreManager;

public class ConnectionFactoryImpl
extends AbstractConnectionFactory {
    private HBaseConnectionPool connectionPool;

    public ConnectionFactoryImpl(OMFContext omfContext, String resourceType) {
        super(omfContext, resourceType);
        HBaseStoreManager storeManager = (HBaseStoreManager)omfContext.getStoreManager();
        this.connectionPool = new HBaseConnectionPool();
        this.connectionPool.setTimeBetweenEvictionRunsMillis(storeManager.getPoolTimeBetweenEvictionRunsMillis());
    }

    public ManagedConnection createManagedConnection(ObjectManager om, Map transactionOptions) {
        HBaseStoreManager storeManager = (HBaseStoreManager)om.getStoreManager();
        HBaseManagedConnection managedConnection = this.connectionPool.getPooledConnection();
        if (managedConnection == null) {
            managedConnection = new HBaseManagedConnection(storeManager.getHbaseConfig());
            managedConnection.setIdleTimeoutMills(storeManager.getPoolMinEvictableIdleTimeMillis());
            this.connectionPool.registerConnection(managedConnection);
        }
        managedConnection.incrementReferenceCount();
        return managedConnection;
    }
}

