/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.apache.hadoop.hbase.io.BatchUpdate;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.hbase.HBaseUtils;

public class HBaseInsertFieldManager
extends AbstractFieldManager {
    BatchUpdate batch;
    StateManager sm;

    public HBaseInsertFieldManager(StateManager sm, BatchUpdate batch) {
        this.sm = sm;
        this.batch = batch;
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        String columnName = HBaseUtils.getColumnName(this.sm.getClassMetaData(), fieldNumber);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeBoolean(value);
            oos.flush();
            this.batch.put(columnName, bos.toByteArray());
            oos.close();
            bos.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeByteField(int fieldNumber, byte value) {
        String columnName = HBaseUtils.getColumnName(this.sm.getClassMetaData(), fieldNumber);
        this.batch.put(columnName, new byte[]{value});
    }

    public void storeCharField(int fieldNumber, char value) {
        String columnName = HBaseUtils.getColumnName(this.sm.getClassMetaData(), fieldNumber);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeChar(value);
            oos.flush();
            this.batch.put(columnName, bos.toByteArray());
            oos.close();
            bos.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeDoubleField(int fieldNumber, double value) {
        String columnName = HBaseUtils.getColumnName(this.sm.getClassMetaData(), fieldNumber);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeDouble(value);
            oos.flush();
            this.batch.put(columnName, bos.toByteArray());
            oos.close();
            bos.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeFloatField(int fieldNumber, float value) {
        String columnName = HBaseUtils.getColumnName(this.sm.getClassMetaData(), fieldNumber);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeFloat(value);
            oos.flush();
            this.batch.put(columnName, bos.toByteArray());
            oos.close();
            bos.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeIntField(int fieldNumber, int value) {
        String columnName = HBaseUtils.getColumnName(this.sm.getClassMetaData(), fieldNumber);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeInt(value);
            oos.flush();
            this.batch.put(columnName, bos.toByteArray());
            oos.close();
            bos.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeLongField(int fieldNumber, long value) {
        String columnName = HBaseUtils.getColumnName(this.sm.getClassMetaData(), fieldNumber);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeLong(value);
            oos.flush();
            this.batch.put(columnName, bos.toByteArray());
            oos.close();
            bos.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeObjectField(int fieldNumber, Object value) {
        String columnName = HBaseUtils.getColumnName(this.sm.getClassMetaData(), fieldNumber);
        if (value == null) {
            this.batch.delete(columnName);
        } else {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(value);
                this.batch.put(columnName, bos.toByteArray());
                oos.close();
                bos.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void storeShortField(int fieldNumber, short value) {
        String columnName = HBaseUtils.getColumnName(this.sm.getClassMetaData(), fieldNumber);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeShort(value);
            oos.flush();
            this.batch.put(columnName, bos.toByteArray());
            oos.close();
            bos.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeStringField(int fieldNumber, String value) {
        String columnName = HBaseUtils.getColumnName(this.sm.getClassMetaData(), fieldNumber);
        if (value == null) {
            this.batch.delete(columnName);
        } else {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(value);
                this.batch.put(columnName, bos.toByteArray());
                oos.close();
                bos.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

