/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.xa.XAResource;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.datanucleus.ConnectionFactory;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ManagedConnectionResourceListener;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManager;

public class ConnectionFactoryImpl
implements ConnectionFactory {
    OMFContext omfContext;

    public ConnectionFactoryImpl(OMFContext omfContext, String resourceType) {
        this.omfContext = omfContext;
    }

    public ManagedConnection getConnection(ObjectManager om, Map options) {
        HashMap addedOptions = new HashMap();
        if (options != null) {
            addedOptions.putAll(options);
        }
        return this.omfContext.getConnectionManager().allocateConnection((ConnectionFactory)this, om, addedOptions);
    }

    public ManagedConnection createManagedConnection(ObjectManager om, Map transactionOptions) {
        return new ManagedConnectionImpl(om.getOMFContext(), transactionOptions);
    }

    public static class ManagedConnectionImpl
    implements ManagedConnection {
        OMFContext omf;
        Map options;
        Object conn;
        boolean locked = false;
        List listeners = new ArrayList();

        public ManagedConnectionImpl(OMFContext omf, Map options) {
            this.omf = omf;
            this.options = options;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            int i;
            if (this.conn == null) {
                return;
            }
            for (i = 0; i < this.listeners.size(); ++i) {
                ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPreClose();
            }
            this.conn = null;
            for (i = 0; i < this.listeners.size(); ++i) {
                ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPostClose();
            }
        }

        public void flush() {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionFlushed();
            }
        }

        public Object getConnection() {
            if (this.conn == null) {
                this.conn = new HBaseConfiguration();
            }
            return this.conn;
        }

        public XAResource getXAResource() {
            return null;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public void lock() {
            this.locked = true;
        }

        public void unlock() {
            this.locked = false;
        }

        public void release() {
        }

        public void addListener(ManagedConnectionResourceListener listener) {
            this.listeners.add(listener);
        }

        public void removeListener(ManagedConnectionResourceListener listener) {
            this.listeners.remove(listener);
        }

        public void setManagedResource() {
        }
    }
}

