/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.wrappers;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.datanucleus.FetchPlanState;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.types.SCO;

public class Rectangle2dFloat
extends Rectangle2D.Float
implements SCO<Rectangle2D.Float> {
    private static final long serialVersionUID = 6204949069264230370L;
    protected transient DNStateManager ownerOP;
    protected transient String fieldName;

    public Rectangle2dFloat(DNStateManager ownerSM, AbstractMemberMetaData mmd) {
        this.ownerOP = ownerSM;
        this.fieldName = mmd.getName();
    }

    public void initialise(Rectangle2D.Float newValue, Object oldValue) {
        super.setRect(newValue);
    }

    public void initialise(Rectangle2D.Float value) {
        super.setRect(value);
    }

    public void initialise() {
    }

    public Rectangle2D.Float getValue() {
        return new Rectangle2D.Float((float)this.getX(), (float)this.getY(), (float)this.getWidth(), (float)this.getHeight());
    }

    public void unsetOwner() {
        this.ownerOP = null;
    }

    public Object getOwner() {
        return this.ownerOP != null ? this.ownerOP.getObject() : null;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void makeDirty() {
        if (this.ownerOP != null) {
            this.ownerOP.getExecutionContext().getApiAdapter().makeDirty(this.ownerOP.getObject(), this.fieldName);
        }
    }

    public Rectangle2D.Float detachCopy(FetchPlanState state) {
        return new Rectangle2D.Float((float)this.getX(), (float)this.getY(), (float)this.getWidth(), (float)this.getHeight());
    }

    public void attachCopy(Rectangle2D.Float value) {
        double oldX = this.getX();
        double oldY = this.getY();
        double oldW = this.getWidth();
        double oldH = this.getHeight();
        this.initialise(value, null);
        Rectangle2dFloat rect = (Rectangle2dFloat)value;
        double newX = rect.getX();
        double newY = rect.getY();
        double newW = rect.getWidth();
        double newH = rect.getHeight();
        if (oldX != newX || oldY != newY || oldW != newW || oldH != newH) {
            this.makeDirty();
        }
    }

    @Override
    public Object clone() {
        Object obj = super.clone();
        ((Rectangle2dFloat)obj).unsetOwner();
        return obj;
    }

    @Override
    public void setRect(float x, float y, float w, float h) {
        super.setRect(x, y, w, h);
        this.makeDirty();
    }

    @Override
    public void setRect(double x, double y, double w, double h) {
        super.setRect(x, y, w, h);
        this.makeDirty();
    }

    @Override
    public void setRect(Rectangle2D r) {
        super.setRect(r);
        this.makeDirty();
    }

    @Override
    public void setFrame(double x, double y, double w, double h) {
        super.setFrame(x, y, w, h);
        this.makeDirty();
    }

    @Override
    public void add(double newx, double newy) {
        super.add(newx, newy);
        this.makeDirty();
    }

    @Override
    public void add(Point2D pt) {
        super.add(pt);
        this.makeDirty();
    }

    @Override
    public void add(Rectangle2D r) {
        super.add(r);
        this.makeDirty();
    }

    @Override
    public void setFrame(Point2D loc, Dimension2D size) {
        super.setFrame(loc, size);
        this.makeDirty();
    }

    @Override
    public void setFrame(Rectangle2D r) {
        super.setFrame(r);
        this.makeDirty();
    }

    @Override
    public void setFrameFromDiagonal(double x1, double y1, double x2, double y2) {
        super.setFrameFromDiagonal(x1, y1, x2, y2);
        this.makeDirty();
    }

    @Override
    public void setFrameFromDiagonal(Point2D p1, Point2D p2) {
        super.setFrameFromDiagonal(p1, p2);
        this.makeDirty();
    }

    @Override
    public void setFrameFromCenter(double centerX, double centerY, double cornerX, double cornerY) {
        super.setFrameFromCenter(centerX, centerY, cornerX, cornerY);
        this.makeDirty();
    }

    @Override
    public void setFrameFromCenter(Point2D center, Point2D corner) {
        super.setFrameFromCenter(center, corner);
        this.makeDirty();
    }
}

