/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.sql.method;

import java.util.List;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.query.expression.Expression;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;

public class SpatialBboxTestMethod
implements SQLMethod {
    private static final Expression.DyadicOperator BBOX_OVERLAPS = new Expression.DyadicOperator("&&", 3, false);

    public SQLExpression getExpression(SQLStatement stmt, SQLExpression expr, List args) {
        if (args == null) {
            throw new NucleusUserException("Cannot invoke Spatial.bboxTest without arguments");
        }
        if (expr == null && args.size() != 2) {
            throw new NucleusUserException("Cannot invoke Spatial.bboxTest without 2 arguments");
        }
        if (expr != null && args.size() != 1) {
            throw new NucleusUserException("Cannot invoke geom.bboxTest() without 1 argument");
        }
        SQLExpression argExpr1 = null;
        SQLExpression argExpr2 = null;
        if (expr == null) {
            argExpr1 = (SQLExpression)args.get(0);
            argExpr2 = (SQLExpression)args.get(1);
        } else {
            argExpr1 = expr;
            argExpr2 = (SQLExpression)args.get(0);
        }
        BooleanExpression boolExpr = new BooleanExpression(argExpr1, BBOX_OVERLAPS, argExpr2);
        boolExpr.setJavaTypeMapping(stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false));
        return boolExpr;
    }
}

