/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.mapping.jgeom2oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.jdbc.OracleConnection;
import oracle.spatial.geometry.JGeometry;
import oracle.sql.STRUCT;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.column.AbstractColumnMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.table.Column;

public class JGeometryColumnMapping
extends AbstractColumnMapping {
    public JGeometryColumnMapping(JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column col) {
        super(storeMgr, mapping);
        this.column = col;
        this.initialize();
    }

    private void initialize() {
        this.initTypeInfo();
    }

    public int getJDBCType() {
        return -123;
    }

    public Object getObject(ResultSet rs, int exprIndex) {
        JGeometry value;
        try {
            Object st = rs.getObject(exprIndex);
            value = rs.wasNull() || st == null ? null : JGeometry.load((STRUCT)((STRUCT)st));
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(this.failureMessage("getObject", exprIndex, e), (Throwable)e);
        }
        return value;
    }

    public void setObject(PreparedStatement ps, int exprIndex, Object value) {
        try {
            if (value == null) {
                ps.setNull(exprIndex, this.getJDBCType(), this.getTypeInfo().getTypeName());
            } else {
                STRUCT obj = JGeometry.store((JGeometry)((JGeometry)value), (Connection)((Connection)ps.getConnection().unwrap(OracleConnection.class)));
                ps.setObject(exprIndex, obj);
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(this.failureMessage("setObject", value, e), (Throwable)e);
        }
    }
}

