/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.mapping;

import java.awt.geom.Point2D;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.SingleFieldMultiMapping;
import org.datanucleus.store.rdbms.table.Table;

public class Point2dFloatMapping
extends SingleFieldMultiMapping {
    public void initialize(AbstractMemberMetaData fmd, Table table, ClassLoaderResolver clr) {
        super.initialize(fmd, table, clr);
        this.addColumns();
    }

    public void initialize(RDBMSStoreManager storeMgr, String type) {
        super.initialize(storeMgr, type);
        this.addColumns();
    }

    protected void addColumns() {
        this.addColumns(ClassNameConstants.FLOAT);
        this.addColumns(ClassNameConstants.FLOAT);
    }

    public Class getJavaType() {
        return Point2D.Float.class;
    }

    public Object getValueForColumnMapping(NucleusContext nucleusCtx, int index, Object value) {
        Point2D.Float pt = (Point2D.Float)value;
        if (index == 0) {
            return pt.getX();
        }
        if (index == 1) {
            return pt.getY();
        }
        throw new IndexOutOfBoundsException();
    }

    public void setObject(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, Object value) {
        Point2D.Float pt = (Point2D.Float)value;
        if (pt == null) {
            this.getColumnMapping(0).setObject(ps, exprIndex[0], null);
            this.getColumnMapping(1).setObject(ps, exprIndex[1], null);
        } else {
            this.getColumnMapping(0).setFloat(ps, exprIndex[0], pt.x);
            this.getColumnMapping(1).setFloat(ps, exprIndex[1], pt.y);
        }
    }

    public Object getObject(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (this.getColumnMapping(0).getObject(resultSet, exprIndex[0]) == null) {
            return null;
        }
        float x = this.getColumnMapping(0).getFloat(resultSet, exprIndex[0]);
        float y = this.getColumnMapping(1).getFloat(resultSet, exprIndex[1]);
        return new Point2D.Float(x, y);
    }
}

