/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.mapping;

import java.awt.geom.Arc2D;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.SingleFieldMultiMapping;
import org.datanucleus.store.rdbms.table.Table;

public class Arc2dFloatMapping
extends SingleFieldMultiMapping {
    public void initialize(AbstractMemberMetaData fmd, Table table, ClassLoaderResolver clr) {
        super.initialize(fmd, table, clr);
        this.addColumns();
    }

    public void initialize(RDBMSStoreManager storeMgr, String type) {
        super.initialize(storeMgr, type);
        this.addColumns();
    }

    protected void addColumns() {
        this.addColumns(ClassNameConstants.INT);
        this.addColumns(ClassNameConstants.FLOAT);
        this.addColumns(ClassNameConstants.FLOAT);
        this.addColumns(ClassNameConstants.FLOAT);
        this.addColumns(ClassNameConstants.FLOAT);
        this.addColumns(ClassNameConstants.FLOAT);
        this.addColumns(ClassNameConstants.FLOAT);
    }

    public Class getJavaType() {
        return Arc2D.Float.class;
    }

    public Object getValueForColumnMapping(NucleusContext nucleusCtx, int index, Object value) {
        Arc2D.Float arc = (Arc2D.Float)value;
        if (index == 0) {
            return arc.getArcType();
        }
        if (index == 1) {
            return arc.getX();
        }
        if (index == 2) {
            return arc.getY();
        }
        if (index == 3) {
            return arc.getWidth();
        }
        if (index == 4) {
            return arc.getHeight();
        }
        if (index == 5) {
            return arc.getAngleStart();
        }
        if (index == 6) {
            return arc.getAngleExtent();
        }
        throw new IndexOutOfBoundsException();
    }

    public void setObject(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, Object value) {
        Arc2D.Float arc = (Arc2D.Float)value;
        if (arc == null) {
            for (int i = 0; i < exprIndex.length; ++i) {
                this.getColumnMapping(i).setObject(ps, exprIndex[i], null);
            }
        } else {
            this.getColumnMapping(0).setInt(ps, exprIndex[0], arc.getArcType());
            this.getColumnMapping(1).setFloat(ps, exprIndex[1], arc.x);
            this.getColumnMapping(2).setFloat(ps, exprIndex[2], arc.y);
            this.getColumnMapping(3).setFloat(ps, exprIndex[3], arc.width);
            this.getColumnMapping(4).setFloat(ps, exprIndex[4], arc.height);
            this.getColumnMapping(5).setFloat(ps, exprIndex[5], arc.start);
            this.getColumnMapping(6).setFloat(ps, exprIndex[6], arc.extent);
        }
    }

    public Object getObject(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (this.getColumnMapping(0).getObject(resultSet, exprIndex[0]) == null) {
            return null;
        }
        int type = this.getColumnMapping(0).getInt(resultSet, exprIndex[0]);
        float x = this.getColumnMapping(1).getFloat(resultSet, exprIndex[1]);
        float y = this.getColumnMapping(2).getFloat(resultSet, exprIndex[2]);
        float width = this.getColumnMapping(3).getFloat(resultSet, exprIndex[3]);
        float height = this.getColumnMapping(4).getFloat(resultSet, exprIndex[4]);
        float start = this.getColumnMapping(5).getFloat(resultSet, exprIndex[5]);
        float extent = this.getColumnMapping(6).getFloat(resultSet, exprIndex[6]);
        return new Arc2D.Float(x, y, width, height, start, extent, type);
    }
}

