/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.mapping.jgeom2mysql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.util.ByteOrder;
import oracle.spatial.util.GeometryExceptionWithContext;
import oracle.spatial.util.WKB;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.types.geospatial.rdbms.adapter.MySQLSpatialTypeInfo;
import org.datanucleus.store.types.geospatial.rdbms.mapping.mysql.MySQLSpatialRDBMSMapping;

public class JGeometryRDBMSMapping
extends MySQLSpatialRDBMSMapping {
    private WKB wkbConverter = new WKB(ByteOrder.LITTLE_ENDIAN);
    private static final SQLTypeInfo typeInfo = (SQLTypeInfo)MySQLSpatialTypeInfo.TYPEINFO_PROTOTYPE.clone();

    public JGeometryRDBMSMapping(JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column col) {
        super(mapping, storeMgr, col);
    }

    public int getJDBCType() {
        return typeInfo.getDataType();
    }

    public SQLTypeInfo getTypeInfo() {
        return typeInfo;
    }

    public Object getObject(Object rs, int exprIndex) {
        JGeometry value;
        try {
            byte[] mysqlBinary = ((ResultSet)rs).getBytes(exprIndex);
            if (((ResultSet)rs).wasNull() || mysqlBinary == null) {
                value = null;
            } else {
                value = this.wkbConverter.toJGeometry(this.mysqlBinaryToWkb(mysqlBinary));
                value.setSRID(this.mysqlBinaryToSrid(mysqlBinary));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(this.failureMessage("getObject", exprIndex, e), (Throwable)e);
        }
        catch (GeometryExceptionWithContext e) {
            throw new NucleusDataStoreException(this.failureMessage("getObject", exprIndex, (Exception)((Object)e)), (Throwable)e);
        }
        return value;
    }

    public void setObject(Object ps, int exprIndex, Object value) {
        try {
            if (value == null) {
                ((PreparedStatement)ps).setNull(exprIndex, this.getTypeInfo().getDataType(), this.getTypeInfo().getTypeName());
            } else {
                byte[] wkb = this.wkbConverter.fromJGeometry((JGeometry)value);
                int srid = ((JGeometry)value).getSRID();
                ((PreparedStatement)ps).setBytes(exprIndex, this.wkbToMysqlBinary(wkb, srid));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(this.failureMessage("setObject", value, e), (Throwable)e);
        }
        catch (GeometryExceptionWithContext e) {
            throw new NucleusDataStoreException(this.failureMessage("setObject", value, (Exception)((Object)e)), (Throwable)e);
        }
    }

    static {
        typeInfo.setTypeName("GEOMETRY");
        typeInfo.setLocalTypeName("GEOMETRY");
    }
}

