/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.adapter;

import java.sql.DatabaseMetaData;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.adapter.MySQLAdapter;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.schema.StoreSchemaHandler;
import org.datanucleus.store.types.geospatial.rdbms.adapter.SpatialRDBMSAdapter;
import org.datanucleus.store.types.geospatial.rdbms.schema.MySQLSpatialTypeInfo;

public class MySQLSpatialAdapter
extends MySQLAdapter
implements SpatialRDBMSAdapter {
    public MySQLSpatialAdapter(DatabaseMetaData metadata) {
        super(metadata);
    }

    public void initialiseTypes(StoreSchemaHandler handler, ManagedConnection mconn) {
        super.initialiseTypes(handler, mconn);
        MySQLSpatialTypeInfo sqlType = MySQLSpatialTypeInfo.TYPEINFO_PROTOTYPE;
        this.addSQLTypeForJDBCType(handler, mconn, (short)-2, sqlType, true);
    }

    @Override
    public boolean isGeometryColumn(Column c) {
        SQLTypeInfo typeInfo = c.getTypeInfo();
        if (typeInfo == null) {
            return false;
        }
        return typeInfo.getTypeName().equalsIgnoreCase("geometry") || typeInfo.getTypeName().equalsIgnoreCase("geometrycollection");
    }

    @Override
    public String getRetrieveCrsNameStatement(Table table, int srid) {
        return null;
    }

    @Override
    public String getRetrieveCrsWktStatement(Table table, int srid) {
        return null;
    }

    @Override
    public String getCalculateBoundsStatement(Table table, Column column) {
        return "SELECT min(X(PointN(ExteriorRing(Envelope(#column1)),1))), min(Y(PointN(ExteriorRing(Envelope(#column2)),1))), max(X(PointN(ExteriorRing(Envelope(#column3)),1))), max(Y(PointN(ExteriorRing(Envelope(#column4)),1))) " + "FROM #table".replace("#column", column.getIdentifier().getName()).replace("#table", table.getIdentifier().getName());
    }
}

