/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.awt.geom.Arc2D;
import java.util.StringTokenizer;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.TypeConverter;

public class Arc2dFloatStringConverter
implements TypeConverter<Arc2D.Float, String> {
    public Arc2D.Float toMemberType(String str) {
        if (str == null) {
            return null;
        }
        Arc2D.Float l = new Arc2D.Float();
        StringTokenizer tokeniser = new StringTokenizer(str, ",");
        String token = tokeniser.nextToken();
        float x = 0.0f;
        try {
            x = Float.valueOf(token).floatValue();
        }
        catch (NumberFormatException nfe) {
            throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Arc2D.Float.class.getName()), (Throwable)nfe);
        }
        token = tokeniser.nextToken();
        float y = 0.0f;
        try {
            y = Float.valueOf(token).floatValue();
        }
        catch (NumberFormatException nfe) {
            throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Arc2D.Float.class.getName()), (Throwable)nfe);
        }
        token = tokeniser.nextToken();
        float width = 0.0f;
        try {
            width = Float.valueOf(token).floatValue();
        }
        catch (NumberFormatException nfe) {
            throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Arc2D.Float.class.getName()), (Throwable)nfe);
        }
        token = tokeniser.nextToken();
        float height = 0.0f;
        try {
            height = Float.valueOf(token).floatValue();
        }
        catch (NumberFormatException nfe) {
            throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Arc2D.Float.class.getName()), (Throwable)nfe);
        }
        token = tokeniser.nextToken();
        float start = 0.0f;
        try {
            start = Float.valueOf(token).floatValue();
        }
        catch (NumberFormatException nfe) {
            throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Arc2D.Float.class.getName()), (Throwable)nfe);
        }
        token = tokeniser.nextToken();
        float extent = 0.0f;
        try {
            extent = Float.valueOf(token).floatValue();
        }
        catch (NumberFormatException nfe) {
            throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Arc2D.Float.class.getName()), (Throwable)nfe);
        }
        l.setArc(x, y, width, height, start, extent, 0);
        return l;
    }

    public String toDatastoreType(Arc2D.Float arc) {
        if (arc == null) {
            return null;
        }
        StringBuffer str = new StringBuffer();
        str.append(arc.x).append(",").append(arc.y).append(",").append(arc.width).append(",").append(arc.height);
        str.append(",").append(arc.start).append(",").append(arc.extent);
        return str.toString();
    }
}

