/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping;

import java.awt.geom.Point2D;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.SingleFieldMultiMapping;
import org.datanucleus.store.rdbms.table.Table;

public class Point2dDoubleMapping
extends SingleFieldMultiMapping {
    public void initialize(AbstractMemberMetaData fmd, Table table, ClassLoaderResolver clr) {
        super.initialize(fmd, table, clr);
        this.addColumns();
    }

    public void initialize(RDBMSStoreManager storeMgr, String type) {
        super.initialize(storeMgr, type);
        this.addColumns();
    }

    protected void addColumns() {
        this.addColumns(ClassNameConstants.DOUBLE);
        this.addColumns(ClassNameConstants.DOUBLE);
    }

    public Class getJavaType() {
        return Point2D.Double.class;
    }

    public Object getValueForDatastoreMapping(NucleusContext nucleusCtx, int index, Object value) {
        Point2D.Double pt = (Point2D.Double)value;
        if (index == 0) {
            return pt.getX();
        }
        if (index == 1) {
            return pt.getY();
        }
        throw new IndexOutOfBoundsException();
    }

    public void setObject(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, Object value) {
        Point2D.Double pt = (Point2D.Double)value;
        if (pt == null) {
            this.getDatastoreMapping(0).setObject(ps, exprIndex[0], null);
            this.getDatastoreMapping(1).setObject(ps, exprIndex[1], null);
        } else {
            this.getDatastoreMapping(0).setDouble(ps, exprIndex[0], pt.getX());
            this.getDatastoreMapping(1).setDouble(ps, exprIndex[1], pt.getY());
        }
    }

    public Object getObject(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (this.getDatastoreMapping(0).getObject(resultSet, exprIndex[0]) == null) {
            return null;
        }
        double x = this.getDatastoreMapping(0).getDouble(resultSet, exprIndex[0]);
        double y = this.getDatastoreMapping(1).getDouble(resultSet, exprIndex[1]);
        return new Point2D.Double(x, y);
    }
}

