/**********************************************************************
Copyright (c) 2006 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.enhancer;

import java.io.IOException;
import java.util.BitSet;
import java.util.Collection;

import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.identity.ByteIdentity;
import javax.jdo.identity.CharIdentity;
import javax.jdo.identity.IntIdentity;
import javax.jdo.identity.LongIdentity;
import javax.jdo.identity.ObjectIdentity;
import javax.jdo.identity.ShortIdentity;
import javax.jdo.identity.StringIdentity;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.MetaDataManager;

/**
 * Interface representation of an enhancer of a class.
 */
public interface ClassEnhancer
{
    /** Option for generating the default constructor. */
    public static final String OPTION_GENERATE_DEFAULT_CONSTRUCTOR = "generate-default-constructor";

    /** Option for generating the default constructor. */
    public static final String OPTION_GENERATE_PK = "generate-primary-key";

    /** Field name of jdoStateManager */
    public static final String FN_StateManager = "jdoStateManager";

    /** Field name of jdoFlags */
    public static final String FN_Flag = "jdoFlags";

    /** Field name of jdoFieldNames */
    public static final String FN_FieldNames = "jdoFieldNames";

    /** Field name of jdoFieldTypes */
    public static final String FN_FieldTypes = "jdoFieldTypes";

    /** Field name of jdoFieldFlags */
    public static final String FN_FieldFlags = "jdoFieldFlags";

    /** Field name of jdoPersistenceCapableSuperclass */
    public static final String FN_PersistenceCapableSuperclass = "jdoPersistenceCapableSuperclass";

    /** Field name of jdoFieldCount */
    public static final String FN_JdoInheritedFieldCount = "jdoInheritedFieldCount";

    /** Field name of jdoDetachedState */
    public static final String FN_JdoDetachedState = "jdoDetachedState";

    /** Field name of serialVersionUID */
    public static final String FN_serialVersionUID = "serialVersionUID";

    /** Method name for initialising jdoFieldNames  */
    public static final String MN_FieldNamesInitMethod = "__jdoFieldNamesInit";

    /** Method name for initialising jdoFieldTypes */
    public static final String MN_FieldTypesInitMethod = "__jdoFieldTypesInit";

    /** Method name for initialising jdoFieldFlags */
    public static final String MN_FieldFlagsInitMethod = "__jdoFieldFlagsInit";

    /** Method name for object id accessor  */
    public static final String MN_JdoGetObjectId = "jdoGetObjectId";

    /** Method name for transactional object id accessor  */
    public static final String MN_JdoGetTransactionalObjectId = "jdoGetTransactionalObjectId";

    /** Method name for version accessor  */
    public static final String MN_JdoGetVersion = "jdoGetVersion";

    /** Method name of jdoIsDetached */
    public static final String MN_JdoIsDetached = "jdoIsDetached";

    /** Method name of jdoIsDetachedInternal */
    public static final String MN_JdoIsDetachedInternal = "jdoIsDetachedInternal";

    /** Method name of jdoIsDeleted */
    public static final String MN_JdoIsDeleted = "jdoIsDeleted";

    /** Method name of jdoIsDirty */
    public static final String MN_JdoIsDirty = "jdoIsDirty";

    /** Method name of jdoIsNew */
    public static final String MN_JdoIsNew = "jdoIsNew";

    /** Method name of jdoIsPersistent */
    public static final String MN_JdoIsPersistent = "jdoIsPersistent";

    /** Method name of jdoIsTransactional */
    public static final String MN_JdoIsTransactional = "jdoIsTransactional";

    /** Method name of jdoGetPersistenceManager */
    public static final String MN_JdoGetPersistenceManager = "jdoGetPersistenceManager";

    /** Method name of jdoPreSerialize */
    public static final String MN_JdoPreSerialize = "jdoPreSerialize";

    /** Method name for __jdoGetInheritedFieldCount */
    public static final String MN_JdoGetInheritedFieldCount = "__jdoGetInheritedFieldCount";

    /** Method name for jdoSuperClone */
    public static final String MN_JdoSuperClone = "jdoSuperClone";

    /** Method name for jdoGetManagedFieldCount */
    public static final String MN_JdoGetManagedFieldCount = "jdoGetManagedFieldCount";

    /** Method name for __jdoPersistenceCapableSuperclassInit */
    public static final String MN_JdoPersistenceCapableSuperclassInit = "__jdoPersistenceCapableSuperclassInit";

    /** Method name of jdoLoadClass */
    public static final String MN_jdoLoadClass = "___jdo$loadClass";

    /** Method name of jdoCopyField */
    public static final String MN_JdoCopyField = "jdoCopyField";

    /** Method name of jdoCopyFields */
    public static final String MN_JdoCopyFields = "jdoCopyFields";

    /** Method name of jdoCopyFieldsFromObjectId */
    public static final String MN_JdoCopyKeyFieldsFromObjectId = "jdoCopyKeyFieldsFromObjectId";

    /** Method name of jdoCopyFieldsToObjectId */
    public static final String MN_JdoCopyKeyFieldsToObjectId = "jdoCopyKeyFieldsToObjectId";

    /** Method name of jdoProvideField */
    public static final String MN_JdoProvideField = "jdoProvideField";

    /** Method name of jdoProvideFields */
    public static final String MN_JdoProvideFields = "jdoProvideFields";

    /** Method name of jdoReplaceField */
    public static final String MN_JdoReplaceField = "jdoReplaceField";

    /** Method name of jdoReplaceFields. */
    public static final String MN_JdoReplaceFields = "jdoReplaceFields";

    /** Method name of jdoReplaceFlags. */
    public static final String MN_JdoReplaceFlags = "jdoReplaceFlags";

    /** Method name of jdoReplaceStateManager. */
    public static final String MN_JdoReplaceStateManager = "jdoReplaceStateManager";

    /** Method name of jdoReplaceDetachedState. */
    public static final String MN_JdoReplaceDetachedState = "jdoReplaceDetachedState";

    /** Method name of jdoMakeDirty. */
    public static final String MN_JdoMakeDirty = "jdoMakeDirty";

    /** Method name of jdoMakeDirtyDetached. */
    public static final String MN_JdoMakeDirtyDetached = "jdoMakeDirtyDetached";

    /** Method name of jdoNewInstance. */
    public static final String MN_JdoNewInstance = "jdoNewInstance";

    /** Method name of jdoNewObjectIdInstance. */
    public static final String MN_JdoNewObjectIdInstance = "jdoNewObjectIdInstance";

    /** Class name of javax.jdo.spi.StateManager */
    public static final String CN_StateManager = StateManager.class.getName();

    /** Class name of java.jdo.spi.PersistenceCapable */
    public static final String CN_PersistenceCapable = PersistenceCapable.class.getName();

    /** Class name of java.jdo.spi.Detachable */
    public static final String CN_Detachable = Detachable.class.getName();

    /** Class name of javax.jdo.JDOHelper */
    public static final String CN_JDOHelper = JDOHelper.class.getName();
    
    /** Class name of javax.jdo.spi.JDOImplHelper */
    public static final String CN_JDOImplHelper = JDOImplHelper.class.getName();
    
    /** Class name of javax.jdo.JDOFatalInternalException */
    public static final String CN_JDOFatalInternalException = JDOFatalInternalException.class.getName();

    /** Class name of java.util.BitSet */
    public static final String CN_BitSet = BitSet.class.getName();

    /** Class name of java.lang.Class */
    public static final String CN_Class = Class.class.getName();

    /** Class name of SingleFieldIdentity classes */
    public static final String CN_StringIdentity = StringIdentity.class.getName();
    public static final String CN_LongIdentity = LongIdentity.class.getName();
    public static final String CN_IntIdentity = IntIdentity.class.getName();
    public static final String CN_ShortIdentity = ShortIdentity.class.getName();
    public static final String CN_ByteIdentity = ByteIdentity.class.getName();
    public static final String CN_CharIdentity = CharIdentity.class.getName();
    public static final String CN_ObjectIdentity = ObjectIdentity.class.getName();

    /** Class name of javax.jdo.PersistenceManager */
    public static final String CN_PersistenceManager = PersistenceManager.class.getName();

    /** Class name of javax.jdo.spi.PersistenceCapable.ObjectIdFieldConsumer */
    public static final String CN_ObjectIdFieldConsumer = PersistenceCapable.ObjectIdFieldConsumer.class.getName();

    /** Class name of javax.jdo.spi.PersistenceCapable.ObjectIdFieldSupplier */
    public static final String CN_ObjectIdFieldSupplier = PersistenceCapable.ObjectIdFieldSupplier.class.getName();

    /** Class name of java.lang.IllegalArgumentException */
    public static final String CN_IllegalArgumentException = IllegalArgumentException.class.getName();

    /** Class name of java.lang.ClassCastException */
    public static final String CN_ClassCastException = ClassCastException.class.getName();
    
    /** Class name of javax.jdo.JDODetachedFieldAccessException */
    public static final String CN_JDODetachedFieldAccessException = JDODetachedFieldAccessException.class.getName();
    
    /** Class name of java.lang.IllegalStateException */
    public static final String CN_IllegalStateException = IllegalStateException.class.getName();

    /**
     * Method to set the options controlling the enhancement.
     * @param options The options
     */
    void setOptions(Collection<String> options);

    /**
     * Accessor for whether a particular option is enabled.
     * @param name Name of the option
     * @return Whether it has this option
     */
    boolean hasOption(String name);

    /**
     * Validate whether the class is enhanced.
     * @return Return true if already enhanced class.
     */
    boolean validate();

    /**
     * Method to enhance the class definition internally.
     * @return Whether the class was enhanced successfully
     */
    boolean enhance();

    /**
     * Method to save the (current) class definition bytecode into a class file.
     * Only has effect if the bytecode has been modified (by enhance()).
     * If directoryName is specified it will be written to $directoryName/className.class
     * else will overwrite the existing class.
     * @param directoryName Name of a directory (or null to overwrite the class)
     * @throws IOException If an I/O error occurs in the write.
     */
    void save(String directoryName) throws IOException;

    /**
     * Access the class bytecode.
     * @return the class in byte array format
     */
    byte[] getClassBytes();

    /**
     * Access the generated primary-key class bytecode.
     * @return the primary-key class in byte array format
     */
    byte[] getPrimaryKeyClassBytes();

    /**
     * Accessor for the MetaData manager in use.
     * @return MetaData manager
     */
    MetaDataManager getMetaDataManager();

    /**
     * Accessor for the ClassLoaderResolver in use.
     * @return ClassLoader resolver
     */
    ClassLoaderResolver getClassLoaderResolver();

    /**
     * Accessor for the ClassMetaData for the class.
     * @return MetaData for the class
     */
    ClassMetaData getClassMetaData();
}