/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra.fieldmanager;

import com.datastax.driver.core.Row;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.metadata.JdbcType;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.cassandra.CassandraUtils;
import org.datanucleus.store.cassandra.fieldmanager.FetchEmbeddedFieldManager;
import org.datanucleus.store.fieldmanager.AbstractFetchFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.converters.MultiColumnConverter;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.TypeConversionHelper;

public class FetchFieldManager
extends AbstractFetchFieldManager {
    protected Table table;
    protected Row row;

    public FetchFieldManager(ObjectProvider op, Row row, Table table) {
        super(op);
        this.table = table;
        this.row = row;
    }

    public FetchFieldManager(ExecutionContext ec, Row row, AbstractClassMetaData cmd, Table table) {
        super(ec, cmd);
        this.table = table;
        this.row = row;
    }

    protected MemberColumnMapping getColumnMapping(int fieldNumber) {
        return this.table.getMemberColumnMappingForMember(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
    }

    public boolean fetchBooleanField(int fieldNumber) {
        return this.row.getBool(this.getColumnMapping(fieldNumber).getColumn(0).getName());
    }

    public char fetchCharField(int fieldNumber) {
        return this.row.getString(this.getColumnMapping(fieldNumber).getColumn(0).getName()).charAt(0);
    }

    public byte fetchByteField(int fieldNumber) {
        return (byte)this.row.getInt(this.getColumnMapping(fieldNumber).getColumn(0).getName());
    }

    public short fetchShortField(int fieldNumber) {
        return (short)this.row.getInt(this.getColumnMapping(fieldNumber).getColumn(0).getName());
    }

    public int fetchIntField(int fieldNumber) {
        return this.row.getInt(this.getColumnMapping(fieldNumber).getColumn(0).getName());
    }

    public long fetchLongField(int fieldNumber) {
        return this.row.getLong(this.getColumnMapping(fieldNumber).getColumn(0).getName());
    }

    public float fetchFloatField(int fieldNumber) {
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        if (col.getJdbcType() == JdbcType.DECIMAL) {
            return this.row.getDecimal(col.getName()).floatValue();
        }
        if (col.getJdbcType() == JdbcType.DOUBLE) {
            return (float)this.row.getDouble(col.getName());
        }
        return this.row.getFloat(col.getName());
    }

    public double fetchDoubleField(int fieldNumber) {
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        if (col.getJdbcType() == JdbcType.DECIMAL) {
            return this.row.getDecimal(col.getName()).doubleValue();
        }
        return this.row.getDouble(this.getColumnMapping(fieldNumber).getColumn(0).getName());
    }

    public String fetchStringField(int fieldNumber) {
        return this.row.getString(this.getColumnMapping(fieldNumber).getColumn(0).getName());
    }

    public Object fetchObjectField(int fieldNumber) {
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        RelationType relationType = mmd.getRelationType(clr);
        if (relationType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(this.ec.getMetaDataManager(), clr, mmd, relationType, null)) {
            if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>();
                embMmds.add(mmd);
                AbstractClassMetaData embCmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
                ObjectProvider embOP = this.ec.getNucleusContext().getObjectProviderFactory().newForEmbedded(this.ec, embCmd, this.op, fieldNumber);
                FetchEmbeddedFieldManager fetchEmbFM = new FetchEmbeddedFieldManager(embOP, this.row, embMmds, this.table);
                embOP.replaceFields(embCmd.getAllMemberPositions(), (FieldManager)fetchEmbFM);
                return embOP.getObject();
            }
            if (RelationType.isRelationMultiValued((RelationType)relationType)) {
                NucleusLogger.PERSISTENCE.debug((Object)("Field=" + mmd.getFullFieldName() + " not currently supported (embedded)"));
                return null;
            }
        }
        return this.fetchNonEmbeddedObjectField(mmd, relationType, clr);
    }

    protected Object fetchNonEmbeddedObjectField(AbstractMemberMetaData mmd, RelationType relationType, ClassLoaderResolver clr) {
        int fieldNumber = mmd.getAbsoluteFieldNumber();
        MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
        boolean optional = false;
        if (Optional.class.isAssignableFrom(mmd.getType())) {
            if (relationType != RelationType.NONE) {
                relationType = RelationType.ONE_TO_ONE_UNI;
            }
            optional = true;
        }
        if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            if (this.row.isNull(mapping.getColumn(0).getName())) {
                return optional ? Optional.empty() : null;
            }
            if (mmd.isSerialized()) {
                ByteBuffer datastoreBuffer;
                TypeConverter serialConv = this.ec.getTypeManager().getTypeConverterForType(Serializable.class, ByteBuffer.class);
                Object value = serialConv.toMemberType((Object)(datastoreBuffer = this.row.getBytes(mapping.getColumn(0).getName())));
                ObjectProvider pcOP = this.ec.findObjectProvider(value);
                if (pcOP == null || this.ec.getApiAdapter().getExecutionContext(value) == null) {
                    this.ec.getNucleusContext().getObjectProviderFactory().newForEmbedded(this.ec, value, false, this.op, fieldNumber);
                }
                return value;
            }
            String value = this.row.getString(mapping.getColumn(0).getName());
            Optional<Object> memberValue = this.getValueForSingleRelationField(mmd, value, clr);
            return optional ? Optional.of(memberValue) : memberValue;
        }
        if (RelationType.isRelationMultiValued((RelationType)relationType)) {
            Collection value = null;
            if (mmd.hasCollection()) {
                Class elementCls;
                Class clazz = elementCls = mmd.getCollection().isSerializedElement() ? ByteBuffer.class : String.class;
                value = Set.class.isAssignableFrom(mmd.getType()) ? this.row.getSet(mapping.getColumn(0).getName(), elementCls) : (List.class.isAssignableFrom(mmd.getType()) || mmd.getOrderMetaData() != null ? this.row.getList(mapping.getColumn(0).getName(), elementCls) : this.row.getSet(mapping.getColumn(0).getName(), elementCls));
            } else if (mmd.hasMap()) {
                Class keyCls = clr.classForName(mmd.getMap().getKeyType());
                if (mmd.getMap().keyIsPersistent()) {
                    keyCls = mmd.getMap().isSerializedKey() ? ByteBuffer.class : String.class;
                }
                Class valCls = clr.classForName(mmd.getMap().getValueType());
                if (mmd.getMap().valueIsPersistent()) {
                    valCls = mmd.getMap().isSerializedValue() ? ByteBuffer.class : String.class;
                }
                value = this.row.getMap(mapping.getColumn(0).getName(), keyCls, valCls);
            } else if (mmd.hasArray()) {
                value = this.row.getList(mapping.getColumn(0).getName(), String.class);
            }
            return this.getValueForContainerRelationField(mmd, value, clr);
        }
        if (mapping.getTypeConverter() != null && !mmd.isSerialized()) {
            if (mapping.getNumberOfColumns() > 1) {
                boolean allNull = true;
                for (int i = 0; i < mapping.getNumberOfColumns(); ++i) {
                    if (this.row.isNull(mapping.getColumn(i).getName())) continue;
                    allNull = false;
                }
                if (allNull) {
                    return optional ? Optional.empty() : null;
                }
                Object[] valuesArr = null;
                Class[] colTypes = ((MultiColumnConverter)mapping.getTypeConverter()).getDatastoreColumnTypes();
                valuesArr = colTypes[0] == Integer.TYPE ? new int[mapping.getNumberOfColumns()] : (colTypes[0] == Long.TYPE ? (Object[])new long[mapping.getNumberOfColumns()] : (colTypes[0] == Double.TYPE ? (Object[])new double[mapping.getNumberOfColumns()] : (colTypes[0] == Float.TYPE ? (Object[])new double[mapping.getNumberOfColumns()] : (colTypes[0] == String.class ? (Object[])new String[mapping.getNumberOfColumns()] : (Object[])new Object[mapping.getNumberOfColumns()]))));
                boolean isNull = true;
                for (int i = 0; i < mapping.getNumberOfColumns(); ++i) {
                    Column col = mapping.getColumn(i);
                    if (col.getTypeName().equals("int")) {
                        Array.set(valuesArr, i, this.row.getInt(col.getName()));
                    } else if (col.getTypeName().equals("bool")) {
                        Array.set(valuesArr, i, this.row.getBool(col.getName()));
                    } else if (col.getTypeName().equals("timestamp")) {
                        Array.set(valuesArr, i, this.row.getTimestamp(col.getName()));
                    } else if (col.getTypeName().equals("decimal")) {
                        Array.set(valuesArr, i, this.row.getDecimal(col.getName()));
                    } else if (col.getTypeName().equals("double")) {
                        Array.set(valuesArr, i, this.row.getDouble(col.getName()));
                    } else if (col.getTypeName().equals("float")) {
                        Array.set(valuesArr, i, Float.valueOf(this.row.getFloat(col.getName())));
                    } else if (col.getTypeName().equals("bigint")) {
                        Array.set(valuesArr, i, this.row.getLong(col.getName()));
                    } else {
                        Array.set(valuesArr, i, this.row.getString(col.getName()));
                    }
                    if (!isNull || Array.get(valuesArr, i) == null) continue;
                    isNull = false;
                }
                if (isNull) {
                    return null;
                }
                return mapping.getTypeConverter().toMemberType((Object)valuesArr);
            }
            if (this.row.isNull(mapping.getColumn(0).getName())) {
                return optional ? Optional.empty() : null;
            }
            Object returnValue = CassandraUtils.getMemberValueForColumnWithConverter(this.row, mapping.getColumn(0), mapping.getTypeConverter());
            if (this.op != null) {
                returnValue = SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)mmd.getAbsoluteFieldNumber(), (Object)returnValue, (boolean)true);
            }
            return returnValue;
        }
        if (!optional && mmd.hasCollection()) {
            Collection coll;
            if (mmd.isSerialized()) {
                TypeConverter serialConv = this.ec.getTypeManager().getTypeConverterForType(Serializable.class, ByteBuffer.class);
                ByteBuffer datastoreBuffer = this.row.getBytes(mapping.getColumn(0).getName());
                if (datastoreBuffer == null) {
                    return null;
                }
                Object returnValue = serialConv.toMemberType((Object)datastoreBuffer);
                returnValue = this.op != null ? (Collection)SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)mmd.getAbsoluteFieldNumber(), (Object)returnValue, (boolean)true) : returnValue;
            }
            try {
                Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                coll = (Collection)instanceType.newInstance();
            }
            catch (Exception e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            if (!this.row.isNull(mapping.getColumn(0).getName())) {
                TypeConverter elemConv = mapping.getTypeConverterForComponent(FieldRole.ROLE_COLLECTION_ELEMENT);
                Class elemCls = clr.classForName(mmd.getCollection().getElementType());
                String elemCassType = CassandraUtils.getCassandraTypeForNonPersistableType(elemCls, false, this.ec.getTypeManager(), null, mmd, FieldRole.ROLE_COLLECTION_ELEMENT, clr);
                Class cassElemCls = CassandraUtils.getJavaTypeForCassandraType(elemCassType);
                Collection cassColl = null;
                cassColl = Set.class.isAssignableFrom(mmd.getType()) ? this.row.getSet(mapping.getColumn(0).getName(), cassElemCls) : (List.class.isAssignableFrom(mmd.getType()) || mmd.getOrderMetaData() != null ? this.row.getList(mapping.getColumn(0).getName(), cassElemCls) : this.row.getSet(mapping.getColumn(0).getName(), cassElemCls));
                if (cassColl != null) {
                    for (Object cassElem : cassColl) {
                        Object elem = null;
                        elem = elemConv != null ? elemConv.toMemberType(cassElem) : CassandraUtils.getJavaValueForDatastoreValue(cassElem, elemCassType, elemCls, this.ec);
                        coll.add(elem);
                    }
                }
            }
            if (this.op != null) {
                coll = (Collection)SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)mmd.getAbsoluteFieldNumber(), (Object)coll, (boolean)true);
            }
            return coll;
        }
        if (!optional && mmd.hasMap()) {
            Map map;
            if (mmd.isSerialized()) {
                TypeConverter serialConv = this.ec.getTypeManager().getTypeConverterForType(Serializable.class, ByteBuffer.class);
                ByteBuffer datastoreBuffer = this.row.getBytes(mapping.getColumn(0).getName());
                if (datastoreBuffer == null) {
                    return null;
                }
                Object returnValue = serialConv.toMemberType((Object)datastoreBuffer);
                returnValue = this.op != null ? SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)mmd.getAbsoluteFieldNumber(), (Object)returnValue, (boolean)true) : returnValue;
            }
            try {
                Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), null);
                map = (Map)instanceType.newInstance();
            }
            catch (Exception e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            if (!this.row.isNull(mapping.getColumn(0).getName())) {
                TypeConverter keyConv = mapping.getTypeConverterForComponent(FieldRole.ROLE_MAP_KEY);
                TypeConverter valConv = mapping.getTypeConverterForComponent(FieldRole.ROLE_MAP_VALUE);
                Class keyCls = clr.classForName(mmd.getMap().getKeyType());
                String keyCassType = CassandraUtils.getCassandraTypeForNonPersistableType(keyCls, false, this.ec.getTypeManager(), null, mmd, FieldRole.ROLE_MAP_KEY, clr);
                Class cassKeyCls = CassandraUtils.getJavaTypeForCassandraType(keyCassType);
                Class valCls = clr.classForName(mmd.getMap().getValueType());
                String valCassType = CassandraUtils.getCassandraTypeForNonPersistableType(valCls, false, this.ec.getTypeManager(), null, mmd, FieldRole.ROLE_MAP_VALUE, clr);
                Class cassValCls = CassandraUtils.getJavaTypeForCassandraType(valCassType);
                Map cassMap = this.row.getMap(mapping.getColumn(0).getName(), cassKeyCls, cassValCls);
                if (cassMap != null) {
                    for (Map.Entry cassMapEntry : cassMap.entrySet()) {
                        Object key = null;
                        key = keyConv != null ? keyConv.toMemberType(cassMapEntry.getKey()) : CassandraUtils.getJavaValueForDatastoreValue(cassMapEntry.getKey(), cassKeyCls.getName(), keyCls, this.ec);
                        Object val = null;
                        val = valConv != null ? valConv.toMemberType(cassMapEntry.getValue()) : CassandraUtils.getJavaValueForDatastoreValue(cassMapEntry.getValue(), cassValCls.getName(), valCls, this.ec);
                        map.put(key, val);
                    }
                }
            }
            if (this.op != null) {
                map = (Map)SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)mmd.getAbsoluteFieldNumber(), (Object)map, (boolean)true);
            }
            return map;
        }
        if (!optional && mmd.hasArray()) {
            if (this.row.isNull(mapping.getColumn(0).getName())) {
                return null;
            }
            if (mmd.isSerialized()) {
                TypeConverter serialConv = null;
                serialConv = mmd.getType() == byte[].class ? this.ec.getTypeManager().getTypeConverterForType(byte[].class, ByteBuffer.class) : this.ec.getTypeManager().getTypeConverterForType(Serializable.class, ByteBuffer.class);
                ByteBuffer datastoreBuffer = this.row.getBytes(mapping.getColumn(0).getName());
                return serialConv.toMemberType((Object)datastoreBuffer);
            }
            NucleusLogger.DATASTORE_RETRIEVE.warn((Object)("Field=" + mmd.getFullFieldName() + " has datastore array; not supported yet"));
            return null;
        }
        if (this.row.isNull(mapping.getColumn(0).getName())) {
            return optional ? Optional.empty() : null;
        }
        Class type = mmd.getType();
        if (optional) {
            type = clr.classForName(mmd.getCollection().getElementType());
        }
        Object value = null;
        if (mmd.isSerialized()) {
            TypeConverter serialConv = this.ec.getTypeManager().getTypeConverterForType(Serializable.class, ByteBuffer.class);
            ByteBuffer datastoreBuffer = this.row.getBytes(mapping.getColumn(0).getName());
            value = serialConv.toMemberType((Object)datastoreBuffer);
        } else if (BigInteger.class.isAssignableFrom(type)) {
            value = BigInteger.valueOf(this.row.getLong(mapping.getColumn(0).getName()));
        } else if (BigDecimal.class.isAssignableFrom(type)) {
            value = this.row.getDecimal(mapping.getColumn(0).getName());
        } else if (Byte.class.isAssignableFrom(type)) {
            value = (byte)this.row.getInt(mapping.getColumn(0).getName());
        } else if (String.class.isAssignableFrom(type)) {
            value = this.row.getString(mapping.getColumn(0).getName());
        } else if (Character.class.isAssignableFrom(type)) {
            value = Character.valueOf(this.row.getString(mapping.getColumn(0).getName()).charAt(0));
        } else if (Double.class.isAssignableFrom(type)) {
            value = this.row.getDouble(mapping.getColumn(0).getName());
        } else if (Float.class.isAssignableFrom(type)) {
            value = Float.valueOf(this.row.getFloat(mapping.getColumn(0).getName()));
        } else if (Long.class.isAssignableFrom(type)) {
            value = this.row.getLong(mapping.getColumn(0).getName());
        } else if (Integer.class.isAssignableFrom(type)) {
            value = this.row.getInt(mapping.getColumn(0).getName());
        } else if (Short.class.isAssignableFrom(type)) {
            value = (short)this.row.getInt(mapping.getColumn(0).getName());
        } else if (Boolean.class.isAssignableFrom(type)) {
            value = this.row.getBool(mapping.getColumn(0).getName());
        } else if (Enum.class.isAssignableFrom(type)) {
            JdbcType jdbcType = TypeConversionHelper.getJdbcTypeForEnum((AbstractMemberMetaData)mmd, (FieldRole)FieldRole.ROLE_FIELD, (ClassLoaderResolver)clr);
            Object datastoreValue = MetaDataUtils.isJdbcTypeNumeric((JdbcType)jdbcType) ? Integer.valueOf(this.row.getInt(mapping.getColumn(0).getName())) : this.row.getString(mapping.getColumn(0).getName());
            value = TypeConversionHelper.getEnumForStoredValue((AbstractMemberMetaData)mmd, (FieldRole)FieldRole.ROLE_FIELD, (Object)datastoreValue, (ClassLoaderResolver)clr);
        } else if (Date.class.isAssignableFrom(type)) {
            if (mapping.getColumn(0).getTypeName().equals("varchar")) {
                TypeConverter stringConverter = this.ec.getTypeManager().getTypeConverterForType(type, String.class);
                if (stringConverter != null) {
                    value = stringConverter.toMemberType((Object)this.row.getString(mapping.getColumn(0).getName()));
                }
            } else {
                value = new Date(this.row.getTimestamp(mapping.getColumn(0).getName()).getTime());
            }
        } else if (Time.class.isAssignableFrom(type)) {
            if (mapping.getColumn(0).getTypeName().equals("varchar")) {
                TypeConverter stringConverter = this.ec.getTypeManager().getTypeConverterForType(type, String.class);
                if (stringConverter != null) {
                    value = stringConverter.toMemberType((Object)this.row.getString(mapping.getColumn(0).getName()));
                }
            } else {
                value = new Time(this.row.getTimestamp(mapping.getColumn(0).getName()).getTime());
            }
        } else if (Timestamp.class.isAssignableFrom(type)) {
            if (mapping.getColumn(0).getTypeName().equals("varchar")) {
                TypeConverter stringConverter = this.ec.getTypeManager().getTypeConverterForType(type, String.class);
                if (stringConverter != null) {
                    value = stringConverter.toMemberType((Object)this.row.getString(mapping.getColumn(0).getName()));
                }
            } else {
                value = new Timestamp(this.row.getTimestamp(mapping.getColumn(0).getName()).getTime());
            }
        } else if (Calendar.class.isAssignableFrom(type)) {
            if (mapping.getColumn(0).getTypeName().equals("varchar")) {
                TypeConverter stringConverter = this.ec.getTypeManager().getTypeConverterForType(type, String.class);
                if (stringConverter != null) {
                    value = stringConverter.toMemberType((Object)this.row.getString(mapping.getColumn(0).getName()));
                }
            } else {
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.row.getTimestamp(mapping.getColumn(0).getName()));
                value = cal;
            }
        } else if (java.util.Date.class.isAssignableFrom(type)) {
            if (mapping.getColumn(0).getTypeName().equals("varchar")) {
                TypeConverter stringConverter = this.ec.getTypeManager().getTypeConverterForType(type, String.class);
                if (stringConverter != null) {
                    value = stringConverter.toMemberType((Object)this.row.getString(mapping.getColumn(0).getName()));
                }
            } else {
                value = new java.util.Date(this.row.getTimestamp(mapping.getColumn(0).getName()).getTime());
            }
        } else if (UUID.class.isAssignableFrom(type)) {
            value = this.row.getUUID(mapping.getColumn(0).getName());
        } else {
            TypeConverter stringConverter = this.ec.getTypeManager().getTypeConverterForType(type, String.class);
            if (stringConverter != null) {
                value = stringConverter.toMemberType((Object)this.row.getString(mapping.getColumn(0).getName()));
            } else {
                TypeConverter longConverter = this.ec.getTypeManager().getTypeConverterForType(type, Long.class);
                if (longConverter != null) {
                    value = longConverter.toMemberType((Object)this.row.getLong(mapping.getColumn(0).getName()));
                }
            }
        }
        return optional ? Optional.of(value) : value;
    }

    protected Object getValueForSingleRelationField(AbstractMemberMetaData mmd, Object value, ClassLoaderResolver clr) {
        if (value == null) {
            return null;
        }
        Class type = mmd.getType();
        if (Optional.class.isAssignableFrom(mmd.getType())) {
            type = clr.classForName(mmd.getCollection().getElementType());
        }
        String persistableId = (String)value;
        try {
            AbstractClassMetaData mmdCmd = this.ec.getMetaDataManager().getMetaDataForClass(type, clr);
            if (mmdCmd != null) {
                return IdentityUtils.getObjectFromPersistableIdentity((String)persistableId, (AbstractClassMetaData)mmdCmd, (ExecutionContext)this.ec);
            }
            String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(mmd, FieldRole.ROLE_FIELD, clr, this.ec.getMetaDataManager());
            if (implNames != null && implNames.length == 1) {
                mmdCmd = this.ec.getMetaDataManager().getMetaDataForClass(implNames[0], clr);
                return IdentityUtils.getObjectFromPersistableIdentity((String)persistableId, (AbstractClassMetaData)mmdCmd, (ExecutionContext)this.ec);
            }
            if (implNames != null && implNames.length > 1) {
                for (String implName : implNames) {
                    try {
                        mmdCmd = this.ec.getMetaDataManager().getMetaDataForClass(implName, clr);
                        return IdentityUtils.getObjectFromPersistableIdentity((String)persistableId, (AbstractClassMetaData)mmdCmd, (ExecutionContext)this.ec);
                    }
                    catch (NucleusObjectNotFoundException nonfe) {
                        throw nonfe;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            throw new NucleusUserException("We do not currently support the field type of " + mmd.getFullFieldName() + " which has an interdeterminate type (e.g interface or Object element types)");
        }
        catch (NucleusObjectNotFoundException onfe) {
            NucleusLogger.PERSISTENCE.warn((Object)("Object=" + this.op + " field=" + mmd.getFullFieldName() + " has id=" + persistableId + " but could not instantiate object with that identity"));
            return null;
        }
    }

    protected Object getValueForContainerRelationField(AbstractMemberMetaData mmd, Object value, ClassLoaderResolver clr) {
        if (mmd.hasCollection()) {
            List newColl;
            Collection coll;
            try {
                Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                coll = (Collection)instanceType.newInstance();
            }
            catch (Exception e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            AbstractClassMetaData elemCmd = mmd.getCollection().getElementClassMetaData(clr);
            if (elemCmd == null) {
                String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(mmd, FieldRole.ROLE_COLLECTION_ELEMENT, clr, this.ec.getMetaDataManager());
                if (implNames != null && implNames.length > 0) {
                    elemCmd = this.ec.getMetaDataManager().getMetaDataForClass(implNames[0], clr);
                }
                if (elemCmd == null) {
                    throw new NucleusUserException("We do not currently support the field type of " + mmd.getFullFieldName() + " which has a collection of interdeterminate element type (e.g interface or Object element types)");
                }
            }
            Collection collIds = (Collection)value;
            Iterator idIter = collIds.iterator();
            boolean changeDetected = false;
            while (idIter.hasNext()) {
                String persistableId = (String)idIter.next();
                if (persistableId.equals("NULL")) {
                    coll.add(null);
                    continue;
                }
                try {
                    coll.add(IdentityUtils.getObjectFromPersistableIdentity((String)persistableId, (AbstractClassMetaData)elemCmd, (ExecutionContext)this.ec));
                }
                catch (NucleusObjectNotFoundException onfe) {
                    changeDetected = true;
                }
            }
            if (coll instanceof List && mmd.getOrderMetaData() != null && mmd.getOrderMetaData().getOrdering() != null && !mmd.getOrderMetaData().getOrdering().equals("#PK") && (newColl = QueryUtils.orderCandidates((List)((List)coll), (Class)clr.classForName(mmd.getCollection().getElementType()), (String)mmd.getOrderMetaData().getOrdering(), (ExecutionContext)this.ec, (ClassLoaderResolver)clr)).getClass() != coll.getClass()) {
                coll.clear();
                coll.addAll(newColl);
            }
            if (this.op != null) {
                coll = (Collection)SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)mmd.getAbsoluteFieldNumber(), (Object)coll, (boolean)true);
                if (changeDetected) {
                    this.op.makeDirty(mmd.getAbsoluteFieldNumber());
                }
            }
            return coll;
        }
        if (mmd.hasMap()) {
            Map map;
            try {
                Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)false);
                map = (Map)instanceType.newInstance();
            }
            catch (Exception e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            Map mapIds = (Map)value;
            AbstractClassMetaData keyCmd = null;
            if (mmd.getMap().keyIsPersistent() && (keyCmd = mmd.getMap().getKeyClassMetaData(clr)) == null) {
                String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(mmd, FieldRole.ROLE_MAP_KEY, clr, this.ec.getMetaDataManager());
                if (implNames != null && implNames.length == 1) {
                    keyCmd = this.ec.getMetaDataManager().getMetaDataForClass(implNames[0], clr);
                }
                if (keyCmd == null) {
                    throw new NucleusUserException("We do not currently support the field type of " + mmd.getFullFieldName() + " which has a map of interdeterminate key type (e.g interface or Object element types)");
                }
            }
            AbstractClassMetaData valCmd = null;
            if (mmd.getMap().valueIsPersistent() && (valCmd = mmd.getMap().getValueClassMetaData(clr)) == null) {
                String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(mmd, FieldRole.ROLE_MAP_VALUE, clr, this.ec.getMetaDataManager());
                if (implNames != null && implNames.length == 1) {
                    valCmd = this.ec.getMetaDataManager().getMetaDataForClass(implNames[0], clr);
                }
                if (valCmd == null) {
                    throw new NucleusUserException("We do not currently support the field type of " + mmd.getFullFieldName() + " which has a map of interdeterminate value type (e.g interface or Object element types)");
                }
            }
            Iterator entryIter = mapIds.entrySet().iterator();
            boolean changeDetected = false;
            while (entryIter.hasNext()) {
                Map.Entry entry = entryIter.next();
                Object key = null;
                Object val = null;
                boolean keySet = true;
                boolean valSet = true;
                if (mmd.getMap().keyIsPersistent()) {
                    String keyPersistableId = (String)entry.getKey();
                    try {
                        key = IdentityUtils.getObjectFromPersistableIdentity((String)keyPersistableId, (AbstractClassMetaData)keyCmd, (ExecutionContext)this.ec);
                    }
                    catch (NucleusObjectNotFoundException onfe) {
                        changeDetected = true;
                        keySet = false;
                    }
                } else {
                    key = entry.getKey();
                }
                if (mmd.getMap().valueIsPersistent()) {
                    String valPersistableId = (String)entry.getValue();
                    if (!valPersistableId.equals("NULL")) {
                        try {
                            val = IdentityUtils.getObjectFromPersistableIdentity((String)valPersistableId, (AbstractClassMetaData)valCmd, (ExecutionContext)this.ec);
                        }
                        catch (NucleusObjectNotFoundException onfe) {
                            changeDetected = true;
                            valSet = false;
                        }
                    }
                } else {
                    val = entry.getValue();
                }
                if (!keySet || !valSet) continue;
                map.put(key, val);
            }
            if (this.op != null) {
                map = (Map)SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)mmd.getAbsoluteFieldNumber(), (Object)map, (boolean)true);
                if (changeDetected) {
                    this.op.makeDirty(mmd.getAbsoluteFieldNumber());
                }
            }
            return map;
        }
        if (mmd.hasArray()) {
            AbstractClassMetaData elemCmd = mmd.getArray().getElementClassMetaData(clr);
            if (elemCmd == null) {
                String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(mmd, FieldRole.ROLE_ARRAY_ELEMENT, clr, this.ec.getMetaDataManager());
                if (implNames != null && implNames.length == 1) {
                    elemCmd = this.ec.getMetaDataManager().getMetaDataForClass(implNames[0], clr);
                }
                if (elemCmd == null) {
                    throw new NucleusUserException("We do not currently support the field type of " + mmd.getFullFieldName() + " which has an array of interdeterminate element type (e.g interface or Object element types)");
                }
            }
            Collection collIds = (Collection)value;
            Object array = Array.newInstance(mmd.getType().getComponentType(), collIds.size());
            Iterator idIter = collIds.iterator();
            boolean changeDetected = false;
            int pos = 0;
            while (idIter.hasNext()) {
                String persistableId = (String)idIter.next();
                if (persistableId.equals("NULL")) {
                    Array.set(array, pos++, null);
                    continue;
                }
                try {
                    Array.set(array, pos++, IdentityUtils.getObjectFromPersistableIdentity((String)persistableId, (AbstractClassMetaData)elemCmd, (ExecutionContext)this.ec));
                }
                catch (NucleusObjectNotFoundException onfe) {
                    changeDetected = true;
                }
            }
            if (changeDetected) {
                if (pos < collIds.size()) {
                    Object arrayOld = array;
                    array = Array.newInstance(mmd.getType().getComponentType(), pos);
                    for (int j = 0; j < pos; ++j) {
                        Array.set(array, j, Array.get(arrayOld, j));
                    }
                }
                if (this.op != null) {
                    this.op.makeDirty(mmd.getAbsoluteFieldNumber());
                }
            }
            return array;
        }
        return value;
    }
}

