/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra;

import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.IndexMetadata;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TableMetadata;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.ConstraintMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.cassandra.CassandraStoreManager;
import org.datanucleus.store.cassandra.SchemaVerifierImpl;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.schema.AbstractStoreSchemaHandler;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.schema.naming.NamingFactory;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.store.schema.table.CompleteClassTable;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.SchemaVerifier;
import org.datanucleus.store.schema.table.SurrogateColumnType;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class CassandraSchemaHandler
extends AbstractStoreSchemaHandler {
    public CassandraSchemaHandler(CassandraStoreManager storeMgr) {
        super((StoreManager)storeMgr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDatabase(String catalogName, String schemaName, Properties props, Object connection) {
        Session session = (Session)connection;
        ManagedConnection mconn = null;
        try {
            Boolean durable;
            if (session == null) {
                mconn = this.storeMgr.getConnectionManager().getConnection(-1);
                session = (Session)mconn.getConnection();
            }
            StringBuilder stmtBuilder = new StringBuilder("CREATE KEYSPACE IF NOT EXISTS ");
            stmtBuilder.append(schemaName).append(" WITH ");
            String replicationProp = props != null ? (String)props.get("replication") : "{'class': 'SimpleStrategy', 'replication_factor' : 3}";
            stmtBuilder.append("replication = ").append(replicationProp);
            if (props != null && props.containsKey("durable_writes") && !(durable = Boolean.valueOf((String)props.get("durable_writes"))).booleanValue()) {
                stmtBuilder.append(" AND durable_writes=false");
            }
            NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"Cassandra.Schema.CreateSchema", (Object[])new Object[]{stmtBuilder.toString()}));
            session.execute(stmtBuilder.toString());
            NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"Cassandra.Schema.CreateSchema.Success"));
        }
        finally {
            if (mconn != null) {
                mconn.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchemaForClasses(Set<String> classNames, Properties props, Object connection) {
        Session session = (Session)connection;
        String ddlFilename = props != null ? props.getProperty("ddlFilename") : null;
        OutputStreamWriter ddlFileWriter = null;
        try {
            if (ddlFilename != null) {
                File ddlFile = StringUtils.getFileForFilename((String)ddlFilename);
                if (ddlFile.exists()) {
                    ddlFile.delete();
                }
                if (ddlFile.getParentFile() != null && !ddlFile.getParentFile().exists()) {
                    ddlFile.getParentFile().mkdirs();
                }
                ddlFile.createNewFile();
                ddlFileWriter = new FileWriter(ddlFile);
                SimpleDateFormat fmt = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                ddlFileWriter.write("------------------------------------------------------------------\n");
                ddlFileWriter.write("-- DataNucleus SchemaTool (ran at " + fmt.format(new Date()) + ")\n");
                ddlFileWriter.write("------------------------------------------------------------------\n");
            }
            ManagedConnection mconn = null;
            try {
                if (session == null) {
                    mconn = this.storeMgr.getConnectionManager().getConnection(-1);
                    session = (Session)mconn.getConnection();
                }
                ArrayList<String> tableStmts = new ArrayList<String>();
                ArrayList<String> constraintStmts = new ArrayList<String>();
                Iterator<String> classIter = classNames.iterator();
                ClassLoaderResolver clr = this.storeMgr.getNucleusContext().getClassLoaderResolver(null);
                while (classIter.hasNext()) {
                    String className = classIter.next();
                    AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(className, clr);
                    if (cmd == null) continue;
                    try {
                        this.createSchemaForClass(cmd, session, clr, tableStmts, constraintStmts);
                    }
                    catch (Exception e) {
                        NucleusLogger.DATASTORE_SCHEMA.error((Object)("Could not create schema for class=" + cmd.getFullClassName() + " - see the nested exception"), (Throwable)e);
                    }
                }
                if (!tableStmts.isEmpty()) {
                    for (String stmt : tableStmts) {
                        if (ddlFileWriter == null) {
                            NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"Cassandra.Schema.CreateTable", (Object[])new Object[]{stmt}));
                            session.execute(stmt);
                            NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"Cassandra.Schema.CreateTable.Success"));
                            continue;
                        }
                        try {
                            ddlFileWriter.write(stmt + ";\n");
                        }
                        catch (IOException iOException) {}
                    }
                }
                if (!constraintStmts.isEmpty()) {
                    for (String stmt : constraintStmts) {
                        if (ddlFileWriter == null) {
                            NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"Cassandra.Schema.CreateConstraint", (Object[])new Object[]{stmt}));
                            session.execute(stmt);
                            NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"Cassandra.Schema.CreateConstraint.Success"));
                            continue;
                        }
                        try {
                            ddlFileWriter.write(stmt + ";\n");
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (Exception e) {
                NucleusLogger.GENERAL.error((Object)"Exception in schema generation", (Throwable)e);
                throw e;
            }
            finally {
                if (mconn != null) {
                    mconn.release();
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (ddlFileWriter != null) {
                try {
                    ddlFileWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void createSchemaForClass(AbstractClassMetaData cmd, Session session, ClassLoaderResolver clr, List<String> tableStmts, List<String> constraintStmts) {
        DiscriminatorMetaData dismd;
        String indexStmt;
        String idxName;
        VersionMetaData vermd;
        String indexStmt2;
        String idxName2;
        void var7_10;
        if (cmd.isEmbeddedOnly() || cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
            return;
        }
        if (cmd instanceof ClassMetaData && ((ClassMetaData)cmd).isAbstract()) {
            return;
        }
        StoreData storeData = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
        Object var7_7 = null;
        if (storeData != null) {
            Table table = storeData.getTable();
        } else {
            CompleteClassTable completeClassTable = new CompleteClassTable(this.storeMgr, cmd, (SchemaVerifier)new SchemaVerifierImpl(this.storeMgr, cmd, clr));
        }
        String schemaName = var7_10.getSchemaName();
        TableMetadata tmd = CassandraSchemaHandler.getTableMetadata(session, schemaName, var7_10.getName());
        if (tmd != null) {
            DiscriminatorMetaData dismd2;
            String indexStmt3;
            String indexStmt4;
            String idxName3;
            Column column;
            VersionMetaData vermd2;
            String indexStmt5;
            ColumnMetadata dbColMd;
            if (this.autoCreateColumns) {
                List columns = var7_10.getColumns();
                for (Column column2 : columns) {
                    ColumnMetadata colmd = this.getColumnMetadataForColumn(tmd, column2);
                    if (colmd == null) {
                        StringBuilder stmtBuilder = new StringBuilder("ALTER TABLE ");
                        if (schemaName != null) {
                            stmtBuilder.append(schemaName).append('.');
                        }
                        stmtBuilder.append(var7_10.getName());
                        stmtBuilder.append(" ADD COLUMN ");
                        stmtBuilder.append(column2.getName()).append(" ").append(column2.getTypeName());
                        tableStmts.add(stmtBuilder.toString());
                        continue;
                    }
                    String colTypeNameDB = this.getTypeNameForColumn(colmd);
                    if (colTypeNameDB == null || colTypeNameDB.equals(column2.getTypeName())) continue;
                    NucleusLogger.DATASTORE_SCHEMA.warn((Object)Localiser.msg((String)"Cassandra.Schema.TableColumnTypeIncorrect", (Object[])new Object[]{var7_10.getName(), column2.getName(), colTypeNameDB, column2.getTypeName()}));
                }
            }
            if (this.autoDeleteColumns) {
                List colmds = tmd.getColumns();
                for (ColumnMetadata colmd : colmds) {
                    String colName = colmd.getName();
                    Column col = var7_10.getColumnForName(colName);
                    if (col != null) continue;
                    StringBuilder stmtBuilder = new StringBuilder("ALTER TABLE ");
                    if (schemaName != null) {
                        stmtBuilder.append(schemaName).append('.');
                    }
                    stmtBuilder.append(var7_10.getName());
                    stmtBuilder.append(" DROP COLUMN ");
                    stmtBuilder.append(colName);
                    tableStmts.add(stmtBuilder.toString());
                }
            }
            if (!this.isAutoCreateConstraints()) return;
            NamingFactory namingFactory = this.storeMgr.getNamingFactory();
            for (AbstractClassMetaData theCmd = cmd; theCmd != null; theCmd = theCmd.getSuperAbstractClassMetaData()) {
                List clsIdxMds = theCmd.getIndexMetaData();
                if (clsIdxMds == null) continue;
                int i = 0;
                for (IndexMetaData idxmd : clsIdxMds) {
                    String[] colNames = idxmd.getColumnNames();
                    if (colNames.length > 1) {
                        NucleusLogger.DATASTORE_SCHEMA.warn((Object)Localiser.msg((String)"Cassandra.Schema.IndexForClassWithMultipleColumns", (Object[])new Object[]{theCmd.getFullClassName()}));
                        continue;
                    }
                    String idxName4 = namingFactory.getConstraintName(theCmd, (ConstraintMetaData)idxmd, i++);
                    dbColMd = this.getColumnMetadataForColumnName(tmd, colNames[0]);
                    if (dbColMd == null) {
                        String indexStmt6 = this.createIndexCQL(idxName4, schemaName, var7_10.getName(), colNames[0], idxmd);
                        constraintStmts.add(indexStmt6);
                        continue;
                    }
                    IndexMetadata dbIdxMdForCol = this.getIndexMetadataForColumn(tmd, colNames[0]);
                    if (dbIdxMdForCol == null) {
                        indexStmt5 = this.createIndexCQL(idxName4, schemaName, var7_10.getName(), colNames[0], idxmd);
                        constraintStmts.add(indexStmt5);
                        continue;
                    }
                    if (idxName4.equals(dbIdxMdForCol.getName())) continue;
                    NucleusLogger.DATASTORE_SCHEMA.warn((Object)Localiser.msg((String)"Cassandra.Schema.IndexHasWrongName", (Object[])new Object[]{idxName4, dbIdxMdForCol.getName()}));
                }
            }
            Set mappings = var7_10.getMemberColumnMappings();
            for (MemberColumnMapping mapping : mappings) {
                Column[] cols;
                IndexMetaData idxmd;
                idxmd = mapping.getMemberMetaData().getIndexMetaData();
                if (idxmd == null || (cols = mapping.getColumns()) == null) continue;
                if (cols.length > 1) {
                    NucleusLogger.DATASTORE_SCHEMA.warn((Object)Localiser.msg((String)"Cassandra.Schema.IndexForMemberWithMultipleColumns", (Object[])new Object[]{mapping.getMemberMetaData().getFullFieldName()}));
                    continue;
                }
                if (cols.length != 1) continue;
                Column column3 = cols[0];
                dbColMd = this.getColumnMetadataForColumn(tmd, column3);
                String idxName5 = namingFactory.getConstraintName(cmd.getName(), mapping.getMemberMetaData(), (ConstraintMetaData)idxmd);
                if (dbColMd == null) {
                    indexStmt5 = this.createIndexCQL(idxName5, schemaName, var7_10.getName(), column3.getName(), idxmd);
                    constraintStmts.add(indexStmt5);
                    continue;
                }
                IndexMetadata dbIdxMd = this.getIndexMetadataForColumn(tmd, column3.getName());
                if (dbIdxMd == null) {
                    String indexStmt7 = this.createIndexCQL(idxName5, schemaName, var7_10.getName(), column3.getName(), idxmd);
                    constraintStmts.add(indexStmt7);
                    continue;
                }
                if (idxName5.equalsIgnoreCase(dbIdxMd.getName())) continue;
                NucleusLogger.DATASTORE_SCHEMA.warn((Object)Localiser.msg((String)"Cassandra.Schema.IndexHasWrongName", (Object[])new Object[]{idxName5, dbIdxMd.getName()}));
            }
            if (cmd.isVersioned() && cmd.getVersionMetaDataForClass() != null && cmd.getVersionMetaDataForClass().getFieldName() == null && (vermd2 = cmd.getVersionMetaDataForClass()).getIndexMetaData() != null) {
                column = var7_10.getSurrogateColumn(SurrogateColumnType.VERSION);
                ColumnMetadata dbVerColMd = this.getColumnMetadataForColumn(tmd, column);
                idxName3 = namingFactory.getConstraintName(cmd, (ConstraintMetaData)vermd2.getIndexMetaData(), ColumnType.VERSION_COLUMN);
                if (dbVerColMd == null) {
                    indexStmt4 = this.createIndexCQL(idxName3, schemaName, var7_10.getName(), column.getName(), vermd2.getIndexMetaData());
                    constraintStmts.add(indexStmt4);
                } else {
                    IndexMetadata dbVerIdxMd = this.getIndexMetadataForColumn(tmd, column.getName());
                    if (dbVerIdxMd == null) {
                        indexStmt3 = this.createIndexCQL(idxName3, schemaName, var7_10.getName(), column.getName(), vermd2.getIndexMetaData());
                        constraintStmts.add(indexStmt3);
                    } else if (!idxName3.equals(dbVerIdxMd.getName())) {
                        NucleusLogger.DATASTORE_SCHEMA.warn((Object)Localiser.msg((String)"Cassandra.Schema.IndexHasWrongName", (Object[])new Object[]{idxName3, dbVerIdxMd.getName()}));
                    }
                }
            }
            if (cmd.hasDiscriminatorStrategy() && (dismd2 = cmd.getDiscriminatorMetaData()).getIndexMetaData() != null) {
                column = var7_10.getSurrogateColumn(SurrogateColumnType.DISCRIMINATOR);
                ColumnMetadata dbDiscColMd = this.getColumnMetadataForColumn(tmd, column);
                idxName3 = namingFactory.getConstraintName(cmd, (ConstraintMetaData)dismd2.getIndexMetaData(), ColumnType.DISCRIMINATOR_COLUMN);
                if (dbDiscColMd == null) {
                    indexStmt4 = this.createIndexCQL(idxName3, schemaName, var7_10.getName(), column.getName(), dismd2.getIndexMetaData());
                    constraintStmts.add(indexStmt4);
                } else {
                    IndexMetadata dbDiscIdxMd = this.getIndexMetadataForColumn(tmd, column.getName());
                    if (dbDiscIdxMd == null) {
                        indexStmt3 = this.createIndexCQL(idxName3, schemaName, var7_10.getName(), column.getName(), dismd2.getIndexMetaData());
                        constraintStmts.add(indexStmt3);
                    } else if (!idxName3.equals(dbDiscIdxMd.getName())) {
                        NucleusLogger.DATASTORE_SCHEMA.warn((Object)Localiser.msg((String)"Cassandra.Schema.IndexHasWrongName", (Object[])new Object[]{idxName3, dbDiscIdxMd.getName()}));
                    }
                }
            }
            if (!this.storeMgr.getNucleusContext().isClassMultiTenant(cmd)) return;
        }
        if (this.isAutoCreateTables()) {
            StringBuilder stmtBuilder = new StringBuilder("CREATE TABLE ");
            if (schemaName != null) {
                stmtBuilder.append(schemaName).append('.');
            }
            stmtBuilder.append(var7_10.getName());
            stmtBuilder.append(" (");
            ArrayList<String> pkColNames = new ArrayList<String>();
            for (Column column : var7_10.getColumns()) {
                stmtBuilder.append(column.getName()).append(' ').append(column.getTypeName()).append(',');
                if (!column.isPrimaryKey()) continue;
                pkColNames.add(column.getName());
            }
            stmtBuilder.append(" PRIMARY KEY (");
            Iterator pkColNameIter = pkColNames.iterator();
            while (pkColNameIter.hasNext()) {
                stmtBuilder.append((String)pkColNameIter.next());
                if (!pkColNameIter.hasNext()) continue;
                stmtBuilder.append(',');
            }
            stmtBuilder.append(")");
            stmtBuilder.append(")");
            String[] options = cmd.getValuesForExtension("cassandra.createTable.options");
            if (options != null && options.length > 0) {
                stmtBuilder.append(" WITH ");
                for (int i = 0; i < options.length; ++i) {
                    if (i > 0) {
                        stmtBuilder.append(" AND ");
                    }
                    stmtBuilder.append(options[i]);
                }
            }
            tableStmts.add(stmtBuilder.toString());
        }
        if (!this.isAutoCreateConstraints()) return;
        NamingFactory namingFactory = this.storeMgr.getNamingFactory();
        for (AbstractClassMetaData theCmd = cmd; theCmd != null; theCmd = theCmd.getSuperAbstractClassMetaData()) {
            List clsIdxMds = theCmd.getIndexMetaData();
            if (clsIdxMds == null) continue;
            int i = 0;
            for (IndexMetaData idxmd : clsIdxMds) {
                String[] colNames = idxmd.getColumnNames();
                if (colNames.length > 1) {
                    NucleusLogger.DATASTORE_SCHEMA.warn((Object)Localiser.msg((String)"Cassandra.Schema.IndexForClassWithMultipleColumns", (Object[])new Object[]{theCmd.getFullClassName()}));
                    continue;
                }
                idxName2 = namingFactory.getConstraintName(theCmd, (ConstraintMetaData)idxmd, i++);
                indexStmt2 = this.createIndexCQL(idxName2, schemaName, var7_10.getName(), colNames[0], idxmd);
                constraintStmts.add(indexStmt2);
            }
        }
        Set mappings = var7_10.getMemberColumnMappings();
        Iterator i = mappings.iterator();
        while (i.hasNext()) {
            MemberColumnMapping mapping = (MemberColumnMapping)i.next();
            AbstractMemberMetaData mmd = mapping.getMemberMetaData();
            IndexMetaData idxmd = mmd.getIndexMetaData();
            if (idxmd == null || mapping.getNumberOfColumns() != 1) continue;
            idxName2 = namingFactory.getConstraintName(cmd.getName(), mmd, (ConstraintMetaData)idxmd);
            indexStmt2 = this.createIndexCQL(idxName2, schemaName, var7_10.getName(), mapping.getColumn(0).getName(), idxmd);
            constraintStmts.add(indexStmt2);
        }
        if (cmd.isVersioned() && cmd.getVersionMetaDataForClass() != null && cmd.getVersionMetaDataForClass().getFieldName() == null && (vermd = cmd.getVersionMetaDataForClass()).getIndexMetaData() != null) {
            Column column = var7_10.getSurrogateColumn(SurrogateColumnType.VERSION);
            idxName = namingFactory.getConstraintName(cmd, (ConstraintMetaData)vermd.getIndexMetaData(), ColumnType.VERSION_COLUMN);
            indexStmt = this.createIndexCQL(idxName, schemaName, var7_10.getName(), column.getName(), vermd.getIndexMetaData());
            constraintStmts.add(indexStmt);
        }
        if (cmd.hasDiscriminatorStrategy() && (dismd = cmd.getDiscriminatorMetaData()).getIndexMetaData() != null) {
            Column column = var7_10.getSurrogateColumn(SurrogateColumnType.DISCRIMINATOR);
            idxName = namingFactory.getConstraintName(cmd, (ConstraintMetaData)dismd.getIndexMetaData(), ColumnType.DISCRIMINATOR_COLUMN);
            indexStmt = this.createIndexCQL(idxName, schemaName, var7_10.getName(), column.getName(), dismd.getIndexMetaData());
            constraintStmts.add(indexStmt);
        }
        if (!this.storeMgr.getNucleusContext().isClassMultiTenant(cmd)) return;
        Column column = var7_10.getSurrogateColumn(SurrogateColumnType.MULTITENANCY);
        String idxName6 = cmd.getName() + "_TENANCY_IDX";
        String indexStmt8 = this.createIndexCQL(idxName6, schemaName, var7_10.getName(), column.getName(), null);
        constraintStmts.add(indexStmt8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDatabase(String catalogName, String schemaName, Properties props, Object connection) {
        Session session = (Session)connection;
        ManagedConnection mconn = null;
        try {
            if (session == null) {
                mconn = this.storeMgr.getConnectionManager().getConnection(-1);
                session = (Session)mconn.getConnection();
            }
            StringBuilder stmtBuilder = new StringBuilder("DROP KEYSPACE IF EXISTS ");
            stmtBuilder.append(schemaName);
            NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"Cassandra.Schema.DropSchema", (Object[])new Object[]{stmtBuilder.toString()}));
            session.execute(stmtBuilder.toString());
            NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"Cassandra.Schema.DropSchema", (Object[])new Object[]{schemaName}));
        }
        finally {
            if (mconn != null) {
                mconn.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSchemaForClasses(Set<String> classNames, Properties props, Object connection) {
        Session session = (Session)connection;
        String ddlFilename = props != null ? props.getProperty("ddlFilename") : null;
        OutputStreamWriter ddlFileWriter = null;
        try {
            if (ddlFilename != null) {
                File ddlFile = StringUtils.getFileForFilename((String)ddlFilename);
                if (ddlFile.exists()) {
                    ddlFile.delete();
                }
                if (ddlFile.getParentFile() != null && !ddlFile.getParentFile().exists()) {
                    ddlFile.getParentFile().mkdirs();
                }
                ddlFile.createNewFile();
                ddlFileWriter = new FileWriter(ddlFile);
                SimpleDateFormat fmt = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                ddlFileWriter.write("------------------------------------------------------------------\n");
                ddlFileWriter.write("-- DataNucleus SchemaTool (ran at " + fmt.format(new Date()) + ")\n");
                ddlFileWriter.write("------------------------------------------------------------------\n");
            }
            ManagedConnection mconn = null;
            try {
                if (session == null) {
                    mconn = this.storeMgr.getConnectionManager().getConnection(-1);
                    session = (Session)mconn.getConnection();
                }
                Iterator<String> classIter = classNames.iterator();
                ClassLoaderResolver clr = this.storeMgr.getNucleusContext().getClassLoaderResolver(null);
                while (classIter.hasNext()) {
                    String className = classIter.next();
                    AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(className, clr);
                    if (cmd == null || cmd.isEmbeddedOnly() || cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE || cmd instanceof ClassMetaData && ((ClassMetaData)cmd).isAbstract()) continue;
                    StoreData storeData = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
                    Object table = null;
                    table = storeData != null ? storeData.getTable() : new CompleteClassTable(this.storeMgr, cmd, (SchemaVerifier)new SchemaVerifierImpl(this.storeMgr, cmd, clr));
                    String schemaName = table.getSchemaName();
                    String tableName = table.getName();
                    NamingFactory namingFactory = this.storeMgr.getNamingFactory();
                    TableMetadata tmd = CassandraSchemaHandler.getTableMetadata(session, schemaName, tableName);
                    if (tmd != null) {
                        String idxName;
                        StringBuilder stmtBuilder;
                        int i;
                        for (AbstractClassMetaData theCmd = cmd; theCmd != null; theCmd = theCmd.getSuperAbstractClassMetaData()) {
                            List clsIdxMds = theCmd.getIndexMetaData();
                            if (clsIdxMds == null) continue;
                            i = 0;
                            for (IndexMetaData idxmd : clsIdxMds) {
                                stmtBuilder = new StringBuilder("DROP INDEX ");
                                idxName = namingFactory.getConstraintName(theCmd, (ConstraintMetaData)idxmd, i++);
                                if (ddlFileWriter == null) {
                                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"Cassandra.Schema.DropConstraint", (Object[])new Object[]{stmtBuilder.toString()}));
                                    session.execute(stmtBuilder.toString());
                                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"Cassandra.Schema.DropConstraint.Success", (Object[])new Object[]{idxName}));
                                    continue;
                                }
                                try {
                                    ddlFileWriter.write(stmtBuilder.toString() + ";\n");
                                }
                                catch (IOException iOException) {}
                            }
                        }
                        int[] memberPositions = cmd.getAllMemberPositions();
                        for (i = 0; i < memberPositions.length; ++i) {
                            IndexMetaData idxmd;
                            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(memberPositions[i]);
                            idxmd = mmd.getIndexMetaData();
                            if (idxmd == null) continue;
                            stmtBuilder = new StringBuilder("DROP INDEX ");
                            idxName = namingFactory.getConstraintName(null, mmd, (ConstraintMetaData)idxmd);
                            if (ddlFileWriter == null) {
                                NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"Cassandra.Schema.DropConstraint", (Object[])new Object[]{stmtBuilder.toString()}));
                                session.execute(stmtBuilder.toString());
                                NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"Cassandra.Schema.DropConstraint.Success", (Object[])new Object[]{idxName}));
                                continue;
                            }
                            try {
                                ddlFileWriter.write(stmtBuilder.toString() + ";\n");
                                continue;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        StringBuilder stmtBuilder2 = new StringBuilder("DROP TABLE ");
                        if (schemaName != null) {
                            stmtBuilder2.append(schemaName).append('.');
                        }
                        stmtBuilder2.append(tableName);
                        if (ddlFileWriter == null) {
                            NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"Cassandra.Schema.DropTable", (Object[])new Object[]{stmtBuilder2.toString()}));
                            session.execute(stmtBuilder2.toString());
                            NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"Cassandra.Schema.DropTable.Success", (Object[])new Object[]{tableName}));
                            continue;
                        }
                        try {
                            ddlFileWriter.write(stmtBuilder2.toString() + ";\n");
                        }
                        catch (IOException iOException) {}
                        continue;
                    }
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"Cassandra.Schema.DropTable.DoesntExist", (Object[])new Object[]{tableName}));
                }
            }
            finally {
                if (mconn != null) {
                    mconn.release();
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (ddlFileWriter != null) {
                try {
                    ddlFileWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateSchema(Set<String> classNames, Properties props, Object connection) {
        Session session = (Session)connection;
        boolean success = true;
        ClassLoaderResolver clr = this.storeMgr.getNucleusContext().getClassLoaderResolver(null);
        ManagedConnection mconn = null;
        try {
            if (session == null) {
                mconn = this.storeMgr.getConnectionManager().getConnection(-1);
                session = (Session)mconn.getConnection();
            }
            NamingFactory namingFactory = this.storeMgr.getNamingFactory();
            for (String className : classNames) {
                String idxName;
                IndexMetadata dbIdxMd;
                ColumnMetadata dbColMd;
                String tableName;
                AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(className, clr);
                if (cmd.isEmbeddedOnly() || cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE || cmd instanceof ClassMetaData && ((ClassMetaData)cmd).isAbstract()) continue;
                StoreData storeData = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
                Object table = null;
                table = storeData != null ? storeData.getTable() : new CompleteClassTable(this.storeMgr, cmd, (SchemaVerifier)new SchemaVerifierImpl(this.storeMgr, cmd, clr));
                String schemaName = table.getSchemaName();
                TableMetadata tmd = CassandraSchemaHandler.getTableMetadata(session, schemaName, tableName = table.getName());
                if (tmd == null) {
                    NucleusLogger.DATASTORE_SCHEMA.error((Object)Localiser.msg((String)"Cassandra.Schema.TableDoesntExist", (Object[])new Object[]{cmd.getFullClassName(), tableName, schemaName}));
                    success = false;
                    continue;
                }
                HashSet colsFound = new HashSet();
                List columns = table.getColumns();
                for (Column column : columns) {
                    ColumnMetadata colmd = this.getColumnMetadataForColumn(tmd, column);
                    if (colmd == null) {
                        if (column.getMemberColumnMapping() != null) {
                            NucleusLogger.DATASTORE_SCHEMA.error((Object)Localiser.msg((String)"Cassandra.Schema.ColumnForTableDoesntExist", (Object[])new Object[]{tableName, column.getName(), column.getMemberColumnMapping().getMemberMetaData().getFullFieldName()}));
                        } else {
                            NucleusLogger.DATASTORE_SCHEMA.error((Object)Localiser.msg((String)"Cassandra.Schema.ColumnForTableInvalidType", (Object[])new Object[]{tableName, column.getName(), column.getColumnType()}));
                        }
                        success = false;
                        continue;
                    }
                    String datastoreType = this.getTypeNameForColumn(colmd);
                    if (column.getTypeName().equals(datastoreType)) continue;
                    NucleusLogger.DATASTORE_SCHEMA.error((Object)Localiser.msg((String)"Cassandra.Schema.ColumnTypeIncorrect", (Object[])new Object[]{tableName, column.getName(), datastoreType, column.getTypeName()}));
                }
                int numColsDB = tmd.getColumns().size();
                if (success && numColsDB != colsFound.size()) {
                    NucleusLogger.DATASTORE_SCHEMA.error((Object)Localiser.msg((String)"Cassandra.Schema.ColumnCountIncorrect", (Object[])new Object[]{tableName, colsFound.size(), numColsDB}));
                    success = false;
                }
                for (AbstractClassMetaData theCmd = cmd; theCmd != null; theCmd = theCmd.getSuperAbstractClassMetaData()) {
                    List clsIdxMds = theCmd.getIndexMetaData();
                    if (clsIdxMds == null) continue;
                    int i = 0;
                    for (IndexMetaData idxmd : clsIdxMds) {
                        String[] colNames = idxmd.getColumnNames();
                        if (colNames.length != 1) continue;
                        dbColMd = this.getColumnMetadataForColumnName(tmd, colNames[0].toLowerCase());
                        dbIdxMd = this.getIndexMetadataForColumn(tmd, colNames[0].toLowerCase());
                        idxName = namingFactory.getConstraintName(theCmd, (ConstraintMetaData)idxmd, i++);
                        if (dbColMd == null || dbIdxMd == null) {
                            NucleusLogger.DATASTORE_SCHEMA.error((Object)Localiser.msg((String)"Cassandra.Schema.TableIndexMissingForColumn", (Object[])new Object[]{tableName, colNames[0]}));
                            continue;
                        }
                        if (idxName.equals(dbIdxMd.getName())) continue;
                        NucleusLogger.DATASTORE_SCHEMA.warn((Object)Localiser.msg((String)"Cassandra.Schema.IndexHasWrongName", (Object[])new Object[]{idxName, dbIdxMd.getName()}));
                    }
                }
                int[] memberPositions = cmd.getAllMemberPositions();
                for (int i = 0; i < memberPositions.length; ++i) {
                    IndexMetaData idxmd;
                    AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(memberPositions[i]);
                    idxmd = mmd.getIndexMetaData();
                    if (idxmd == null) continue;
                    String colName = namingFactory.getColumnName(mmd, ColumnType.COLUMN);
                    dbColMd = this.getColumnMetadataForColumnName(tmd, colName.toLowerCase());
                    dbIdxMd = this.getIndexMetadataForColumn(tmd, colName.toLowerCase());
                    idxName = namingFactory.getConstraintName(null, mmd, (ConstraintMetaData)idxmd);
                    if (dbColMd == null || dbIdxMd == null) {
                        NucleusLogger.DATASTORE_SCHEMA.error((Object)Localiser.msg((String)"Cassandra.Schema.TableIndexMissingForColumn", (Object[])new Object[]{tableName, colName}));
                        continue;
                    }
                    if (idxName.equals(dbIdxMd.getName())) continue;
                    NucleusLogger.DATASTORE_SCHEMA.warn((Object)Localiser.msg((String)"Cassandra.Schema.IndexHasWrongName", (Object[])new Object[]{idxName, dbIdxMd.getName()}));
                }
            }
        }
        finally {
            if (mconn != null) {
                mconn.release();
            }
        }
        if (!success) {
            throw new NucleusException("Errors were encountered during validation of Cassandra schema");
        }
    }

    protected String createIndexCQL(String indexName, String schemaName, String tableName, String columnName, IndexMetaData idxmd) {
        String using;
        StringBuilder stmtBuilder = new StringBuilder("CREATE INDEX ");
        stmtBuilder.append(indexName);
        stmtBuilder.append(" ON ");
        if (schemaName != null) {
            stmtBuilder.append(schemaName).append('.');
        }
        stmtBuilder.append(tableName);
        stmtBuilder.append(" (").append(columnName).append(")");
        if (idxmd != null && !StringUtils.isWhitespace((String)(using = idxmd.getValueForExtension("cassandra.createIndex.using")))) {
            stmtBuilder.append(" USING ").append(using);
        }
        return stmtBuilder.toString();
    }

    public static TableMetadata getTableMetadata(Session session, String schemaName, String tableName) {
        KeyspaceMetadata ks = CassandraSchemaHandler.getKeyspaceMetadata(session, schemaName);
        if (ks == null) {
            return null;
        }
        return ks.getTable(tableName.toLowerCase());
    }

    public static KeyspaceMetadata getKeyspaceMetadata(Session session, String schemaName) {
        if (schemaName == null) {
            throw new NucleusUserException("Schema name must be specified in order to check its existence");
        }
        return session.getCluster().getMetadata().getKeyspace(schemaName.toLowerCase());
    }

    protected String getTypeNameForColumn(ColumnMetadata colmd) {
        String typeName = colmd.getType().toString();
        typeName = StringUtils.replaceAll((String)typeName, (String)"text", (String)"varchar");
        typeName = StringUtils.replaceAll((String)typeName, (String)", ", (String)",");
        return typeName;
    }

    protected ColumnMetadata getColumnMetadataForColumn(TableMetadata tmd, Column col) {
        String colName = col.getName();
        return this.getColumnMetadataForColumnName(tmd, colName);
    }

    protected ColumnMetadata getColumnMetadataForColumnName(TableMetadata tmd, String colName) {
        if (colName.startsWith("\"")) {
            colName = colName.substring(1, colName.length() - 1);
        }
        return tmd.getColumn(colName);
    }

    protected IndexMetadata getIndexMetadataForColumn(TableMetadata tmd, String colName) {
        Collection idxmds = tmd.getIndexes();
        if (idxmds != null) {
            for (IndexMetadata idxmd : idxmds) {
                String dbIdxTarget = idxmd.getTarget();
                if (dbIdxTarget == null || !dbIdxTarget.equals(colName)) continue;
                return idxmd;
            }
        }
        return null;
    }
}

