/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.cassandra.query;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.datanucleus.ExecutionContext;
import org.datanucleus.store.query.AbstractQueryResult;
import org.datanucleus.store.query.AbstractQueryResultIterator;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;

public class CassandraQueryResult
extends AbstractQueryResult {
    private static final long serialVersionUID = -3428653031644090769L;
    private ResultSet rs;
    private List<Row> resultObjs = new ArrayList<Row>();
    private List resultIds = null;
    private int resultObjsIndex = 0;

    public CassandraQueryResult(Query query, ResultSet rs) {
        super(query);
        this.rs = rs;
        if (query.useResultsCaching()) {
            this.resultIds = new ArrayList();
        }
    }

    public void initialise() {
        int fetchSize = this.query.getFetchPlan().getFetchSize();
        if (!this.rs.iterator().hasNext()) {
            this.closeResults();
            return;
        }
        if (fetchSize == -1) {
            this.advanceToEndOfResultSet();
        } else if (fetchSize > 0) {
            this.processNumberOfResults(fetchSize);
        }
    }

    private void advanceToEndOfResultSet() {
        this.processNumberOfResults(-1);
    }

    private void fetchMoreResults() {
        if (!this.rs.isFullyFetched()) {
            Row row;
            this.resultObjsIndex = 0;
            this.resultObjs.clear();
            this.rs.fetchMoreResults();
            int fetchSize = this.query.getFetchPlan().getFetchSize();
            ExecutionContext ec = this.query.getExecutionContext();
            for (int i = 0; i < fetchSize && null != (row = this.rs.one()); ++i) {
                this.resultObjs.add(row);
                if (this.resultIds == null) continue;
                this.resultIds.add(ec.getApiAdapter().getIdForObject((Object)row));
            }
        } else {
            this.closeResults();
        }
    }

    private void processNumberOfResults(int number) {
        ExecutionContext ec = this.query.getExecutionContext();
        if (-1 >= number) {
            if (this.resultIds != null) {
                Iterator rowIter = this.rs.iterator();
                while (rowIter.hasNext()) {
                    Row row = this.rs.one();
                    this.resultObjs.add(row);
                    this.resultIds.add(ec.getApiAdapter().getIdForObject((Object)row));
                }
            } else {
                this.resultObjs = this.rs.all();
            }
        } else {
            Row row;
            for (int i = 0; i < number && null != (row = this.rs.one()); ++i) {
                this.resultObjs.add(row);
                if (this.resultIds == null) continue;
                this.resultIds.add(ec.getApiAdapter().getIdForObject((Object)row));
            }
        }
    }

    protected void closingConnection() {
    }

    public void disconnect() {
        if (this.query == null) {
            return;
        }
        this.rs = null;
    }

    public synchronized void close() {
        super.close();
        this.rs = null;
    }

    protected void closeResults() {
        if (this.resultIds != null) {
            this.query.getQueryManager().addQueryResult(this.query, this.query.getInputParameters(), this.resultIds);
            this.resultIds = null;
        }
    }

    public boolean equals(Object o) {
        if (null == o || o instanceof CassandraQueryResult) {
            return false;
        }
        CassandraQueryResult other = (CassandraQueryResult)((Object)o);
        if (this.rs != null) {
            return other.rs == this.rs;
        }
        if (this.query != null) {
            return other.query == this.query;
        }
        return StringUtils.toJVMIDString((Object)((Object)other)).equals(StringUtils.toJVMIDString((Object)((Object)this)));
    }

    public int hashCode() {
        if (this.rs != null) {
            return this.rs.hashCode();
        }
        if (this.query != null) {
            return this.query.hashCode();
        }
        return StringUtils.toJVMIDString((Object)((Object)this)).hashCode();
    }

    public Object get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return null;
    }

    public Iterator iterator() {
        return new QueryResultIterator();
    }

    public ListIterator listIterator() {
        return new QueryResultIterator();
    }

    private class QueryResultIterator
    extends AbstractQueryResultIterator {
        Row currentElement = null;

        private QueryResultIterator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            CassandraQueryResult cassandraQueryResult = CassandraQueryResult.this;
            synchronized (cassandraQueryResult) {
                if (!CassandraQueryResult.this.isOpen()) {
                    return false;
                }
                assert (null != CassandraQueryResult.this.resultObjs);
                return CassandraQueryResult.this.resultObjsIndex < CassandraQueryResult.this.resultObjs.size();
                {
                }
            }
        }

        public Object next() {
            CassandraQueryResult cassandraQueryResult = CassandraQueryResult.this;
            synchronized (cassandraQueryResult) {
                if (!CassandraQueryResult.this.isOpen()) {
                    throw new NoSuchElementException(Localiser.msg((String)"052600"));
                }
                int resultObjsSize = CassandraQueryResult.this.resultObjs.size();
                if (CassandraQueryResult.this.resultObjsIndex < resultObjsSize) {
                    this.currentElement = (Row)CassandraQueryResult.this.resultObjs.get(CassandraQueryResult.this.resultObjsIndex++);
                    if (CassandraQueryResult.this.resultObjsIndex == resultObjsSize) {
                        CassandraQueryResult.this.fetchMoreResults();
                    }
                    return this.currentElement;
                }
                throw new NoSuchElementException(Localiser.msg((String)"052602"));
            }
        }

        public boolean hasPrevious() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public int nextIndex() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public Object previous() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public int previousIndex() {
            throw new UnsupportedOperationException("Not yet implemented");
        }
    }
}

