/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache.cacheonix;

import cacheonix.Cacheonix;
import cacheonix.cache.Cache;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datanucleus.Configuration;
import org.datanucleus.NucleusContext;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.cache.QueryResultsCache;
import org.datanucleus.util.NucleusLogger;

public class CacheonixQueryResultCache
implements QueryResultsCache {
    private static final long serialVersionUID = -7951373996155521704L;
    Cacheonix cacheManager;
    long timeout = -1L;
    Cache<Serializable, Serializable> queryCache;

    public CacheonixQueryResultCache(NucleusContext nucleusCtx) {
        String cacheName;
        Configuration conf = nucleusCtx.getConfiguration();
        String configFile = conf.getStringProperty("datanucleus.cache.level2.configurationFile");
        this.cacheManager = configFile == null ? Cacheonix.getInstance() : Cacheonix.getInstance((String)configFile);
        if (conf.hasProperty("datanucleus.cache.level2.timeout")) {
            this.timeout = conf.getIntProperty("datanucleus.cache.level2.timeout");
        }
        if ((cacheName = conf.getStringProperty("datanucleus.cache.queryResults.cacheName")) == null) {
            NucleusLogger.CACHE.warn((Object)"No 'datanucleus.cache.queryResults.cacheName' specified so using name of 'DataNucleus-Query'");
            cacheName = "datanucleus-query";
        }
        this.queryCache = this.cacheManager.getCache(cacheName);
    }

    public void close() {
        this.evictAll();
        this.cacheManager.shutdown();
    }

    public void evict(Class candidate) {
        throw new UnsupportedOperationException("Not yet supported");
    }

    public void evict(Query query) {
        String baseKey = QueryUtils.getKeyForQueryResultsCache((Query)query, null);
        Iterator iter = this.queryCache.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.startsWith(baseKey)) continue;
            iter.remove();
        }
    }

    public void evict(Query query, Map params) {
        String key = QueryUtils.getKeyForQueryResultsCache((Query)query, (Map)params);
        this.queryCache.remove((Object)key);
    }

    public void evictAll() {
        this.queryCache.clear();
    }

    public void pin(Query query) {
        throw new UnsupportedOperationException("This cache doesn't support pinning/unpinning");
    }

    public void pin(Query query, Map params) {
        throw new UnsupportedOperationException("This cache doesn't support pinning/unpinning");
    }

    public void unpin(Query query) {
        throw new UnsupportedOperationException("This cache doesn't support pinning/unpinning");
    }

    public void unpin(Query query, Map params) {
        throw new UnsupportedOperationException("This cache doesn't support pinning/unpinning");
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        return this.queryCache.size();
    }

    public List<Object> get(String queryKey) {
        return (List)((Object)this.queryCache.get((Object)queryKey));
    }

    public List<Object> put(String queryKey, List<Object> results) {
        if (queryKey == null || results == null) {
            return null;
        }
        if (this.timeout > 0L) {
            this.queryCache.put((Serializable)((Object)queryKey), (Serializable)((Object)results), this.timeout);
        } else {
            this.queryCache.put((Serializable)((Object)queryKey), (Serializable)((Object)results));
        }
        return results;
    }

    public boolean contains(String queryKey) {
        return this.get(queryKey) != null;
    }
}

