/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache.spymemcached;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.MemcachedClient;
import org.datanucleus.Configuration;
import org.datanucleus.NucleusContext;
import org.datanucleus.cache.AbstractLevel2Cache;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.identity.SingleFieldId;

public class SpymemcachedLevel2Cache
extends AbstractLevel2Cache {
    private MemcachedClient client;
    private int expireSeconds = 0;

    public SpymemcachedLevel2Cache(NucleusContext nucleusCtx) {
        super(nucleusCtx);
        Configuration conf = nucleusCtx.getConfiguration();
        String expireStr = conf.getStringProperty("datanucleus.cache.level2.memcached.expireSeconds");
        if (expireStr != null && !"".equals(expireStr)) {
            this.expireSeconds = Integer.parseInt(expireStr);
        }
        try {
            String servers = conf.getStringProperty("datanucleus.cache.level2.memcached.servers");
            this.client = new MemcachedClient(AddrUtil.getAddresses((String)servers));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new NucleusException("Cant create cache", (Throwable)e);
        }
        catch (NumberFormatException ex) {
            throw new NucleusException("Cant create cache: Bad expireSeconds value:" + expireStr, (Throwable)ex);
        }
    }

    public void close() {
        if (this.clearAtClose) {
            this.client.flush();
            this.client.shutdown();
        }
    }

    public boolean containsOid(Object oid) {
        return this.get(oid) != null;
    }

    public synchronized void evict(Object oid) {
        this.client.delete(this.getCacheKeyForId(oid));
    }

    public synchronized void evictAll() {
        this.client.flush();
    }

    public synchronized void evictAll(Object[] oids) {
        if (oids == null) {
            return;
        }
        for (int i = 0; i < oids.length; ++i) {
            this.evict(oids[i]);
        }
    }

    public synchronized void evictAll(Collection oids) {
        if (oids == null) {
            return;
        }
        Iterator iter = oids.iterator();
        while (iter.hasNext()) {
            this.evict(iter.next());
        }
    }

    public synchronized void evictAll(Class arg0, boolean arg1) {
        throw new UnsupportedOperationException("evictAll(Class,Boolean) method not supported by spymemcached plugin");
    }

    public CachedPC get(Object oid) {
        return (CachedPC)this.client.get(this.getCacheKeyForId(oid));
    }

    public int getSize() {
        throw new UnsupportedOperationException("getSize() method not supported by spymemcached plugin");
    }

    public boolean isEmpty() {
        throw new UnsupportedOperationException("isEmpty() method not supported by spymemcached plugin");
    }

    public synchronized CachedPC put(Object oid, CachedPC pc) {
        if (oid == null || pc == null) {
            return null;
        }
        this.client.set(this.getCacheKeyForId(oid), this.expireSeconds, (Object)pc);
        return pc;
    }

    protected String getCacheKeyForId(Object id) {
        if (IdentityUtils.isSingleFieldIdentity((Object)id)) {
            String targetClassName = ((SingleFieldId)id).getTargetClassName();
            return this.cacheName + targetClassName + ":" + id.toString().hashCode();
        }
        return this.cacheName + id.toString().hashCode();
    }
}

