/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache.javaxcache;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.Caching;
import org.datanucleus.NucleusContext;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.cache.QueryResultsCache;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaxCacheQueryResultCache
implements QueryResultsCache {
    private Cache cache;

    public JavaxCacheQueryResultCache(NucleusContext nucleusCtx) {
        PersistenceConfiguration conf = nucleusCtx.getPersistenceConfiguration();
        String cacheName = conf.getStringProperty("datanucleus.cache.queryResults.cacheName");
        if (cacheName == null) {
            NucleusLogger.CACHE.warn((Object)"No 'datanucleus.cache.queryResults.cacheName' specified so using name of 'DataNucleus-Query'");
            cacheName = "datanucleus-query";
        }
        try {
            CacheManager cacheManager = Caching.getCacheManager();
            Cache tmpcache = cacheManager.getCache(cacheName);
            this.cache = tmpcache == null ? cacheManager.createCacheBuilder(cacheName).build() : tmpcache;
        }
        catch (CacheException e) {
            throw new NucleusException("Error creating cache", (Throwable)e);
        }
    }

    public void close() {
        this.evictAll();
        this.cache = null;
    }

    public boolean contains(String queryKey) {
        return this.get(queryKey) != null;
    }

    public void evict(Class candidate) {
    }

    public synchronized void evict(Query query) {
        String baseKey = QueryUtils.getKeyForQueryResultsCache((Query)query, null);
        Iterator entryIter = this.cache.iterator();
        while (entryIter.hasNext()) {
            Cache.Entry entry = (Cache.Entry)entryIter.next();
            String key = (String)entry.getKey();
            if (!key.startsWith(baseKey)) continue;
            entryIter.remove();
        }
    }

    public synchronized void evict(Query query, Map params) {
        String key = QueryUtils.getKeyForQueryResultsCache((Query)query, (Map)params);
        this.cache.remove((Object)key);
    }

    public synchronized void evictAll() {
        this.cache.removeAll();
    }

    public void pin(Query query, Map params) {
        throw new UnsupportedOperationException("This cache doesn't support pinning/unpinning");
    }

    public void pin(Query query) {
        throw new UnsupportedOperationException("This cache doesn't support pinning/unpinning");
    }

    public void unpin(Query query, Map params) {
        throw new UnsupportedOperationException("This cache doesn't support pinning/unpinning");
    }

    public void unpin(Query query) {
        throw new UnsupportedOperationException("This cache doesn't support pinning/unpinning");
    }

    public List<Object> get(String queryKey) {
        return (List)this.cache.get((Object)queryKey);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public synchronized List<Object> put(String queryKey, List<Object> results) {
        if (queryKey == null || results == null) {
            return null;
        }
        try {
            this.cache.put((Object)queryKey, results);
        }
        catch (RuntimeException re) {
            NucleusLogger.CACHE.info((Object)("Query results with key '" + queryKey + "' not cached. " + re.getMessage()));
        }
        return results;
    }

    public int size() {
        throw new UnsupportedOperationException("size() method not supported by this plugin");
    }
}

