/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache.javaxcache;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import org.datanucleus.NucleusContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.cache.AbstractLevel2Cache;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.identity.OID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.util.NucleusLogger;

public class JavaxCacheLevel2Cache
extends AbstractLevel2Cache {
    private final Cache cache;
    private final ApiAdapter apiAdapter;
    private final NucleusContext nucCtx;

    public JavaxCacheLevel2Cache(NucleusContext nucleusCtx) {
        super(nucleusCtx);
        this.nucCtx = nucleusCtx;
        this.apiAdapter = nucleusCtx.getApiAdapter();
        try {
            Cache tmpcache = CacheManager.getInstance().getCache(this.cacheName);
            if (tmpcache == null) {
                this.cache = CacheManager.getInstance().getCacheFactory().createCache(Collections.EMPTY_MAP);
                CacheManager.getInstance().registerCache(this.cacheName, this.cache);
            } else {
                this.cache = tmpcache;
            }
        }
        catch (CacheException e) {
            throw new NucleusException("Error creating cache", (Throwable)e);
        }
    }

    public void close() {
        if (this.clearAtClose) {
            this.evictAll();
        }
    }

    public boolean containsOid(Object oid) {
        return this.get(oid) != null;
    }

    public CachedPC get(Object oid) {
        return (CachedPC)this.cache.get(oid);
    }

    public int getSize() {
        return this.cache.size();
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public synchronized CachedPC put(Object oid, CachedPC pc) {
        if (oid == null || pc == null) {
            return null;
        }
        if (this.maxSize >= 0 && this.getSize() == this.maxSize) {
            return null;
        }
        if (this.apiAdapter.isManaged(pc.getPersistableObject())) {
            NucleusLogger.CACHE.error((Object)LOCALISER.msg("004012", oid));
            return null;
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            new ObjectOutputStream(os).writeObject(pc);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.cache.put(oid, (Object)pc);
        return pc;
    }

    public synchronized void evict(Object oid) {
        this.cache.remove(oid);
    }

    public synchronized void evictAll() {
        this.cache.evict();
    }

    public synchronized void evictAll(Class pcClass, boolean subclasses) {
        if (!this.apiAdapter.isPersistable(pcClass)) {
            return;
        }
        if (subclasses) {
            NucleusLogger.CACHE.warn((Object)"Currently the javax.cache L2 provider does not respect the subclasses flag for eviction");
        }
        AbstractClassMetaData cmd = this.nucCtx.getMetaDataManager().getMetaDataForClass(pcClass, this.nucCtx.getClassLoaderResolver(pcClass.getClassLoader()));
        Iterator keyIter = this.cache.keySet().iterator();
        while (keyIter.hasNext()) {
            Object key = keyIter.next();
            if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                String targetClassName = this.apiAdapter.getTargetClassNameForSingleFieldIdentity(key);
                if (!pcClass.getName().equals(targetClassName)) continue;
                keyIter.remove();
                continue;
            }
            if (cmd.getIdentityType() != IdentityType.DATASTORE || !(key instanceof OID)) continue;
            OID oid = (OID)key;
            if (!pcClass.getName().equals(oid.getPcClass())) continue;
            keyIter.remove();
        }
    }

    public synchronized void evictAll(Collection oids) {
        if (oids == null) {
            return;
        }
        Iterator iter = oids.iterator();
        while (iter.hasNext()) {
            this.evict(iter.next());
        }
    }

    public synchronized void evictAll(Object[] oids) {
        if (oids == null) {
            return;
        }
        for (int i = 0; i < oids.length; ++i) {
            this.evict(oids[i]);
        }
    }
}

