/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache.javaxcache;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import org.datanucleus.OMFContext;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.query.cache.CachedQuery;
import org.datanucleus.store.query.cache.QueryCache;
import org.datanucleus.util.NucleusLogger;

public class JavaxCacheQueryCache
implements QueryCache {
    private final Cache cache;
    private String cacheName;

    public JavaxCacheQueryCache(OMFContext omfCtx) {
        PersistenceConfiguration conf = omfCtx.getPersistenceConfiguration();
        this.cacheName = conf.getStringProperty("datanucleus.cache.query.cacheName");
        if (this.cacheName == null) {
            NucleusLogger.CACHE.warn((Object)"No 'datanucleus.cache.query.cacheName' specified so using name of 'DataNucleus-Query'");
            this.cacheName = "DataNucleus-Query";
        }
        try {
            Cache tmpcache = CacheManager.getInstance().getCache(this.cacheName);
            if (tmpcache == null) {
                this.cache = CacheManager.getInstance().getCacheFactory().createCache(Collections.EMPTY_MAP);
                CacheManager.getInstance().registerCache(this.cacheName, this.cache);
            } else {
                this.cache = tmpcache;
            }
        }
        catch (CacheException e) {
            throw new NucleusException("Error creating cache", (Throwable)e);
        }
    }

    public void close() {
        this.clear();
    }

    public void clear() {
        this.cache.clear();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void evictAll() {
        this.cache.evict();
    }

    public boolean contains(String queryKey) {
        return this.get(queryKey) != null;
    }

    public void evict(String queryKey) {
        this.cache.remove(queryKey);
    }

    public CachedQuery get(String queryKey) {
        return (CachedQuery)this.cache.get(queryKey);
    }

    public CachedQuery put(String queryKey, CachedQuery cachedQuery) {
        if (queryKey == null || cachedQuery == null) {
            return null;
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            new ObjectOutputStream(os).writeObject(cachedQuery);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.cache.put(queryKey, cachedQuery);
        return cachedQuery;
    }

    public int size() {
        return this.cache.size();
    }
}

