/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache.ehcache;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.ObjectExistsException;
import org.datanucleus.OMFContext;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.query.cache.CachedQuery;
import org.datanucleus.store.query.cache.QueryCache;
import org.datanucleus.util.NucleusLogger;

public class EhcacheQueryCache
implements QueryCache {
    private final CacheManager cacheManager;
    private final Cache cache;
    static /* synthetic */ Class class$net$sf$ehcache$CacheManager;

    public EhcacheQueryCache(OMFContext omfCtx) {
        PersistenceConfiguration conf = omfCtx.getPersistenceConfiguration();
        String configFile = conf.getStringProperty("datanucleus.cache.query.configurationFile");
        String cacheName = conf.getStringProperty("datanucleus.cache.query.cacheName");
        if (cacheName == null) {
            NucleusLogger.CACHE.warn((Object)"No 'datanucleus.cache.query.cacheName' specified so using name of 'DataNucleus-Query'");
            cacheName = "DataNucleus-Query";
        }
        try {
            this.cacheManager = configFile == null ? CacheManager.create() : CacheManager.create((URL)(class$net$sf$ehcache$CacheManager == null ? (class$net$sf$ehcache$CacheManager = EhcacheQueryCache.class$("net.sf.ehcache.CacheManager")) : class$net$sf$ehcache$CacheManager).getResource(configFile));
        }
        catch (CacheException e) {
            throw new NucleusException("Cant create cache", (Throwable)e);
        }
        if (!this.cacheManager.cacheExists(cacheName)) {
            try {
                this.cacheManager.addCache(cacheName);
            }
            catch (IllegalStateException e) {
                NucleusLogger.CACHE.warn((Object)("Error creating Cache : " + e.getMessage()));
                throw new NucleusException("Cant create cache", (Throwable)e);
            }
            catch (ObjectExistsException e) {
                NucleusLogger.CACHE.warn((Object)("Error creating Cache : " + e.getMessage()));
                throw new NucleusException("Cant create cache", (Throwable)e);
            }
            catch (CacheException e) {
                NucleusLogger.CACHE.warn((Object)("Error creating Cache : " + e.getMessage()));
                throw new NucleusException("Cant create cache", (Throwable)e);
            }
        }
        this.cache = this.cacheManager.getCache(cacheName);
    }

    public void close() {
        this.clear();
        this.cacheManager.shutdown();
    }

    public void clear() {
        try {
            this.cache.removeAll();
        }
        catch (IllegalStateException e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.clear : " + e.getMessage()));
        }
        catch (IOException e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.clear : " + e.getMessage()));
        }
    }

    public boolean contains(String queryKey) {
        try {
            return this.get(queryKey) != null;
        }
        catch (IllegalStateException e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.contains : " + e.getMessage()));
            return false;
        }
    }

    public CachedQuery get(String queryKey) {
        try {
            Element element = this.cache.get((Serializable)((Object)queryKey));
            if (element == null) {
                return null;
            }
            return this.toCachedQuery(element);
        }
        catch (IllegalStateException e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.get : " + e.getMessage()));
        }
        catch (CacheException e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.get : " + e.getMessage()));
        }
        return null;
    }

    private CachedQuery toCachedQuery(Element object) {
        return (CachedQuery)object.getValue();
    }

    private Element toElement(String queryKey, CachedQuery cachedQuery) {
        return new Element((Serializable)((Object)queryKey), (Serializable)cachedQuery);
    }

    public int size() {
        try {
            return this.cache.getSize();
        }
        catch (IllegalStateException e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.getSize : " + e.getMessage()));
        }
        catch (CacheException e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.getSize : " + e.getMessage()));
        }
        return 0;
    }

    public boolean isEmpty() {
        try {
            return this.cache.getSize() == 0;
        }
        catch (IllegalStateException e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.isEmpty : " + e.getMessage()));
        }
        catch (CacheException e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.isEmpty : " + e.getMessage()));
        }
        return true;
    }

    public CachedQuery put(String queryKey, CachedQuery cachedQuery) {
        if (queryKey == null || cachedQuery == null) {
            return null;
        }
        this.cache.put(this.toElement(queryKey, cachedQuery));
        return cachedQuery;
    }

    public void evict(String queryKey) {
        CachedQuery pc = this.get(queryKey);
        if (pc != null) {
            this.cache.remove((Serializable)this.toElement(queryKey, pc));
        }
    }

    public void evictAll() {
        this.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

