/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache.swarmcache;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import net.sf.swarmcache.CacheFactory;
import net.sf.swarmcache.ObjectCache;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManagerHelper;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.cache.Level2Cache;
import org.datanucleus.util.NucleusLogger;

public class SwarmCacheLevel2Cache
implements Level2Cache {
    private final ObjectCache cache;
    private String cacheName;

    public SwarmCacheLevel2Cache(OMFContext omfCtx) {
        PersistenceConfiguration conf = omfCtx.getPersistenceConfiguration();
        CacheFactory factory = new CacheFactory(null);
        this.cacheName = conf.getStringProperty("datanucleus.cache.level2.cacheName");
        if (this.cacheName == null) {
            NucleusLogger.CACHE.warn((Object)"No 'datanucleus.cache.level2.cacheName' specified so using name of 'DataNucleus'");
            this.cacheName = "DataNucleus";
        }
        this.cache = factory.createCache(this.cacheName);
    }

    public void close() {
        this.clear();
    }

    public void clear() {
        this.cache.clearAll();
    }

    public boolean containsOid(Object oid) {
        return this.get(oid) != null;
    }

    public CachedPC get(Object oid) {
        if (oid instanceof Serializable) {
            return (CachedPC)this.cache.get((Serializable)oid);
        }
        throw new UnsupportedOperationException("SwarmCache doesnt support use of keys that aren't Serializable");
    }

    public int getNumberOfPinnedObjects() {
        throw new UnsupportedOperationException("getNumberOfPinnedObjects() method not yet supported by SwarmCache plugin");
    }

    public int getNumberOfUnpinnedObjects() {
        throw new UnsupportedOperationException("getNumberOfUnpinnedObjects() method not yet supported by SwarmCache plugin");
    }

    public int getSize() {
        throw new UnsupportedOperationException("getSize() method not yet supported by SwarmCache plugin");
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public CachedPC put(Object oid, CachedPC pc) {
        if (oid == null || pc == null) {
            return null;
        }
        if (ObjectManagerHelper.getObjectManager((Object)pc.getPersistableObject()) != null) {
            return null;
        }
        if (!(oid instanceof Serializable)) {
            throw new UnsupportedOperationException("SwarmCache doesnt support use of keys that aren't Serializable");
        }
        this.cache.put((Serializable)oid, (Object)pc);
        return pc;
    }

    public void evict(Object oid) {
        if (!(oid instanceof Serializable)) {
            throw new UnsupportedOperationException("SwarmCache doesnt support use of keys that aren't Serializable");
        }
        this.cache.clear((Serializable)oid);
    }

    public void evictAll() {
        this.clear();
    }

    public void evictAll(Class pcClass, boolean subclasses) {
        throw new UnsupportedOperationException("evict(Class, boolean) method not yet supported by SwarmCache plugin");
    }

    public void evictAll(Collection oids) {
        if (oids == null) {
            return;
        }
        Iterator iter = oids.iterator();
        while (iter.hasNext()) {
            this.evict(iter.next());
        }
    }

    public void evictAll(Object[] oids) {
        if (oids == null) {
            return;
        }
        for (int i = 0; i < oids.length; ++i) {
            this.evict(oids[i]);
        }
    }

    public void pin(Object oid) {
        throw new UnsupportedOperationException("pinAll(Object) method not yet supported by SwarmCache plugin");
    }

    public void pinAll(Class pcClass, boolean subclasses) {
        throw new UnsupportedOperationException("pinAll(Class, boolean) method not yet supported by SwarmCache plugin");
    }

    public void pinAll(Collection oids) {
        throw new UnsupportedOperationException("pinAll(Collection) method not yet supported by SwarmCache plugin");
    }

    public void pinAll(Object[] oids) {
        throw new UnsupportedOperationException("pinAll(Object[]) method not yet supported by SwarmCache plugin");
    }

    public void unpin(Object oid) {
        throw new UnsupportedOperationException("unpin(Object) method not yet supported by SwarmCache plugin");
    }

    public void unpinAll(Class pcClass, boolean subclasses) {
        throw new UnsupportedOperationException("unpinAll(Class, boolean) method not yet supported by SwarmCache plugin");
    }

    public void unpinAll(Collection oids) {
        throw new UnsupportedOperationException("unpinAll(Collection) method not yet supported by SwarmCache plugin");
    }

    public void unpinAll(Object[] oids) {
        throw new UnsupportedOperationException("unpinAll(Object[]) method not yet supported by SwarmCache plugin");
    }
}

