/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa.criteria;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.persistence.Tuple;
import javax.persistence.criteria.CollectionJoin;
import javax.persistence.criteria.CompoundSelection;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.SetJoin;
import javax.persistence.criteria.Subquery;
import org.datanucleus.api.jpa.JPAEntityManagerFactory;
import org.datanucleus.api.jpa.criteria.CaseExpressionImpl;
import org.datanucleus.api.jpa.criteria.CoalesceExpression;
import org.datanucleus.api.jpa.criteria.CompoundSelectionImpl;
import org.datanucleus.api.jpa.criteria.ConcatExpression;
import org.datanucleus.api.jpa.criteria.CriteriaDeleteImpl;
import org.datanucleus.api.jpa.criteria.CriteriaQueryImpl;
import org.datanucleus.api.jpa.criteria.CriteriaUpdateImpl;
import org.datanucleus.api.jpa.criteria.ExpressionImpl;
import org.datanucleus.api.jpa.criteria.InPredicate;
import org.datanucleus.api.jpa.criteria.LiteralExpression;
import org.datanucleus.api.jpa.criteria.OrderImpl;
import org.datanucleus.api.jpa.criteria.ParameterExpressionImpl;
import org.datanucleus.api.jpa.criteria.PathImpl;
import org.datanucleus.api.jpa.criteria.PredicateImpl;
import org.datanucleus.api.jpa.criteria.RootImpl;
import org.datanucleus.api.jpa.criteria.SimpleCaseExpressionImpl;
import org.datanucleus.api.jpa.criteria.SubqueryImpl;
import org.datanucleus.api.jpa.criteria.TreatPathImpl;
import org.datanucleus.api.jpa.criteria.TreatRootImpl;
import org.datanucleus.store.query.expression.CreatorExpression;
import org.datanucleus.store.query.expression.DyadicExpression;
import org.datanucleus.store.query.expression.InvokeExpression;
import org.datanucleus.store.query.expression.Literal;
import org.datanucleus.store.query.expression.ParameterExpression;
import org.datanucleus.store.query.expression.SubqueryExpression;
import org.datanucleus.store.query.expression.VariableExpression;

public class CriteriaBuilderImpl
implements CriteriaBuilder,
Serializable {
    static final long serialVersionUID = -1798682551615240941L;
    JPAEntityManagerFactory emf;
    private static long PARAM_NUMBER = 0L;

    public CriteriaBuilderImpl(JPAEntityManagerFactory emf) {
        this.emf = emf;
    }

    public JPAEntityManagerFactory getEntityManagerFactory() {
        return this.emf;
    }

    public CriteriaQuery<Object> createQuery() {
        return new CriteriaQueryImpl<Object>(this, null);
    }

    public <T> CriteriaQuery<T> createQuery(Class<T> resultCls) {
        return new CriteriaQueryImpl<T>(this, resultCls);
    }

    public CriteriaQuery<Tuple> createTupleQuery() {
        return new CriteriaQueryImpl<Tuple>(this, Tuple.class);
    }

    public <T> CriteriaDelete<T> createCriteriaDelete(Class<T> cls) {
        CriteriaDeleteImpl crit = new CriteriaDeleteImpl(this);
        crit.from(cls);
        return crit;
    }

    public <T> CriteriaUpdate<T> createCriteriaUpdate(Class<T> cls) {
        CriteriaUpdateImpl crit = new CriteriaUpdateImpl(this);
        crit.from(cls);
        return crit;
    }

    public Order asc(Expression<?> expr) {
        return new OrderImpl(expr, true);
    }

    public Order desc(Expression<?> expr) {
        return new OrderImpl(expr, false);
    }

    public <N extends Number> Expression<N> abs(Expression<N> expr) {
        List<org.datanucleus.store.query.expression.Expression> args = List.of(((ExpressionImpl)expr).getQueryExpression());
        ExpressionImpl select = new ExpressionImpl(this, expr.getJavaType());
        select.queryExpr = new InvokeExpression(null, "avg", args);
        return select;
    }

    public <N extends Number> Expression<Double> avg(Expression<N> expr) {
        List<org.datanucleus.store.query.expression.Expression> args = List.of(((ExpressionImpl)expr).getQueryExpression());
        ExpressionImpl<Double> select = new ExpressionImpl<Double>(this, Double.class);
        select.queryExpr = new InvokeExpression(null, "avg", args);
        return select;
    }

    public <N extends Number> Expression<Double> avgDistinct(Expression<N> expr) {
        DyadicExpression dyExpr = new DyadicExpression(org.datanucleus.store.query.expression.Expression.OP_DISTINCT, ((ExpressionImpl)expr).getQueryExpression());
        List<DyadicExpression> args = List.of(dyExpr);
        ExpressionImpl<Double> select = new ExpressionImpl<Double>(this, Double.class);
        select.queryExpr = new InvokeExpression(null, "avg", args);
        return select;
    }

    public Expression<Long> count(Expression<?> expr) {
        ExpressionImpl<Long> select = new ExpressionImpl<Long>(this, Long.class);
        List<org.datanucleus.store.query.expression.Expression> args = List.of(((ExpressionImpl)expr).getQueryExpression());
        select.queryExpr = new InvokeExpression(null, "count", args);
        return select;
    }

    public Expression<Long> countDistinct(Expression<?> expr) {
        DyadicExpression dyExpr = new DyadicExpression(org.datanucleus.store.query.expression.Expression.OP_DISTINCT, ((ExpressionImpl)expr).getQueryExpression());
        List<DyadicExpression> args = List.of(dyExpr);
        ExpressionImpl<Long> select = new ExpressionImpl<Long>(this, Long.class);
        select.queryExpr = new InvokeExpression(null, "count", args);
        return select;
    }

    public <N extends Number> Expression<N> max(Expression<N> expr) {
        List<org.datanucleus.store.query.expression.Expression> args = List.of(((ExpressionImpl)expr).getQueryExpression());
        ExpressionImpl select = new ExpressionImpl(this, expr.getJavaType());
        select.queryExpr = new InvokeExpression(null, "max", args);
        return select;
    }

    public <N extends Number> Expression<N> maxDistinct(Expression<N> expr) {
        DyadicExpression dyExpr = new DyadicExpression(org.datanucleus.store.query.expression.Expression.OP_DISTINCT, ((ExpressionImpl)expr).getQueryExpression());
        List<DyadicExpression> args = List.of(dyExpr);
        ExpressionImpl select = new ExpressionImpl(this, expr.getJavaType());
        select.queryExpr = new InvokeExpression(null, "max", args);
        return select;
    }

    public <X extends Comparable<? super X>> Expression<X> greatest(Expression<X> expr) {
        List<org.datanucleus.store.query.expression.Expression> args = List.of(((ExpressionImpl)expr).getQueryExpression());
        ExpressionImpl select = new ExpressionImpl(this, expr.getJavaType());
        select.queryExpr = new InvokeExpression(null, "max", args);
        return select;
    }

    public <N extends Number> Expression<N> min(Expression<N> expr) {
        List<org.datanucleus.store.query.expression.Expression> args = List.of(((ExpressionImpl)expr).getQueryExpression());
        ExpressionImpl select = new ExpressionImpl(this, expr.getJavaType());
        select.queryExpr = new InvokeExpression(null, "min", args);
        return select;
    }

    public <N extends Number> Expression<N> minDistinct(Expression<N> expr) {
        DyadicExpression dyExpr = new DyadicExpression(org.datanucleus.store.query.expression.Expression.OP_DISTINCT, ((ExpressionImpl)expr).getQueryExpression());
        List<DyadicExpression> args = List.of(dyExpr);
        ExpressionImpl select = new ExpressionImpl(this, expr.getJavaType());
        select.queryExpr = new InvokeExpression(null, "min", args);
        return select;
    }

    public <X extends Comparable<? super X>> Expression<X> least(Expression<X> expr) {
        List<org.datanucleus.store.query.expression.Expression> args = List.of(((ExpressionImpl)expr).getQueryExpression());
        ExpressionImpl select = new ExpressionImpl(this, expr.getJavaType());
        select.queryExpr = new InvokeExpression(null, "min", args);
        return select;
    }

    public Expression<Double> sqrt(Expression<? extends Number> expr) {
        ExpressionImpl<Double> select = new ExpressionImpl<Double>(this, Double.class);
        List<org.datanucleus.store.query.expression.Expression> args = List.of(((ExpressionImpl)expr).getQueryExpression());
        select.queryExpr = new InvokeExpression(null, "sqrt", args);
        return select;
    }

    public <N extends Number> Expression<N> sum(Expression<N> expr) {
        List<org.datanucleus.store.query.expression.Expression> args = List.of(((ExpressionImpl)expr).getQueryExpression());
        ExpressionImpl select = new ExpressionImpl(this, expr.getJavaType());
        select.queryExpr = new InvokeExpression(null, "sum", args);
        return select;
    }

    public <N extends Number> Expression<N> sumDistinct(Expression<N> expr) {
        DyadicExpression dyExpr = new DyadicExpression(org.datanucleus.store.query.expression.Expression.OP_DISTINCT, ((ExpressionImpl)expr).getQueryExpression());
        List<DyadicExpression> args = List.of(dyExpr);
        ExpressionImpl select = new ExpressionImpl(this, expr.getJavaType());
        select.queryExpr = new InvokeExpression(null, "sum", args);
        return select;
    }

    public Expression<Double> sumAsDouble(Expression<Float> expr) {
        List<org.datanucleus.store.query.expression.Expression> args = List.of(((ExpressionImpl)expr).getQueryExpression());
        ExpressionImpl<Double> select = new ExpressionImpl<Double>(this, Double.class);
        select.queryExpr = new InvokeExpression(null, "sum", args);
        return select;
    }

    public Expression<Long> sumAsLong(Expression<Integer> expr) {
        List<org.datanucleus.store.query.expression.Expression> args = List.of(((ExpressionImpl)expr).getQueryExpression());
        ExpressionImpl<Long> select = new ExpressionImpl<Long>(this, Long.class);
        select.queryExpr = new InvokeExpression(null, "sum", args);
        return select;
    }

    public Predicate and(Predicate ... preds) {
        PredicateImpl pred = new PredicateImpl(this);
        for (int i = 0; i < preds.length; ++i) {
            pred.append(preds[i]);
        }
        return pred;
    }

    public Predicate and(Expression<Boolean> expr0, Expression<Boolean> expr1) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr0).getQueryExpression(), org.datanucleus.store.query.expression.Expression.OP_AND, ((ExpressionImpl)expr1).getQueryExpression());
        pred.queryExpr = queryExpr;
        return pred;
    }

    public Predicate or(Predicate ... preds) {
        PredicateImpl pred = new PredicateImpl(this, Predicate.BooleanOperator.OR);
        for (int i = 0; i < preds.length; ++i) {
            pred.append(preds[i]);
        }
        return pred;
    }

    public Predicate or(Expression<Boolean> expr0, Expression<Boolean> expr1) {
        PredicateImpl pred = new PredicateImpl(this, Predicate.BooleanOperator.OR);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr0).getQueryExpression(), org.datanucleus.store.query.expression.Expression.OP_OR, ((ExpressionImpl)expr1).getQueryExpression());
        pred.queryExpr = queryExpr;
        return pred;
    }

    public Predicate equal(Expression<?> expr0, Expression<?> expr1) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr0).getQueryExpression(), org.datanucleus.store.query.expression.Expression.OP_EQ, ((ExpressionImpl)expr1).getQueryExpression());
        pred.queryExpr = queryExpr;
        return pred;
    }

    public Predicate equal(Expression<?> expr, Object obj) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr).getQueryExpression(), org.datanucleus.store.query.expression.Expression.OP_EQ, (org.datanucleus.store.query.expression.Expression)new Literal(obj));
        pred.queryExpr = queryExpr;
        return pred;
    }

    public Predicate notEqual(Expression<?> expr0, Expression<?> expr1) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr0).getQueryExpression(), org.datanucleus.store.query.expression.Expression.OP_NOTEQ, ((ExpressionImpl)expr1).getQueryExpression());
        pred.queryExpr = queryExpr;
        return pred;
    }

    public Predicate notEqual(Expression<?> expr, Object obj) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr).getQueryExpression(), org.datanucleus.store.query.expression.Expression.OP_NOTEQ, (org.datanucleus.store.query.expression.Expression)new Literal(obj));
        pred.queryExpr = queryExpr;
        return pred;
    }

    public Predicate isNotNull(Expression<?> expr) {
        return expr.isNotNull();
    }

    public Predicate isNull(Expression<?> expr) {
        return expr.isNull();
    }

    public Predicate ge(Expression<? extends Number> expr0, Expression<? extends Number> expr1) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr0).getQueryExpression(), org.datanucleus.store.query.expression.Expression.OP_GTEQ, ((ExpressionImpl)expr1).getQueryExpression());
        pred.queryExpr = queryExpr;
        return pred;
    }

    public Predicate ge(Expression<? extends Number> expr, Number obj) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr).getQueryExpression(), org.datanucleus.store.query.expression.Expression.OP_GTEQ, (org.datanucleus.store.query.expression.Expression)new Literal((Object)obj));
        pred.queryExpr = queryExpr;
        return pred;
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThan(Expression<? extends Y> expr0, Expression<? extends Y> expr1) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr0).getQueryExpression(), org.datanucleus.store.query.expression.Expression.OP_GT, ((ExpressionImpl)expr1).getQueryExpression());
        pred.queryExpr = queryExpr;
        return pred;
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThan(Expression<? extends Y> expr, Y obj) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr).getQueryExpression(), org.datanucleus.store.query.expression.Expression.OP_GT, (org.datanucleus.store.query.expression.Expression)new Literal(obj));
        pred.queryExpr = queryExpr;
        return pred;
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThanOrEqualTo(Expression<? extends Y> expr0, Expression<? extends Y> expr1) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr0).getQueryExpression(), org.datanucleus.store.query.expression.Expression.OP_GTEQ, ((ExpressionImpl)expr1).getQueryExpression());
        pred.queryExpr = queryExpr;
        return pred;
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThanOrEqualTo(Expression<? extends Y> expr, Y obj) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr).getQueryExpression(), org.datanucleus.store.query.expression.Expression.OP_GTEQ, (org.datanucleus.store.query.expression.Expression)new Literal(obj));
        pred.queryExpr = queryExpr;
        return pred;
    }

    public Predicate gt(Expression<? extends Number> expr0, Expression<? extends Number> expr1) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr0).getQueryExpression(), org.datanucleus.store.query.expression.Expression.OP_GT, ((ExpressionImpl)expr1).getQueryExpression());
        pred.queryExpr = queryExpr;
        return pred;
    }

    public Predicate gt(Expression<? extends Number> expr, Number obj) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr).getQueryExpression(), org.datanucleus.store.query.expression.Expression.OP_GT, (org.datanucleus.store.query.expression.Expression)new Literal((Object)obj));
        pred.queryExpr = queryExpr;
        return pred;
    }

    public Predicate le(Expression<? extends Number> expr0, Expression<? extends Number> expr1) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr0).getQueryExpression(), org.datanucleus.store.query.expression.Expression.OP_LTEQ, ((ExpressionImpl)expr1).getQueryExpression());
        pred.queryExpr = queryExpr;
        return pred;
    }

    public Predicate le(Expression<? extends Number> expr, Number obj) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr).getQueryExpression(), org.datanucleus.store.query.expression.Expression.OP_LTEQ, (org.datanucleus.store.query.expression.Expression)new Literal((Object)obj));
        pred.queryExpr = queryExpr;
        return pred;
    }

    public <Y extends Comparable<? super Y>> Predicate lessThan(Expression<? extends Y> expr0, Expression<? extends Y> expr1) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr0).getQueryExpression(), org.datanucleus.store.query.expression.Expression.OP_LT, ((ExpressionImpl)expr1).getQueryExpression());
        pred.queryExpr = queryExpr;
        return pred;
    }

    public <Y extends Comparable<? super Y>> Predicate lessThan(Expression<? extends Y> expr, Y obj) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr).getQueryExpression(), org.datanucleus.store.query.expression.Expression.OP_LT, (org.datanucleus.store.query.expression.Expression)new Literal(obj));
        pred.queryExpr = queryExpr;
        return pred;
    }

    public <Y extends Comparable<? super Y>> Predicate lessThanOrEqualTo(Expression<? extends Y> expr0, Expression<? extends Y> expr1) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr0).getQueryExpression(), org.datanucleus.store.query.expression.Expression.OP_LTEQ, ((ExpressionImpl)expr1).getQueryExpression());
        pred.queryExpr = queryExpr;
        return pred;
    }

    public <Y extends Comparable<? super Y>> Predicate lessThanOrEqualTo(Expression<? extends Y> expr, Y obj) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr).getQueryExpression(), org.datanucleus.store.query.expression.Expression.OP_LTEQ, (org.datanucleus.store.query.expression.Expression)new Literal(obj));
        pred.queryExpr = queryExpr;
        return pred;
    }

    public Predicate lt(Expression<? extends Number> expr0, Expression<? extends Number> expr1) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr0).getQueryExpression(), org.datanucleus.store.query.expression.Expression.OP_LT, ((ExpressionImpl)expr1).getQueryExpression());
        pred.queryExpr = queryExpr;
        return pred;
    }

    public Predicate lt(Expression<? extends Number> expr, Number obj) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr).getQueryExpression(), org.datanucleus.store.query.expression.Expression.OP_LT, (org.datanucleus.store.query.expression.Expression)new Literal((Object)obj));
        pred.queryExpr = queryExpr;
        return pred;
    }

    public <N extends Number> Expression<N> sum(Expression<? extends N> expr0, Expression<? extends N> expr1) {
        ExpressionImpl sumExpr = new ExpressionImpl(this, expr0.getJavaType());
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr0).getQueryExpression(), org.datanucleus.store.query.expression.Expression.OP_ADD, ((ExpressionImpl)expr1).getQueryExpression());
        sumExpr.queryExpr = queryExpr;
        return sumExpr;
    }

    public <N extends Number> Expression<N> sum(Expression<? extends N> expr, N obj) {
        ExpressionImpl sumExpr = new ExpressionImpl(this, expr.getJavaType());
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr).getQueryExpression(), org.datanucleus.store.query.expression.Expression.OP_ADD, (org.datanucleus.store.query.expression.Expression)new Literal(obj));
        sumExpr.queryExpr = queryExpr;
        return sumExpr;
    }

    public <N extends Number> Expression<N> sum(N obj, Expression<? extends N> expr) {
        ExpressionImpl sumExpr = new ExpressionImpl(this, expr.getJavaType());
        DyadicExpression queryExpr = new DyadicExpression((org.datanucleus.store.query.expression.Expression)new Literal(obj), org.datanucleus.store.query.expression.Expression.OP_ADD, ((ExpressionImpl)expr).getQueryExpression());
        sumExpr.queryExpr = queryExpr;
        return sumExpr;
    }

    public Expression<Number> quot(Expression<? extends Number> expr0, Expression<? extends Number> expr1) {
        ExpressionImpl<Number> sumExpr = new ExpressionImpl<Number>(this, Number.class);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr0).getQueryExpression(), org.datanucleus.store.query.expression.Expression.OP_DIV, ((ExpressionImpl)expr1).getQueryExpression());
        sumExpr.queryExpr = queryExpr;
        return sumExpr;
    }

    public Expression<Number> quot(Expression<? extends Number> expr, Number obj) {
        ExpressionImpl<Number> sumExpr = new ExpressionImpl<Number>(this, Number.class);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr).getQueryExpression(), org.datanucleus.store.query.expression.Expression.OP_DIV, (org.datanucleus.store.query.expression.Expression)new Literal((Object)obj));
        sumExpr.queryExpr = queryExpr;
        return sumExpr;
    }

    public Expression<Number> quot(Number obj, Expression<? extends Number> expr) {
        ExpressionImpl<Number> sumExpr = new ExpressionImpl<Number>(this, Number.class);
        DyadicExpression queryExpr = new DyadicExpression((org.datanucleus.store.query.expression.Expression)new Literal((Object)obj), org.datanucleus.store.query.expression.Expression.OP_DIV, ((ExpressionImpl)expr).getQueryExpression());
        sumExpr.queryExpr = queryExpr;
        return sumExpr;
    }

    public <N extends Number> Expression<N> diff(Expression<? extends N> expr0, Expression<? extends N> expr1) {
        ExpressionImpl sumExpr = new ExpressionImpl(this, expr0.getJavaType());
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr0).getQueryExpression(), org.datanucleus.store.query.expression.Expression.OP_SUB, ((ExpressionImpl)expr1).getQueryExpression());
        sumExpr.queryExpr = queryExpr;
        return sumExpr;
    }

    public <N extends Number> Expression<N> diff(Expression<? extends N> expr, N obj) {
        ExpressionImpl sumExpr = new ExpressionImpl(this, expr.getJavaType());
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr).getQueryExpression(), org.datanucleus.store.query.expression.Expression.OP_SUB, (org.datanucleus.store.query.expression.Expression)new Literal(obj));
        sumExpr.queryExpr = queryExpr;
        return sumExpr;
    }

    public <N extends Number> Expression<N> diff(N obj, Expression<? extends N> expr) {
        ExpressionImpl sumExpr = new ExpressionImpl(this, expr.getJavaType());
        DyadicExpression queryExpr = new DyadicExpression((org.datanucleus.store.query.expression.Expression)new Literal(obj), org.datanucleus.store.query.expression.Expression.OP_SUB, ((ExpressionImpl)expr).getQueryExpression());
        sumExpr.queryExpr = queryExpr;
        return sumExpr;
    }

    public <N extends Number> Expression<N> prod(Expression<? extends N> expr0, Expression<? extends N> expr1) {
        ExpressionImpl sumExpr = new ExpressionImpl(this, expr0.getJavaType());
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr0).getQueryExpression(), org.datanucleus.store.query.expression.Expression.OP_MUL, ((ExpressionImpl)expr1).getQueryExpression());
        sumExpr.queryExpr = queryExpr;
        return sumExpr;
    }

    public <N extends Number> Expression<N> prod(Expression<? extends N> expr, N obj) {
        ExpressionImpl sumExpr = new ExpressionImpl(this, expr.getJavaType());
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr).getQueryExpression(), org.datanucleus.store.query.expression.Expression.OP_MUL, (org.datanucleus.store.query.expression.Expression)new Literal(obj));
        sumExpr.queryExpr = queryExpr;
        return sumExpr;
    }

    public <N extends Number> Expression<N> prod(N obj, Expression<? extends N> expr) {
        ExpressionImpl sumExpr = new ExpressionImpl(this, expr.getJavaType());
        DyadicExpression queryExpr = new DyadicExpression((org.datanucleus.store.query.expression.Expression)new Literal(obj), org.datanucleus.store.query.expression.Expression.OP_MUL, ((ExpressionImpl)expr).getQueryExpression());
        sumExpr.queryExpr = queryExpr;
        return sumExpr;
    }

    public Expression<Integer> mod(Expression<Integer> expr0, Expression<Integer> expr1) {
        ExpressionImpl<Integer> sumExpr = new ExpressionImpl<Integer>(this, Integer.class);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr0).getQueryExpression(), org.datanucleus.store.query.expression.Expression.OP_MOD, ((ExpressionImpl)expr1).getQueryExpression());
        sumExpr.queryExpr = queryExpr;
        return sumExpr;
    }

    public Expression<Integer> mod(Expression<Integer> expr, Integer obj) {
        ExpressionImpl<Integer> sumExpr = new ExpressionImpl<Integer>(this, Integer.class);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr).getQueryExpression(), org.datanucleus.store.query.expression.Expression.OP_MOD, (org.datanucleus.store.query.expression.Expression)new Literal((Object)obj));
        sumExpr.queryExpr = queryExpr;
        return sumExpr;
    }

    public Expression<Integer> mod(Integer obj, Expression<Integer> expr) {
        ExpressionImpl<Integer> sumExpr = new ExpressionImpl<Integer>(this, Integer.class);
        DyadicExpression queryExpr = new DyadicExpression((org.datanucleus.store.query.expression.Expression)new Literal((Object)obj), org.datanucleus.store.query.expression.Expression.OP_MOD, ((ExpressionImpl)expr).getQueryExpression());
        sumExpr.queryExpr = queryExpr;
        return sumExpr;
    }

    public <Y extends Comparable<? super Y>> Predicate between(Expression<? extends Y> expr0, Expression<? extends Y> expr1, Expression<? extends Y> expr2) {
        PredicateImpl pred = new PredicateImpl(this);
        org.datanucleus.store.query.expression.Expression theExpr = ((ExpressionImpl)expr0).getQueryExpression();
        org.datanucleus.store.query.expression.Expression lowerExpr = ((ExpressionImpl)expr1).getQueryExpression();
        org.datanucleus.store.query.expression.Expression upperExpr = ((ExpressionImpl)expr2).getQueryExpression();
        DyadicExpression lowerDyadic = new DyadicExpression(theExpr, org.datanucleus.store.query.expression.Expression.OP_GTEQ, lowerExpr);
        DyadicExpression upperDyadic = new DyadicExpression(theExpr, org.datanucleus.store.query.expression.Expression.OP_LTEQ, upperExpr);
        DyadicExpression overallDyadic = new DyadicExpression((org.datanucleus.store.query.expression.Expression)lowerDyadic, org.datanucleus.store.query.expression.Expression.OP_AND, (org.datanucleus.store.query.expression.Expression)upperDyadic);
        pred.queryExpr = overallDyadic;
        return pred;
    }

    public <Y extends Comparable<? super Y>> Predicate between(Expression<? extends Y> expr, Y obj0, Y obj1) {
        PredicateImpl pred = new PredicateImpl(this);
        org.datanucleus.store.query.expression.Expression theExpr = ((ExpressionImpl)expr).getQueryExpression();
        DyadicExpression lowerDyadic = new DyadicExpression(theExpr, org.datanucleus.store.query.expression.Expression.OP_GTEQ, (org.datanucleus.store.query.expression.Expression)new Literal(obj0));
        DyadicExpression upperDyadic = new DyadicExpression(theExpr, org.datanucleus.store.query.expression.Expression.OP_LTEQ, (org.datanucleus.store.query.expression.Expression)new Literal(obj1));
        DyadicExpression overallDyadic = new DyadicExpression((org.datanucleus.store.query.expression.Expression)lowerDyadic, org.datanucleus.store.query.expression.Expression.OP_AND, (org.datanucleus.store.query.expression.Expression)upperDyadic);
        pred.queryExpr = overallDyadic;
        return pred;
    }

    public <T> CriteriaBuilder.Coalesce<T> coalesce() {
        return new CoalesceExpression<Object>(this, Object.class);
    }

    public <Y> Expression<Y> coalesce(Expression<? extends Y> expr0, Expression<? extends Y> expr1) {
        CoalesceExpression<Expression<? extends Y>> coalesceExpr = new CoalesceExpression<Expression<? extends Y>>(this, expr0.getJavaType());
        coalesceExpr.value(expr0);
        coalesceExpr.value(expr1);
        return coalesceExpr;
    }

    public <Y> Expression<Y> coalesce(Expression<? extends Y> expr, Y val) {
        CoalesceExpression<Object> coalesceExpr = new CoalesceExpression<Object>(this, expr.getJavaType());
        coalesceExpr.value(expr);
        coalesceExpr.value(val);
        return coalesceExpr;
    }

    public <Y> Expression<Y> nullif(Expression<Y> expr0, Expression<?> expr1) {
        List<org.datanucleus.store.query.expression.Expression> args = List.of(((ExpressionImpl)expr0).getQueryExpression(), ((ExpressionImpl)expr1).getQueryExpression());
        ExpressionImpl coalExpr = new ExpressionImpl(this, expr0.getJavaType());
        coalExpr.queryExpr = new InvokeExpression(null, "NULLIF", args);
        return coalExpr;
    }

    public <Y> Expression<Y> nullif(Expression<Y> expr, Y val) {
        List<Literal> args = List.of(((ExpressionImpl)expr).getQueryExpression(), new Literal(val));
        ExpressionImpl coalExpr = new ExpressionImpl(this, expr.getJavaType());
        coalExpr.queryExpr = new InvokeExpression(null, "NULLIF", args);
        return coalExpr;
    }

    public Predicate conjunction() {
        PredicateImpl pred = new PredicateImpl(this);
        pred.queryExpr = new Literal((Object)Boolean.TRUE);
        return pred;
    }

    public Predicate disjunction() {
        PredicateImpl pred = new PredicateImpl(this);
        pred.queryExpr = new Literal((Object)Boolean.FALSE);
        return pred;
    }

    public <Y> CompoundSelection<Y> construct(Class<Y> cls, Selection<?> ... args) {
        CompoundSelectionImpl<Y> select = new CompoundSelectionImpl<Y>(this, cls, args);
        ArrayList<String> clsNameComponents = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(cls.getName(), ".");
        while (tok.hasMoreTokens()) {
            clsNameComponents.add(tok.nextToken());
        }
        ArrayList<org.datanucleus.store.query.expression.Expression> ctrArgs = new ArrayList<org.datanucleus.store.query.expression.Expression>();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                ExpressionImpl argExpr = (ExpressionImpl)args[i];
                ctrArgs.add(argExpr.queryExpr);
            }
        }
        select.queryExpr = new CreatorExpression(clsNameComponents, ctrArgs);
        return select;
    }

    public Expression<Date> currentDate() {
        ExpressionImpl<Date> select = new ExpressionImpl<Date>(this, Date.class);
        select.queryExpr = new InvokeExpression(null, "CURRENT_DATE", null);
        return select;
    }

    public Expression<Time> currentTime() {
        ExpressionImpl<Time> select = new ExpressionImpl<Time>(this, Time.class);
        select.queryExpr = new InvokeExpression(null, "CURRENT_TIME", null);
        return select;
    }

    public Expression<Timestamp> currentTimestamp() {
        ExpressionImpl<Timestamp> select = new ExpressionImpl<Timestamp>(this, Timestamp.class);
        select.queryExpr = new InvokeExpression(null, "CURRENT_TIMESTAMP", null);
        return select;
    }

    public <T> Expression<T> function(String funcName, Class<T> returnType, Expression<?> ... argExprs) {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(new Literal((Object)funcName));
        if (argExprs != null) {
            for (int i = 0; i < argExprs.length; ++i) {
                args.add(((ExpressionImpl)argExprs[i]).getQueryExpression());
            }
        }
        ExpressionImpl<T> funcExpr = new ExpressionImpl<T>(this, returnType);
        funcExpr.queryExpr = new InvokeExpression(null, "SQL_function", args);
        return funcExpr;
    }

    public <Y> Expression<Y> all(Subquery<Y> sub) {
        org.datanucleus.store.query.expression.Expression subExpr = ((SubqueryImpl)sub).getQueryExpression();
        Object varName = null;
        varName = subExpr instanceof VariableExpression ? ((VariableExpression)subExpr).getId() : "SUB" + SubqueryImpl.random.nextInt();
        ExpressionImpl allExpr = new ExpressionImpl(this, sub.getJavaType());
        allExpr.queryExpr = new SubqueryExpression("ALL", new VariableExpression((String)varName));
        return allExpr;
    }

    public <Y> Expression<Y> any(Subquery<Y> sub) {
        org.datanucleus.store.query.expression.Expression subExpr = ((SubqueryImpl)sub).getQueryExpression();
        Object varName = null;
        varName = subExpr instanceof VariableExpression ? ((VariableExpression)subExpr).getId() : "SUB" + SubqueryImpl.random.nextInt();
        ExpressionImpl allExpr = new ExpressionImpl(this, sub.getJavaType());
        allExpr.queryExpr = new SubqueryExpression("ANY", new VariableExpression((String)varName));
        return allExpr;
    }

    public <Y> Expression<Y> some(Subquery<Y> sub) {
        org.datanucleus.store.query.expression.Expression subExpr = ((SubqueryImpl)sub).getQueryExpression();
        Object varName = null;
        varName = subExpr instanceof VariableExpression ? ((VariableExpression)subExpr).getId() : "SUB" + SubqueryImpl.random.nextInt();
        ExpressionImpl allExpr = new ExpressionImpl(this, sub.getJavaType());
        allExpr.queryExpr = new SubqueryExpression("SOME", new VariableExpression((String)varName));
        return allExpr;
    }

    public Predicate exists(Subquery<?> sub) {
        PredicateImpl pred = new PredicateImpl(this);
        org.datanucleus.store.query.expression.Expression subExpr = ((SubqueryImpl)sub).getQueryExpression();
        Object varName = null;
        varName = subExpr instanceof VariableExpression ? ((VariableExpression)subExpr).getId() : "SUB" + SubqueryImpl.random.nextInt();
        pred.queryExpr = new SubqueryExpression("EXISTS", new VariableExpression((String)varName));
        return pred;
    }

    public <X> CriteriaBuilder.In<X> in(Expression<? extends X> expr) {
        return new InPredicate<X>(this, expr);
    }

    public <X> CriteriaBuilder.In<X> in(Expression<? extends X> expr, Expression<? extends X> ... values) {
        return new InPredicate<X>(this, expr, values);
    }

    public <X> CriteriaBuilder.In<X> in(Expression<? extends X> expr, X ... values) {
        return new InPredicate<X>(this, expr, values);
    }

    public <X> CriteriaBuilder.In<X> in(Expression<? extends X> expr, Collection<X> values) {
        return new InPredicate<X>(this, expr, values);
    }

    public <C extends Collection<?>> Predicate isEmpty(Expression<C> collExpr) {
        PredicateImpl pred = new PredicateImpl(this);
        InvokeExpression queryExpr = new InvokeExpression(((ExpressionImpl)collExpr).getQueryExpression(), "isEmpty", null);
        pred.queryExpr = queryExpr;
        return pred;
    }

    public <E, C extends Collection<E>> Predicate isMember(Expression<E> expr, Expression<C> collExpr) {
        List<org.datanucleus.store.query.expression.Expression> args = List.of(((ExpressionImpl)expr).getQueryExpression());
        InvokeExpression queryExpr = new InvokeExpression(((ExpressionImpl)collExpr).getQueryExpression(), "contains", args);
        PredicateImpl pred = new PredicateImpl(this);
        pred.queryExpr = queryExpr;
        return pred;
    }

    public <E, C extends Collection<E>> Predicate isMember(E val, Expression<C> collExpr) {
        List<Literal> args = List.of(new Literal(val));
        InvokeExpression queryExpr = new InvokeExpression(((ExpressionImpl)collExpr).getQueryExpression(), "contains", args);
        PredicateImpl pred = new PredicateImpl(this);
        pred.queryExpr = queryExpr;
        return pred;
    }

    public <C extends Collection<?>> Predicate isNotEmpty(Expression<C> collExpr) {
        return this.isEmpty(collExpr).not();
    }

    public <E, C extends Collection<E>> Predicate isNotMember(Expression<E> expr, Expression<C> collExpr) {
        return this.isMember((E)expr, collExpr).not();
    }

    public <E, C extends Collection<E>> Predicate isNotMember(E val, Expression<C> collExpr) {
        return this.isMember(val, collExpr).not();
    }

    public <C extends Collection<?>> Expression<Integer> size(Expression<C> expr) {
        ExpressionImpl<Integer> collSizeExpr = new ExpressionImpl<Integer>(this, Integer.class);
        collSizeExpr.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "size", null);
        return collSizeExpr;
    }

    public <C extends Collection<?>> Expression<Integer> size(C coll) {
        ExpressionImpl<Integer> collSizeExpr = new ExpressionImpl<Integer>(this, Integer.class);
        collSizeExpr.queryExpr = new Literal((Object)coll.size());
        return collSizeExpr;
    }

    public Predicate isFalse(Expression<Boolean> expr) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr).getQueryExpression(), org.datanucleus.store.query.expression.Expression.OP_EQ, (org.datanucleus.store.query.expression.Expression)new Literal((Object)Boolean.FALSE));
        pred.queryExpr = queryExpr;
        return pred;
    }

    public Predicate isTrue(Expression<Boolean> expr) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr).getQueryExpression(), org.datanucleus.store.query.expression.Expression.OP_EQ, (org.datanucleus.store.query.expression.Expression)new Literal((Object)Boolean.TRUE));
        pred.queryExpr = queryExpr;
        return pred;
    }

    public CompoundSelection<Tuple> tuple(Selection<?> ... selections) {
        return new CompoundSelectionImpl<Tuple>(this, Tuple.class, selections);
    }

    public CompoundSelection<Object[]> array(Selection<?> ... selections) {
        return new CompoundSelectionImpl<Object[]>(this, Object[].class, selections);
    }

    public <K, M extends Map<K, ?>> Expression<Set<K>> keys(M map) {
        throw new UnsupportedOperationException("CriteriaBuilder.keys not yet implemented. Provide a testcase that uses this and raise an issue attaching your testcase");
    }

    public <V, M extends Map<?, V>> Expression<Collection<V>> values(M map) {
        throw new UnsupportedOperationException("CriteriaBuilder.values not yet implemented. Provide a testcase that uses this and raise an issue attaching your testcase");
    }

    public Predicate like(Expression<String> expr, Expression<String> expr1) {
        List<org.datanucleus.store.query.expression.Expression> args = List.of(((ExpressionImpl)expr1).getQueryExpression());
        PredicateImpl pred = new PredicateImpl(this);
        pred.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "matches", args);
        return pred;
    }

    public Predicate like(Expression<String> expr, String regex) {
        List<Literal> args = List.of(new Literal((Object)regex));
        PredicateImpl pred = new PredicateImpl(this);
        pred.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "matches", args);
        return pred;
    }

    public Predicate like(Expression<String> expr, Expression<String> expr1, Expression<Character> escExpr) {
        List<org.datanucleus.store.query.expression.Expression> args = List.of(((ExpressionImpl)expr1).getQueryExpression(), ((ExpressionImpl)escExpr).getQueryExpression());
        PredicateImpl pred = new PredicateImpl(this);
        pred.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "matches", args);
        return pred;
    }

    public Predicate like(Expression<String> expr, Expression<String> expr1, char escChr) {
        List<Literal> args = List.of(((ExpressionImpl)expr1).getQueryExpression(), new Literal((Object)Character.valueOf(escChr)));
        PredicateImpl pred = new PredicateImpl(this);
        pred.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "matches", args);
        return pred;
    }

    public Predicate like(Expression<String> expr, String regex, Expression<Character> escExpr) {
        List<org.datanucleus.store.query.expression.Expression> args = List.of(new Literal((Object)regex), ((ExpressionImpl)escExpr).getQueryExpression());
        PredicateImpl pred = new PredicateImpl(this);
        pred.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "matches", args);
        return pred;
    }

    public Predicate like(Expression<String> expr, String regex, char escChr) {
        List<Literal> args = List.of(new Literal((Object)regex), new Literal((Object)Character.valueOf(escChr)));
        PredicateImpl pred = new PredicateImpl(this);
        pred.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "matches", args);
        return pred;
    }

    public <N extends Number> Expression<N> neg(Expression<N> expr) {
        ExpressionImpl negExpr = new ExpressionImpl(this, expr.getJavaType());
        negExpr.queryExpr = new DyadicExpression(org.datanucleus.store.query.expression.Expression.OP_NEG, ((ExpressionImpl)expr).getQueryExpression());
        return negExpr;
    }

    public Predicate not(Expression<Boolean> expr) {
        PredicateImpl pred = new PredicateImpl(this);
        pred.queryExpr = new DyadicExpression(org.datanucleus.store.query.expression.Expression.OP_NOT, ((ExpressionImpl)expr).getQueryExpression());
        return pred;
    }

    public Predicate notLike(Expression<String> expr, Expression<String> expr1) {
        return this.like(expr, expr1).not();
    }

    public Predicate notLike(Expression<String> expr, String regex) {
        return this.like(expr, regex).not();
    }

    public Predicate notLike(Expression<String> expr, Expression<String> expr1, Expression<Character> escExpr) {
        return this.like(expr, expr1, escExpr).not();
    }

    public Predicate notLike(Expression<String> expr, Expression<String> expr1, char escChr) {
        return this.like(expr, expr1, escChr).not();
    }

    public Predicate notLike(Expression<String> expr, String regex, Expression<Character> escExpr) {
        return this.like(expr, regex, escExpr).not();
    }

    public Predicate notLike(Expression<String> expr, String regex, char escChr) {
        return this.like(expr, regex, escChr).not();
    }

    public <T> javax.persistence.criteria.ParameterExpression<T> parameter(Class<T> cls) {
        String paramName = "DN_PARAM_" + PARAM_NUMBER++;
        ParameterExpressionImpl<T> param = new ParameterExpressionImpl<T>(this, cls, paramName);
        param.queryExpr = new ParameterExpression(paramName, cls);
        return param;
    }

    public <T> javax.persistence.criteria.ParameterExpression<T> parameter(Class<T> cls, String name) {
        ParameterExpressionImpl<T> param = new ParameterExpressionImpl<T>(this, cls, name);
        param.queryExpr = new ParameterExpression(name, cls);
        return param;
    }

    public <R> CriteriaBuilder.Case<R> selectCase() {
        CaseExpressionImpl caseExpr = new CaseExpressionImpl(this);
        return caseExpr;
    }

    public <C, R> CriteriaBuilder.SimpleCase<C, R> selectCase(Expression<? extends C> expr) {
        SimpleCaseExpressionImpl caseExpr = new SimpleCaseExpressionImpl(this, (ExpressionImpl)expr);
        return caseExpr;
    }

    public Expression<BigDecimal> toBigDecimal(Expression<? extends Number> expr) {
        return expr.as(BigDecimal.class);
    }

    public Expression<BigInteger> toBigInteger(Expression<? extends Number> expr) {
        return expr.as(BigInteger.class);
    }

    public Expression<Double> toDouble(Expression<? extends Number> expr) {
        return expr.as(Double.class);
    }

    public Expression<Float> toFloat(Expression<? extends Number> expr) {
        return expr.as(Float.class);
    }

    public Expression<Integer> toInteger(Expression<? extends Number> expr) {
        return expr.as(Integer.class);
    }

    public Expression<Long> toLong(Expression<? extends Number> expr) {
        return expr.as(Long.class);
    }

    public Expression<String> toString(Expression<Character> expr) {
        return expr.as(String.class);
    }

    public Expression<String> concat(Expression<String> expr0, Expression<String> expr1) {
        return new ConcatExpression(this, expr0, expr1);
    }

    public Expression<String> concat(Expression<String> expr, String val) {
        return new ConcatExpression(this, expr, new LiteralExpression<String>(this, val));
    }

    public Expression<String> concat(String val, Expression<String> expr) {
        return new ConcatExpression(this, new LiteralExpression<String>(this, val), expr);
    }

    public Expression<Integer> locate(Expression<String> expr, Expression<String> exprSubstr) {
        List<org.datanucleus.store.query.expression.Expression> args = List.of(((ExpressionImpl)exprSubstr).getQueryExpression());
        ExpressionImpl<Integer> select = new ExpressionImpl<Integer>(this, Integer.class);
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "indexOf", args);
        return select;
    }

    public Expression<Integer> locate(Expression<String> expr, String substr) {
        List<Literal> args = List.of(new Literal((Object)substr));
        ExpressionImpl<Integer> select = new ExpressionImpl<Integer>(this, Integer.class);
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "indexOf", args);
        return select;
    }

    public Expression<Integer> locate(Expression<String> expr, Expression<String> exprSubstr, Expression<Integer> exprPos) {
        List<org.datanucleus.store.query.expression.Expression> args = List.of(((ExpressionImpl)exprSubstr).getQueryExpression(), ((ExpressionImpl)exprPos).getQueryExpression());
        ExpressionImpl<Integer> select = new ExpressionImpl<Integer>(this, Integer.class);
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "indexOf", args);
        return select;
    }

    public Expression<Integer> locate(Expression<String> expr, String substr, int pos) {
        List<Literal> args = List.of(new Literal((Object)substr), new Literal((Object)pos));
        ExpressionImpl<Integer> select = new ExpressionImpl<Integer>(this, Integer.class);
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "indexOf", args);
        return select;
    }

    public Expression<String> substring(Expression<String> expr, Expression<Integer> posExpr) {
        List<org.datanucleus.store.query.expression.Expression> args = List.of(((ExpressionImpl)posExpr).getQueryExpression());
        ExpressionImpl<String> select = new ExpressionImpl<String>(this, expr.getJavaType());
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "substring", args);
        return select;
    }

    public Expression<String> substring(Expression<String> expr, int pos) {
        List<Literal> args = List.of(new Literal((Object)pos));
        ExpressionImpl<String> select = new ExpressionImpl<String>(this, expr.getJavaType());
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "substring", args);
        return select;
    }

    public Expression<String> substring(Expression<String> expr, Expression<Integer> posExpr0, Expression<Integer> posExpr1) {
        List<org.datanucleus.store.query.expression.Expression> args = List.of(((ExpressionImpl)posExpr0).getQueryExpression(), ((ExpressionImpl)posExpr1).getQueryExpression());
        ExpressionImpl<String> select = new ExpressionImpl<String>(this, expr.getJavaType());
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "substring", args);
        return select;
    }

    public Expression<String> substring(Expression<String> expr, int pos0, int pos1) {
        List<Literal> args = List.of(new Literal((Object)pos0), new Literal((Object)pos1));
        ExpressionImpl<String> select = new ExpressionImpl<String>(this, expr.getJavaType());
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "substring", args);
        return select;
    }

    public Expression<String> trim(Expression<String> expr) {
        ExpressionImpl<String> select = new ExpressionImpl<String>(this, expr.getJavaType());
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "trim", null);
        return select;
    }

    public Expression<String> trim(CriteriaBuilder.Trimspec spec, Expression<String> expr) {
        ExpressionImpl<String> select = new ExpressionImpl<String>(this, expr.getJavaType());
        String method = "trim";
        if (spec == CriteriaBuilder.Trimspec.LEADING) {
            method = "trimLeft";
        } else if (spec == CriteriaBuilder.Trimspec.TRAILING) {
            method = "trimRight";
        }
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), method, null);
        return select;
    }

    public Expression<String> trim(Expression<Character> chr, Expression<String> expr) {
        List<org.datanucleus.store.query.expression.Expression> args = List.of(((ExpressionImpl)chr).getQueryExpression());
        ExpressionImpl<String> select = new ExpressionImpl<String>(this, expr.getJavaType());
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "trim", args);
        return select;
    }

    public Expression<String> trim(char chr, Expression<String> expr) {
        List<Literal> args = List.of(new Literal((Object)Character.valueOf(chr)));
        ExpressionImpl<String> select = new ExpressionImpl<String>(this, expr.getJavaType());
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "trim", args);
        return select;
    }

    public Expression<String> trim(CriteriaBuilder.Trimspec spec, Expression<Character> chr, Expression<String> expr) {
        String method = "trim";
        if (spec == CriteriaBuilder.Trimspec.LEADING) {
            method = "trimLeft";
        } else if (spec == CriteriaBuilder.Trimspec.TRAILING) {
            method = "trimRight";
        }
        List<org.datanucleus.store.query.expression.Expression> args = List.of(((ExpressionImpl)chr).getQueryExpression());
        ExpressionImpl<String> select = new ExpressionImpl<String>(this, expr.getJavaType());
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), method, args);
        return select;
    }

    public Expression<String> trim(CriteriaBuilder.Trimspec spec, char chr, Expression<String> expr) {
        String method = "trim";
        if (spec == CriteriaBuilder.Trimspec.LEADING) {
            method = "trimLeft";
        } else if (spec == CriteriaBuilder.Trimspec.TRAILING) {
            method = "trimRight";
        }
        List<Literal> args = List.of(new Literal((Object)Character.valueOf(chr)));
        ExpressionImpl<String> select = new ExpressionImpl<String>(this, expr.getJavaType());
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), method, args);
        return select;
    }

    public Expression<String> lower(Expression<String> expr) {
        ExpressionImpl<String> select = new ExpressionImpl<String>(this, expr.getJavaType());
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "toLowerCase", null);
        return select;
    }

    public Expression<String> upper(Expression<String> expr) {
        ExpressionImpl<String> select = new ExpressionImpl<String>(this, expr.getJavaType());
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "toUpperCase", null);
        return select;
    }

    public Expression<Integer> length(Expression<String> expr) {
        ExpressionImpl<Integer> select = new ExpressionImpl<Integer>(this, Integer.class);
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "length", null);
        return select;
    }

    public <T> Expression<T> literal(T obj) {
        ExpressionImpl expr = new ExpressionImpl(this, obj.getClass());
        expr.queryExpr = new Literal(obj);
        return expr;
    }

    public <T> Expression<T> nullLiteral(Class<T> cls) {
        ExpressionImpl<T> expr = new ExpressionImpl<T>(this, cls);
        expr.queryExpr = new Literal(null);
        return expr;
    }

    public <X, T, V extends T> Join<X, V> treat(Join<X, T> join, Class<V> type) {
        throw new UnsupportedOperationException("CriteriaBuilder.treat(Join, Class) not yet implemented. Provide a testcase that uses this and raise an issue attaching your testcase");
    }

    public <X, T, E extends T> CollectionJoin<X, E> treat(CollectionJoin<X, T> join, Class<E> type) {
        throw new UnsupportedOperationException("CriteriaBuilder.treat(CollectionJoin, Class) not yet implemented. Provide a testcase that uses this and raise an issue attaching your testcase");
    }

    public <X, T, E extends T> SetJoin<X, E> treat(SetJoin<X, T> join, Class<E> type) {
        throw new UnsupportedOperationException("CriteriaBuilder.treat(SetJoin, Class) not yet implemented. Provide a testcase that uses this and raise an issue attaching your testcase");
    }

    public <X, T, E extends T> ListJoin<X, E> treat(ListJoin<X, T> join, Class<E> type) {
        throw new UnsupportedOperationException("CriteriaBuilder.treat(ListJoin, Class) not yet implemented. Provide a testcase that uses this and raise an issue attaching your testcase");
    }

    public <X, K, T, V extends T> MapJoin<X, K, V> treat(MapJoin<X, K, T> join, Class<V> type) {
        throw new UnsupportedOperationException("CriteriaBuilder.treat(MapJoin, Class) not yet implemented. Provide a testcase that uses this and raise an issue attaching your testcase");
    }

    public <X, T extends X> Path<T> treat(Path<X> path, Class<T> type) {
        return new TreatPathImpl(this, (PathImpl)path, type);
    }

    public <X, T extends X> Root<T> treat(Root<X> root, Class<T> type) {
        return new TreatRootImpl(this, (RootImpl)root, type);
    }

    public Expression<Integer> year(Expression<? extends java.util.Date> expr) {
        ExpressionImpl<Integer> select = new ExpressionImpl<Integer>(this, Integer.class);
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "getYear", null);
        return select;
    }

    public Expression<Integer> month(Expression<? extends java.util.Date> expr) {
        ExpressionImpl<Integer> select = new ExpressionImpl<Integer>(this, Integer.class);
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "getMonth", null);
        return select;
    }

    public Expression<Integer> day(Expression<? extends java.util.Date> expr) {
        ExpressionImpl<Integer> select = new ExpressionImpl<Integer>(this, Integer.class);
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "getDay", null);
        return select;
    }

    public Expression<Integer> hour(Expression<? extends java.util.Date> expr) {
        ExpressionImpl<Integer> select = new ExpressionImpl<Integer>(this, Integer.class);
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "getHour", null);
        return select;
    }

    public Expression<Integer> minute(Expression<? extends java.util.Date> expr) {
        ExpressionImpl<Integer> select = new ExpressionImpl<Integer>(this, Integer.class);
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "getMinute", null);
        return select;
    }

    public Expression<Integer> second(Expression<? extends java.util.Date> expr) {
        ExpressionImpl<Integer> select = new ExpressionImpl<Integer>(this, Integer.class);
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "getSecond", null);
        return select;
    }

    public Expression<Number> round(Expression<Number> expr, Integer digits) {
        ExpressionImpl<Number> roundedExpr = new ExpressionImpl<Number>(this, expr.getJavaType());
        List<Literal> args = null;
        if (digits != null) {
            args = List.of(new Literal((Object)digits));
        }
        roundedExpr.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "round", args);
        return roundedExpr;
    }

    public Expression<Number> cos(Expression<Number> expr) {
        ExpressionImpl<Number> cosExpr = new ExpressionImpl<Number>(this, Number.class);
        cosExpr.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "cos", null);
        return cosExpr;
    }

    public Expression<Number> sin(Expression<Number> expr) {
        ExpressionImpl<Number> sinExpr = new ExpressionImpl<Number>(this, Number.class);
        sinExpr.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "sin", null);
        return sinExpr;
    }

    public Expression<Number> tan(Expression<Number> expr) {
        ExpressionImpl<Number> tanExpr = new ExpressionImpl<Number>(this, Number.class);
        tanExpr.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "tan", null);
        return tanExpr;
    }

    public Expression<Number> acos(Expression<Number> expr) {
        ExpressionImpl<Number> acosExpr = new ExpressionImpl<Number>(this, Number.class);
        acosExpr.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "acos", null);
        return acosExpr;
    }

    public Expression<Number> asin(Expression<Number> expr) {
        ExpressionImpl<Number> asinExpr = new ExpressionImpl<Number>(this, Number.class);
        asinExpr.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "asin", null);
        return asinExpr;
    }

    public Expression<Number> atan(Expression<Number> expr) {
        ExpressionImpl<Number> atanExpr = new ExpressionImpl<Number>(this, Number.class);
        atanExpr.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "atan", null);
        return atanExpr;
    }

    public Expression<Number> log(Expression<Number> expr) {
        ExpressionImpl<Number> logExpr = new ExpressionImpl<Number>(this, Number.class);
        logExpr.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "log", null);
        return logExpr;
    }

    public Expression<Number> exp(Expression<Number> expr) {
        ExpressionImpl<Number> expExpr = new ExpressionImpl<Number>(this, Number.class);
        expExpr.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "exp", null);
        return expExpr;
    }

    public Expression<Integer> ceil(Expression<Number> expr) {
        ExpressionImpl<Integer> ceilExpr = new ExpressionImpl<Integer>(this, Integer.class);
        ceilExpr.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "ceil", null);
        return ceilExpr;
    }

    public Expression<Integer> floor(Expression<Number> expr) {
        ExpressionImpl<Integer> floorExpr = new ExpressionImpl<Integer>(this, Integer.class);
        floorExpr.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "floor", null);
        return floorExpr;
    }
}

