/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa.criteria;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.persistence.criteria.CollectionJoin;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.SetJoin;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SetAttribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.datanucleus.api.jpa.criteria.CollectionJoinImpl;
import org.datanucleus.api.jpa.criteria.CriteriaBuilderImpl;
import org.datanucleus.api.jpa.criteria.FetchImpl;
import org.datanucleus.api.jpa.criteria.JoinImpl;
import org.datanucleus.api.jpa.criteria.ListJoinImpl;
import org.datanucleus.api.jpa.criteria.MapJoinImpl;
import org.datanucleus.api.jpa.criteria.PathImpl;
import org.datanucleus.api.jpa.criteria.PredicateImpl;
import org.datanucleus.api.jpa.criteria.SetJoinImpl;
import org.datanucleus.api.jpa.metamodel.AttributeImpl;
import org.datanucleus.api.jpa.metamodel.CollectionAttributeImpl;
import org.datanucleus.api.jpa.metamodel.ListAttributeImpl;
import org.datanucleus.api.jpa.metamodel.MapAttributeImpl;
import org.datanucleus.api.jpa.metamodel.PluralAttributeImpl;
import org.datanucleus.api.jpa.metamodel.SetAttributeImpl;
import org.datanucleus.api.jpa.metamodel.SingularAttributeImpl;
import org.datanucleus.store.query.expression.ClassExpression;
import org.datanucleus.store.query.expression.Expression;
import org.datanucleus.store.query.expression.JoinExpression;
import org.datanucleus.store.query.expression.PrimaryExpression;
import org.datanucleus.util.StringUtils;

public class FromImpl<Z, X>
extends PathImpl<Z, X>
implements From<Z, X> {
    private static final long serialVersionUID = -7138075290737454992L;
    protected Set<Join<X, ?>> joins;
    protected Set<Fetch<X, ?>> fetchJoins;
    protected Type<X> type;

    public FromImpl(CriteriaBuilderImpl cb, ManagedType<X> type) {
        super(cb, type.getJavaType());
        this.type = type;
    }

    public FromImpl(CriteriaBuilderImpl cb, PathImpl<?, Z> parent, AttributeImpl<? super Z, ?> type) {
        super(cb, parent, type, type.getJavaType());
        this.type = type.getType();
    }

    public Type<X> getAttributeType() {
        return this.type;
    }

    public From<Z, X> getCorrelationParent() {
        throw new UnsupportedOperationException("Not yet implemented. Provide a testcase that uses this and raise an issue attaching your testcase");
    }

    public boolean isCorrelated() {
        return this.getCorrelationParent() != null;
    }

    public Set<Join<X, ?>> getJoins() {
        if (this.joins == null) {
            return Collections.EMPTY_SET;
        }
        return this.joins;
    }

    public <Y> CollectionJoin<X, Y> join(CollectionAttribute<? super X, Y> attr, JoinType joinType) {
        CollectionJoinImpl join = new CollectionJoinImpl(this.cb, this, (CollectionAttributeImpl)attr, joinType);
        if (this.joins == null) {
            this.joins = new HashSet();
        }
        this.joins.add(join);
        return join;
    }

    public <Y> CollectionJoin<X, Y> join(CollectionAttribute<? super X, Y> collection) {
        return this.join(collection, JoinType.INNER);
    }

    public <Y> ListJoin<X, Y> join(ListAttribute<? super X, Y> attr, JoinType joinType) {
        ListJoinImpl join = new ListJoinImpl(this.cb, this, (ListAttributeImpl)attr, joinType);
        if (this.joins == null) {
            this.joins = new HashSet();
        }
        this.joins.add(join);
        return join;
    }

    public <Y> ListJoin<X, Y> join(ListAttribute<? super X, Y> list) {
        return this.join(list, JoinType.INNER);
    }

    public <K, V> MapJoin<X, K, V> join(MapAttribute<? super X, K, V> attr, JoinType joinType) {
        MapJoinImpl join = new MapJoinImpl(this.cb, this, (PluralAttributeImpl)((MapAttributeImpl)attr), joinType);
        if (this.joins == null) {
            this.joins = new HashSet();
        }
        this.joins.add(join);
        return join;
    }

    public <K, V> MapJoin<X, K, V> join(MapAttribute<? super X, K, V> map) {
        return this.join(map, JoinType.INNER);
    }

    public <Y> SetJoin<X, Y> join(SetAttribute<? super X, Y> attr, JoinType joinType) {
        SetJoinImpl join = new SetJoinImpl(this.cb, this, (SetAttributeImpl)attr, joinType);
        if (this.joins == null) {
            this.joins = new HashSet();
        }
        this.joins.add(join);
        return join;
    }

    public <Y> SetJoin<X, Y> join(SetAttribute<? super X, Y> set) {
        return this.join(set, JoinType.INNER);
    }

    public <Y> Join<X, Y> join(SingularAttribute<? super X, Y> attr, JoinType joinType) {
        JoinImpl join = new JoinImpl(this.cb, this, (SingularAttributeImpl)attr, joinType);
        if (this.joins == null) {
            this.joins = new HashSet();
        }
        this.joins.add(join);
        return join;
    }

    public <Y> Join<X, Y> join(SingularAttribute<? super X, Y> singular) {
        return this.join(singular, JoinType.INNER);
    }

    public <X, Y> Join<X, Y> join(String attrName, JoinType joinType) {
        if (attrName == null) {
            throw new IllegalArgumentException("Cannot join to null attribute");
        }
        StringTokenizer tokeniser = new StringTokenizer(attrName, ".");
        if (!tokeniser.hasMoreTokens()) {
            throw new IllegalArgumentException("Cannot join to null attribute");
        }
        String token = tokeniser.nextToken();
        ManagedType currentType = (ManagedType)this.type;
        if (!token.equalsIgnoreCase(this.getAlias())) {
            tokeniser = new StringTokenizer(attrName, ".");
        }
        boolean first = true;
        ListJoinImpl currentJoin = null;
        AttributeImpl currentAttr = null;
        while (tokeniser.hasMoreTokens()) {
            token = tokeniser.nextToken();
            currentAttr = (AttributeImpl)currentType.getAttribute(token);
            if (currentAttr == null) {
                throw new IllegalArgumentException("Unable to access attribute " + token + " of " + currentType + " for join");
            }
            JoinImpl thisJoin = null;
            if (currentAttr instanceof ListAttributeImpl) {
                thisJoin = new ListJoinImpl(this.cb, currentJoin != null ? currentJoin : this, (ListAttributeImpl)currentAttr, joinType);
            } else if (currentAttr instanceof SetAttributeImpl) {
                thisJoin = new SetJoinImpl(this.cb, (FromImpl)(currentJoin != null ? currentJoin : this), (SetAttributeImpl)currentAttr, joinType);
            } else if (currentAttr instanceof MapAttributeImpl) {
                thisJoin = new MapJoinImpl(this.cb, (FromImpl)(currentJoin != null ? currentJoin : this), (PluralAttributeImpl)((MapAttributeImpl)currentAttr), joinType);
            } else if (currentAttr instanceof CollectionAttributeImpl) {
                thisJoin = new CollectionJoinImpl(this.cb, (FromImpl)(currentJoin != null ? currentJoin : this), (CollectionAttributeImpl)currentAttr, joinType);
            } else if (currentAttr instanceof SingularAttributeImpl) {
                thisJoin = new JoinImpl(this.cb, currentJoin != null ? currentJoin : this, (SingularAttributeImpl)currentAttr, joinType);
            } else if (currentAttr.getPersistentAttributeType() == Attribute.PersistentAttributeType.BASIC) {
                throw new IllegalArgumentException("Cannot resolve attribute " + attrName + " since " + token + " is not a relation field and the attribute name goes beyond it!");
            }
            if (first) {
                if (this.joins == null) {
                    this.joins = new HashSet();
                }
                this.joins.add(thisJoin);
            } else {
                if (currentJoin.joins == null) {
                    currentJoin.joins = new HashSet();
                }
                currentJoin.joins.add(thisJoin);
            }
            currentJoin = thisJoin;
            if (tokeniser.hasMoreTokens()) {
                currentType = (ManagedType)currentAttr.getType();
            }
            first = false;
        }
        return currentJoin;
    }

    public <X, Y> Join<X, Y> join(String attr) {
        return this.join(attr, JoinType.INNER);
    }

    public <X, Y> CollectionJoin<X, Y> joinCollection(String attrName, JoinType joinType) {
        return (CollectionJoin)this.join(attrName, joinType);
    }

    public <X, Y> CollectionJoin<X, Y> joinCollection(String attrName) {
        return this.joinCollection(attrName, JoinType.INNER);
    }

    public <X, Y> ListJoin<X, Y> joinList(String attrName, JoinType joinType) {
        return (ListJoin)this.join(attrName, joinType);
    }

    public <X, Y> ListJoin<X, Y> joinList(String attrName) {
        return this.joinList(attrName, JoinType.INNER);
    }

    public <X, K, V> MapJoin<X, K, V> joinMap(String attrName, JoinType joinType) {
        return (MapJoin)this.join(attrName, joinType);
    }

    public <X, K, V> MapJoin<X, K, V> joinMap(String attrName) {
        return this.joinMap(attrName, JoinType.INNER);
    }

    public <X, Y> SetJoin<X, Y> joinSet(String attrName, JoinType joinType) {
        return (SetJoin)this.join(attrName, joinType);
    }

    public <X, Y> SetJoin<X, Y> joinSet(String attr) {
        return this.joinSet(attr, JoinType.INNER);
    }

    public Set<Fetch<X, ?>> getFetches() {
        if (this.fetchJoins == null) {
            return Collections.EMPTY_SET;
        }
        return this.fetchJoins;
    }

    public <Y> Fetch<X, Y> fetch(PluralAttribute<? super X, ?, Y> attr, JoinType joinType) {
        FetchImpl fetch = new FetchImpl(this.cb, this, (AttributeImpl)attr, joinType);
        if (this.fetchJoins == null) {
            this.fetchJoins = new HashSet();
        }
        this.fetchJoins.add(fetch);
        return fetch;
    }

    public <Y> Fetch<X, Y> fetch(PluralAttribute<? super X, ?, Y> attr) {
        return this.fetch(attr, JoinType.INNER);
    }

    public <Y> Fetch<X, Y> fetch(SingularAttribute<? super X, Y> attr, JoinType joinType) {
        FetchImpl fetch = new FetchImpl(this.cb, this, (SingularAttributeImpl)attr, joinType);
        if (this.fetchJoins == null) {
            this.fetchJoins = new HashSet();
        }
        this.fetchJoins.add(fetch);
        return fetch;
    }

    public <Y> Fetch<X, Y> fetch(SingularAttribute<? super X, Y> attr) {
        return this.fetch(attr, JoinType.INNER);
    }

    public <X, Y> Fetch<X, Y> fetch(String attrName, JoinType joinType) {
        if (attrName == null) {
            throw new IllegalArgumentException("Cannot (fetch) join to null attribute");
        }
        StringTokenizer tokeniser = new StringTokenizer(attrName, ".");
        if (!tokeniser.hasMoreTokens()) {
            throw new IllegalArgumentException("Cannot (fetch) join to null attribute");
        }
        String token = tokeniser.nextToken();
        ManagedType currentType = (ManagedType)this.type;
        if (!token.equalsIgnoreCase(this.getAlias())) {
            tokeniser = new StringTokenizer(attrName, ".");
        }
        boolean first = true;
        PathImpl currentJoin = null;
        AttributeImpl currentAttr = null;
        while (tokeniser.hasMoreTokens()) {
            token = tokeniser.nextToken();
            currentAttr = (AttributeImpl)currentType.getAttribute(token);
            if (currentAttr == null) {
                throw new IllegalArgumentException("Unable to access attribute " + token + " of " + currentType + " for join");
            }
            FetchImpl thisJoin = new FetchImpl(this.cb, currentJoin != null ? currentJoin : this, currentAttr, joinType);
            if (first) {
                if (this.fetchJoins == null) {
                    this.fetchJoins = new HashSet();
                }
                this.fetchJoins.add(thisJoin);
            } else {
                if (((FetchImpl)currentJoin).fetches == null) {
                    ((FetchImpl)currentJoin).fetches = new HashSet();
                }
                ((FetchImpl)currentJoin).fetches.add(thisJoin);
            }
            currentJoin = thisJoin;
            if (tokeniser.hasMoreTokens()) {
                currentType = (ManagedType)currentAttr.getType();
            }
            first = false;
        }
        return currentJoin;
    }

    public <X, Y> Fetch<X, Y> fetch(String attrName) {
        return this.fetch(attrName, JoinType.INNER);
    }

    public Expression getQueryExpression(boolean from) {
        if (from) {
            ClassExpression expr = new ClassExpression(this.getAlias());
            if (this.joins != null && !this.joins.isEmpty()) {
                Iterator<Join<X, ?>> iter = this.joins.iterator();
                ClassExpression currentExpr = expr;
                while (iter.hasNext()) {
                    Join<X, ?> join = iter.next();
                    currentExpr = FromImpl.processQueryExpressionForFromJoin(join, (Expression)currentExpr, this.getAlias());
                }
            }
            if (this.fetchJoins != null && !this.fetchJoins.isEmpty()) {
                ArrayList<String> tuples = new ArrayList<String>();
                tuples.add(this.getAlias());
                Iterator<Fetch<X, ?>> iter = this.fetchJoins.iterator();
                ClassExpression currentExpr = expr;
                while (iter.hasNext()) {
                    Fetch<X, ?> join = iter.next();
                    currentExpr = FromImpl.processQueryExpressionForFromFetchJoin(join, (Expression)currentExpr, this.getAlias());
                }
            }
            return expr;
        }
        ArrayList<String> tuples = new ArrayList<String>();
        String alias = this.getAlias();
        if (alias != null) {
            tuples.add(this.getAlias());
        } else if (this.parent != null) {
            String fieldName = this.attribute.getMetadata().getName();
            tuples.add(this.parent.getAlias());
            tuples.add(fieldName);
            return new PrimaryExpression(tuples);
        }
        return new PrimaryExpression(tuples);
    }

    private static Expression processQueryExpressionForFromJoin(Join join, Expression currentExpr, String alias) {
        JoinExpression.JoinType jt = JoinExpression.JoinType.JOIN_INNER;
        if (join.getJoinType() == JoinType.LEFT) {
            jt = JoinExpression.JoinType.JOIN_LEFT_OUTER;
        } else if (join.getJoinType() == JoinType.RIGHT) {
            jt = JoinExpression.JoinType.JOIN_RIGHT_OUTER;
        }
        Attribute attr = join.getAttribute();
        ArrayList<String> tuples = new ArrayList<String>();
        tuples.add(alias);
        tuples.add(attr.getName());
        JoinExpression joinExpr = new JoinExpression((Expression)new PrimaryExpression(new ArrayList(tuples)), join.getAlias(), jt);
        if (currentExpr instanceof ClassExpression) {
            ((ClassExpression)currentExpr).setJoinExpression(joinExpr);
        } else {
            ((JoinExpression)currentExpr).setJoinExpression(joinExpr);
        }
        if (join.getOn() != null) {
            PredicateImpl onExpr = (PredicateImpl)join.getOn();
            joinExpr.setOnExpression(onExpr.getQueryExpression());
        }
        currentExpr = joinExpr;
        FromImpl frm = (FromImpl)join;
        Set subjoins = frm.getJoins();
        if (subjoins != null) {
            for (Join subjoin : subjoins) {
                currentExpr = FromImpl.processQueryExpressionForFromJoin(subjoin, currentExpr, join.getAlias());
            }
        }
        return currentExpr;
    }

    private static Expression processQueryExpressionForFromFetchJoin(Fetch fetch, Expression currentExpr, String alias) {
        JoinExpression.JoinType jt = JoinExpression.JoinType.JOIN_INNER;
        if (fetch.getJoinType() == JoinType.LEFT) {
            jt = JoinExpression.JoinType.JOIN_LEFT_OUTER;
        } else if (fetch.getJoinType() == JoinType.RIGHT) {
            jt = JoinExpression.JoinType.JOIN_RIGHT_OUTER;
        }
        Attribute attr = fetch.getAttribute();
        ArrayList<String> tuples = new ArrayList<String>();
        tuples.add(alias);
        tuples.add(attr.getName());
        PrimaryExpression primExpr = new PrimaryExpression(new ArrayList(tuples));
        JoinExpression joinExpr = new JoinExpression((Expression)primExpr, null, jt);
        if (currentExpr instanceof ClassExpression) {
            ((ClassExpression)currentExpr).setJoinExpression(joinExpr);
        } else {
            ((JoinExpression)currentExpr).setJoinExpression(joinExpr);
        }
        currentExpr = joinExpr;
        return currentExpr;
    }

    @Override
    public Expression getQueryExpression() {
        return this.getQueryExpression(false);
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean from) {
        if (from) {
            StringBuilder str = new StringBuilder();
            if (this.parent == null) {
                str.append(this.getJavaType().getName());
                if (!StringUtils.isWhitespace((String)this.getAlias())) {
                    str.append(" ").append(this.getAlias());
                }
            }
            if (this.joins != null) {
                for (Join<X, ?> join : this.joins) {
                    Predicate onPred;
                    JoinType type = join.getJoinType();
                    if (type == JoinType.INNER) {
                        str.append(" JOIN ");
                    } else if (type == JoinType.LEFT) {
                        str.append(" LEFT JOIN ");
                    } else if (type == JoinType.RIGHT) {
                        str.append(" RIGHT JOIN ");
                    }
                    Attribute attr = join.getAttribute();
                    str.append(this.getAlias()).append('.').append(attr.getName());
                    if (!StringUtils.isWhitespace((String)join.getAlias())) {
                        str.append(" ").append(join.getAlias());
                    }
                    if ((onPred = join.getOn()) != null) {
                        str.append(" ");
                        str.append("ON ");
                        str.append(onPred.toString());
                    }
                    str.append(((FromImpl)join).toString(true));
                }
            }
            if (this.fetchJoins != null) {
                Iterator<Join<X, ?>> iter = this.fetchJoins.iterator();
                StringBuilder joinAttrName = new StringBuilder(this.getAlias());
                while (iter.hasNext()) {
                    Fetch join = (Fetch)iter.next();
                    JoinType type = join.getJoinType();
                    if (type == JoinType.INNER) {
                        str.append(" JOIN FETCH ");
                    } else if (type == JoinType.LEFT) {
                        str.append(" LEFT JOIN FETCH ");
                    } else if (type == JoinType.RIGHT) {
                        str.append(" RIGHT JOIN FETCH ");
                    }
                    Attribute attr = join.getAttribute();
                    joinAttrName.append('.').append(attr.getName());
                    str.append(joinAttrName.toString()).append(" ");
                    str.append(((FromImpl)join).toString(true));
                }
            }
            return str.toString();
        }
        if (this.getAlias() != null) {
            return this.getAlias();
        }
        return "(unaliased type=" + this.getJavaType().getName() + ")";
    }
}

