/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa.criteria;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.api.jpa.criteria.CriteriaBuilderImpl;
import org.datanucleus.api.jpa.criteria.ExpressionImpl;
import org.datanucleus.api.jpa.criteria.FromImpl;
import org.datanucleus.api.jpa.criteria.JoinImpl;
import org.datanucleus.api.jpa.criteria.OrderImpl;
import org.datanucleus.api.jpa.criteria.ParameterExpressionImpl;
import org.datanucleus.api.jpa.criteria.PredicateImpl;
import org.datanucleus.api.jpa.criteria.RootImpl;
import org.datanucleus.api.jpa.criteria.SubqueryImpl;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.store.query.compiler.JPQLSymbolResolver;
import org.datanucleus.store.query.compiler.PropertySymbol;
import org.datanucleus.store.query.compiler.QueryCompilation;
import org.datanucleus.store.query.compiler.Symbol;
import org.datanucleus.store.query.compiler.SymbolResolver;
import org.datanucleus.store.query.compiler.SymbolTable;
import org.datanucleus.store.query.expression.ClassExpression;
import org.datanucleus.store.query.expression.CreatorExpression;
import org.datanucleus.store.query.expression.DyadicExpression;
import org.datanucleus.store.query.expression.InvokeExpression;
import org.datanucleus.store.query.expression.Literal;
import org.datanucleus.store.query.expression.OrderExpression;
import org.datanucleus.store.query.expression.ParameterExpression;
import org.datanucleus.store.query.expression.PrimaryExpression;
import org.datanucleus.store.query.expression.SubqueryExpression;
import org.datanucleus.store.query.expression.VariableExpression;

public class CriteriaQueryImpl<T>
implements CriteriaQuery<T>,
Serializable {
    static final long serialVersionUID = -7894275881256415495L;
    private CriteriaBuilderImpl cb;
    private boolean distinct;
    private Class<T> resultClass;
    private List<Selection<?>> result;
    private List<RootImpl<?>> from;
    private PredicateImpl filter;
    private List<Expression<?>> grouping;
    private PredicateImpl having;
    private List<Order> ordering;
    private List<SubqueryImpl<?>> subqueries;
    String jpqlString = null;
    QueryCompilation compilation = null;
    Set<javax.persistence.criteria.ParameterExpression<?>> params = null;
    protected int internalJoinAliasNumber = 0;

    public CriteriaQueryImpl(CriteriaBuilderImpl cb, Class<T> resultClass) {
        this.cb = cb;
        this.resultClass = resultClass;
    }

    public Metamodel getMetamodel() {
        return this.cb.getEntityManagerFactory().getMetamodel();
    }

    public CriteriaQuery<T> distinct(boolean flag) {
        this.discardCompiled();
        this.distinct = flag;
        return this;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public CriteriaQuery<T> select(Selection<? extends T> select) {
        this.discardCompiled();
        this.result = new ArrayList();
        this.result.add(select);
        return this;
    }

    public CriteriaQuery<T> multiselect(List<Selection<?>> selects) {
        this.discardCompiled();
        if (selects == null || selects.isEmpty()) {
            this.result = null;
            return this;
        }
        this.result = new ArrayList(selects);
        return this;
    }

    public CriteriaQuery<T> multiselect(Selection<?> ... selects) {
        this.discardCompiled();
        if (selects == null || selects.length == 0) {
            this.result = null;
            return this;
        }
        this.result = new ArrayList();
        for (int i = 0; i < selects.length; ++i) {
            this.result.add(selects[i]);
        }
        return this;
    }

    public Selection<T> getSelection() {
        return this.result != null ? this.result.get(0) : null;
    }

    public Class<T> getResultType() {
        return this.resultClass;
    }

    public <X> Root<X> from(Class<X> cls) {
        this.discardCompiled();
        EntityType entity = this.cb.getEntityManagerFactory().getMetamodel().entity(cls);
        if (entity == null) {
            throw new IllegalArgumentException("The specified class (" + cls.getName() + ") is not an entity");
        }
        return this.from(entity);
    }

    public <X> Root<X> from(EntityType<X> type) {
        this.discardCompiled();
        if (this.from == null) {
            this.from = new ArrayList();
        }
        RootImpl<X> root = new RootImpl<X>(this.cb, type);
        this.from.add(root);
        return root;
    }

    public Set<Root<?>> getRoots() {
        if (this.from == null) {
            return null;
        }
        return new HashSet(this.from);
    }

    public CriteriaQuery<T> where(Expression<Boolean> expr) {
        this.discardCompiled();
        if (expr == null) {
            this.filter = null;
            return this;
        }
        this.filter = (PredicateImpl)expr;
        return this;
    }

    public CriteriaQuery<T> where(Predicate ... exprs) {
        this.discardCompiled();
        if (exprs == null || exprs.length == 0) {
            this.filter = null;
            return this;
        }
        if (this.filter == null) {
            this.filter = new PredicateImpl(this.cb);
        }
        for (int i = 0; i < exprs.length; ++i) {
            this.filter = this.filter.append(exprs[i]);
        }
        return this;
    }

    public CriteriaQuery<T> where(List<Predicate> preds) {
        this.discardCompiled();
        if (preds == null || preds.isEmpty()) {
            this.filter = null;
            return this;
        }
        if (this.filter == null) {
            this.filter = new PredicateImpl(this.cb);
        }
        for (Predicate pred : preds) {
            this.filter = this.filter.append(pred);
        }
        return this;
    }

    public Predicate getRestriction() {
        return this.filter;
    }

    public CriteriaQuery<T> groupBy(Expression<?> ... exprs) {
        this.discardCompiled();
        if (exprs == null || exprs.length == 0) {
            this.grouping = null;
            return this;
        }
        this.grouping = new ArrayList();
        for (int i = 0; i < exprs.length; ++i) {
            this.grouping.add(exprs[i]);
        }
        return this;
    }

    public CriteriaQuery<T> groupBy(List<Expression<?>> exprs) {
        this.discardCompiled();
        if (exprs == null || exprs.isEmpty()) {
            this.grouping = null;
            return this;
        }
        this.grouping = new ArrayList();
        this.grouping.addAll(exprs);
        return this;
    }

    public List<Expression<?>> getGroupList() {
        if (this.grouping == null) {
            return null;
        }
        return new ArrayList(this.grouping);
    }

    public Predicate getGroupRestriction() {
        return this.having;
    }

    public CriteriaQuery<T> having(Expression<Boolean> expr) {
        this.discardCompiled();
        this.having = (PredicateImpl)expr;
        return this;
    }

    public CriteriaQuery<T> having(Predicate ... exprs) {
        this.discardCompiled();
        if (exprs == null) {
            this.having = null;
            return this;
        }
        if (this.having == null) {
            this.having = new PredicateImpl(this.cb);
        }
        for (int i = 0; i < exprs.length; ++i) {
            this.having = (PredicateImpl)exprs[i];
        }
        return this;
    }

    public List<Order> getOrderList() {
        if (this.ordering == null) {
            return null;
        }
        return new ArrayList<Order>(this.ordering);
    }

    public CriteriaQuery<T> orderBy(List<Order> orders) {
        this.discardCompiled();
        if (orders == null || orders.isEmpty()) {
            this.ordering = null;
            return this;
        }
        this.ordering = new ArrayList<Order>();
        this.ordering.addAll(orders);
        return this;
    }

    public CriteriaQuery<T> orderBy(Order ... orders) {
        this.discardCompiled();
        if (orders == null || orders.length == 0) {
            this.ordering = null;
            return this;
        }
        this.ordering = new ArrayList<Order>();
        for (int i = 0; i < orders.length; ++i) {
            this.ordering.add(orders[i]);
        }
        return this;
    }

    public <U> Subquery<U> subquery(Class<U> type) {
        this.discardCompiled();
        if (this.subqueries == null) {
            this.subqueries = new ArrayList();
        }
        SubqueryImpl<U> subquery = new SubqueryImpl<U>(this.cb, type, this);
        this.subqueries.add(subquery);
        return subquery;
    }

    protected void discardCompiled() {
        this.jpqlString = null;
        this.compilation = null;
        this.params = null;
    }

    public Set<javax.persistence.criteria.ParameterExpression<?>> getParameters() {
        org.datanucleus.store.query.expression.Expression expr;
        Iterator<Object> iter;
        if (this.params != null) {
            return this.params;
        }
        ArrayList paramExprs = new ArrayList();
        if (this.result != null) {
            iter = this.result.iterator();
            while (iter.hasNext()) {
                expr = ((ExpressionImpl)iter.next()).getQueryExpression();
                this.getParametersForQueryExpression(expr, paramExprs);
            }
        }
        if (this.filter != null) {
            this.getParametersForQueryExpression(this.filter.getQueryExpression(), paramExprs);
        }
        if (this.grouping != null) {
            iter = this.grouping.iterator();
            while (iter.hasNext()) {
                expr = ((ExpressionImpl)iter.next()).getQueryExpression();
                this.getParametersForQueryExpression(expr, paramExprs);
            }
        }
        if (this.having != null) {
            this.getParametersForQueryExpression(this.having.getQueryExpression(), paramExprs);
        }
        if (paramExprs.isEmpty()) {
            this.params = Collections.EMPTY_SET;
        } else {
            this.params = new HashSet();
            for (ParameterExpression paramExpr : paramExprs) {
                ParameterExpressionImpl param = new ParameterExpressionImpl(this.cb, paramExpr.getType(), paramExpr.getId());
                this.params.add(param);
            }
        }
        return this.params;
    }

    public QueryCompilation getCompilation(MetaDataManager mmgr, ClassLoaderResolver clr) {
        this.fixQuery();
        return this.getCompilation(mmgr, clr, null);
    }

    public QueryCompilation getCompilation(MetaDataManager mmgr, ClassLoaderResolver clr, SymbolTable parentSymtbl) {
        if (this.compilation == null) {
            String resultExprId;
            Class candidateClass = this.from.get(0).getJavaType();
            String candidateAlias = this.from.get(0).getAlias();
            if (candidateAlias == null) {
                candidateAlias = "DN_THIS";
                this.from.get(0).alias(candidateAlias);
            }
            SymbolTable symtbl = new SymbolTable();
            symtbl.setSymbolResolver((SymbolResolver)new JPQLSymbolResolver(mmgr, clr, symtbl, candidateClass, candidateAlias));
            symtbl.addSymbol((Symbol)new PropertySymbol(candidateAlias, candidateClass));
            if (parentSymtbl != null) {
                symtbl.setParentSymbolTable(parentSymtbl);
            }
            org.datanucleus.store.query.expression.Expression[] resultExprs = null;
            if (this.result != null && !this.result.isEmpty()) {
                resultExprs = new org.datanucleus.store.query.expression.Expression[this.result.size()];
                Iterator<Selection<?>> iter = this.result.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    ExpressionImpl result = (ExpressionImpl)iter.next();
                    org.datanucleus.store.query.expression.Expression resultExpr = result.getQueryExpression();
                    resultExpr.bind(symtbl);
                    resultExprs[i++] = resultExpr;
                }
            } else {
                resultExprs = new org.datanucleus.store.query.expression.Expression[1];
                RootImpl<?> root = this.from.get(0);
                resultExprs[0] = root.getQueryExpression();
                resultExprs[0].bind(symtbl);
            }
            if (resultExprs.length == 1 && resultExprs[0] instanceof PrimaryExpression && (resultExprId = ((PrimaryExpression)resultExprs[0]).getId()).equalsIgnoreCase(candidateAlias)) {
                resultExprs = null;
            }
            org.datanucleus.store.query.expression.Expression[] fromExprs = new org.datanucleus.store.query.expression.Expression[this.from.size()];
            Iterator<RootImpl<?>> iter = this.from.iterator();
            int i = 0;
            while (iter.hasNext()) {
                FromImpl frm = iter.next();
                this.processFromJoinsForFrom(frm, symtbl);
                ClassExpression clsExpr = (ClassExpression)frm.getQueryExpression(true);
                clsExpr.bind(symtbl);
                fromExprs[i++] = clsExpr;
            }
            org.datanucleus.store.query.expression.Expression filterExpr = null;
            if (this.filter != null && (filterExpr = this.filter.getQueryExpression()) != null) {
                filterExpr.bind(symtbl);
            }
            org.datanucleus.store.query.expression.Expression[] groupingExprs = null;
            if (this.grouping != null && !this.grouping.isEmpty()) {
                groupingExprs = new org.datanucleus.store.query.expression.Expression[this.grouping.size()];
                Iterator<Expression<?>> grpIter = this.grouping.iterator();
                i = 0;
                while (grpIter.hasNext()) {
                    ExpressionImpl grp = (ExpressionImpl)grpIter.next();
                    org.datanucleus.store.query.expression.Expression groupingExpr = grp.getQueryExpression();
                    groupingExpr.bind(symtbl);
                    groupingExprs[i++] = groupingExpr;
                }
            }
            org.datanucleus.store.query.expression.Expression havingExpr = null;
            if (this.having != null) {
                havingExpr = this.having.getQueryExpression();
                havingExpr.bind(symtbl);
            }
            org.datanucleus.store.query.expression.Expression[] orderExprs = null;
            if (this.ordering != null && !this.ordering.isEmpty()) {
                orderExprs = new org.datanucleus.store.query.expression.Expression[this.ordering.size()];
                Iterator<Order> orderIter = this.ordering.iterator();
                i = 0;
                while (orderIter.hasNext()) {
                    OrderImpl order = (OrderImpl)orderIter.next();
                    OrderExpression orderExpr = order.getQueryExpression();
                    orderExpr.bind(symtbl);
                    orderExprs[i++] = orderExpr;
                }
            }
            this.compilation = new QueryCompilation(candidateClass, candidateAlias, symtbl, resultExprs, fromExprs, filterExpr, groupingExprs, havingExpr, orderExprs, null);
            if (this.distinct) {
                this.compilation.setResultDistinct();
            }
            this.compilation.setQueryLanguage("JPQL");
        }
        if (this.subqueries != null && !this.subqueries.isEmpty()) {
            for (SubqueryImpl<?> sub : this.subqueries) {
                org.datanucleus.store.query.expression.Expression subExpr = sub.getQueryExpression();
                if (subExpr instanceof SubqueryExpression) {
                    SubqueryExpression subqueryExpr = (SubqueryExpression)sub.getQueryExpression();
                    VariableExpression subqueryVar = (VariableExpression)subqueryExpr.getRight();
                    CriteriaQueryImpl subDelegate = (CriteriaQueryImpl)sub.getDelegate();
                    QueryCompilation subCompilation = subDelegate.getCompilation(mmgr, clr, this.compilation.getSymbolTable());
                    subCompilation.setQueryLanguage("JPQL");
                    this.compilation.addSubqueryCompilation(subqueryVar.getId(), subCompilation);
                    continue;
                }
                if (!(subExpr instanceof VariableExpression)) continue;
                VariableExpression subVarExpr = (VariableExpression)subExpr;
                CriteriaQueryImpl subDelegate = (CriteriaQueryImpl)sub.getDelegate();
                QueryCompilation subCompilation = subDelegate.getCompilation(mmgr, clr, this.compilation.getSymbolTable());
                subCompilation.setQueryLanguage("JPQL");
                this.compilation.addSubqueryCompilation(subVarExpr.getId(), subCompilation);
            }
        }
        return this.compilation;
    }

    private void processFromJoinsForFrom(FromImpl frm, SymbolTable symtbl) {
        Set frmJoins = frm.getJoins();
        if (frmJoins != null && !frmJoins.isEmpty()) {
            for (JoinImpl joinImpl : frmJoins) {
                if (joinImpl.getAlias() != null) {
                    Class frmJoinCls = joinImpl.getType().getJavaType();
                    symtbl.addSymbol((Symbol)new PropertySymbol(joinImpl.getAlias(), frmJoinCls));
                }
                this.processFromJoinsForFrom(joinImpl, symtbl);
            }
        }
    }

    private void fixQuery() {
        Iterator<RootImpl<?>> iter = this.from.iterator();
        this.internalJoinAliasNumber = 0;
        while (iter.hasNext()) {
            FromImpl frm = iter.next();
            this.fixJoinsForFrom(frm);
        }
    }

    private void fixJoinsForFrom(FromImpl frm) {
        Set frmJoins = frm.getJoins();
        if (frmJoins != null && !frmJoins.isEmpty()) {
            for (JoinImpl joinImpl : frmJoins) {
                if (joinImpl.getAlias() == null) {
                    joinImpl.alias("DN_JOIN_" + this.internalJoinAliasNumber);
                    ++this.internalJoinAliasNumber;
                }
                this.fixJoinsForFrom(joinImpl);
            }
        }
    }

    public String toString() {
        if (this.jpqlString == null) {
            Iterator<Expression<?>> iter;
            this.fixQuery();
            StringBuilder str = new StringBuilder();
            str.append("SELECT ");
            if (this.distinct) {
                str.append("DISTINCT ");
            }
            if (this.result != null) {
                Iterator<Selection<?>> iter2 = this.result.iterator();
                while (iter2.hasNext()) {
                    Selection<?> select = iter2.next();
                    str.append(select.toString());
                    if (!iter2.hasNext()) continue;
                    str.append(",");
                }
            } else {
                str.append(this.from.get(0).toString());
            }
            str.append(" ");
            str.append("FROM ");
            Iterator<RootImpl<?>> fromIter = this.from.iterator();
            while (fromIter.hasNext()) {
                RootImpl<?> root = fromIter.next();
                str.append(root.toString(true));
                if (!fromIter.hasNext()) continue;
                str.append(",");
            }
            str.append(" ");
            if (this.filter != null) {
                str.append("WHERE ").append(this.filter.toString()).append(" ");
            }
            if (this.grouping != null && !this.grouping.isEmpty()) {
                str.append("GROUP BY ");
                iter = this.grouping.iterator();
                while (iter.hasNext()) {
                    Expression<?> groupExpr = iter.next();
                    str.append(groupExpr.toString());
                    if (!iter.hasNext()) continue;
                    str.append(",");
                }
                str.append(" ");
            }
            if (this.having != null) {
                str.append("HAVING ");
                str.append(this.having.toString()).append(" ");
            }
            if (this.ordering != null && !this.ordering.isEmpty()) {
                str.append("ORDER BY ");
                iter = this.ordering.iterator();
                while (iter.hasNext()) {
                    Order order = (Order)iter.next();
                    str.append(order.toString());
                    if (!iter.hasNext()) continue;
                    str.append(",");
                }
                str.append(" ");
            }
            this.jpqlString = str.toString().trim();
        }
        return this.jpqlString;
    }

    protected void getParametersForQueryExpression(org.datanucleus.store.query.expression.Expression expr, List params) {
        if (expr == null) {
            return;
        }
        if (expr instanceof DyadicExpression) {
            this.getParametersForQueryExpression(expr.getLeft(), params);
            this.getParametersForQueryExpression(expr.getRight(), params);
        } else if (expr instanceof InvokeExpression) {
            InvokeExpression invokeExpr = (InvokeExpression)expr;
            this.getParametersForQueryExpression(invokeExpr.getLeft(), params);
            List args = invokeExpr.getArguments();
            if (args != null && !args.isEmpty()) {
                Iterator iter = args.iterator();
                while (iter.hasNext()) {
                    this.getParametersForQueryExpression((org.datanucleus.store.query.expression.Expression)iter.next(), params);
                }
            }
        } else if (expr instanceof PrimaryExpression) {
            if (expr.getLeft() != null) {
                this.getParametersForQueryExpression(expr.getLeft(), params);
            }
        } else if (expr instanceof ParameterExpression) {
            params.add(expr);
        } else if (expr instanceof CreatorExpression) {
            CreatorExpression createExpr = (CreatorExpression)expr;
            List args = createExpr.getArguments();
            if (args != null && !args.isEmpty()) {
                Iterator iter = args.iterator();
                while (iter.hasNext()) {
                    this.getParametersForQueryExpression((org.datanucleus.store.query.expression.Expression)iter.next(), params);
                }
            }
        } else if (expr instanceof VariableExpression || expr instanceof Literal) {
            // empty if block
        }
    }
}

