/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa.criteria;

import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import org.datanucleus.api.jpa.criteria.ExpressionImpl;
import org.datanucleus.query.expression.OrderExpression;

public class OrderImpl
implements Order {
    Expression<?> expr;
    boolean ascending = true;
    NullPrecedence nullPrecedence = null;

    public OrderImpl(Expression<?> expr, boolean asc) {
        this.expr = expr;
        this.ascending = asc;
    }

    public Expression<?> getExpression() {
        return this.expr;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public Order reverse() {
        this.ascending = !this.ascending;
        return this;
    }

    public Order nullsFirst() {
        this.nullPrecedence = NullPrecedence.NULLS_FIRST;
        return this;
    }

    public Order nullsLast() {
        this.nullPrecedence = NullPrecedence.NULLS_LAST;
        return this;
    }

    public OrderExpression getQueryExpression() {
        OrderExpression orderExpr = null;
        orderExpr = this.nullPrecedence == null ? new OrderExpression(((ExpressionImpl)this.expr).getQueryExpression(), this.ascending ? "ascending" : "descending") : new OrderExpression(((ExpressionImpl)this.expr).getQueryExpression(), this.ascending ? "ascending" : "descending", this.nullPrecedence == NullPrecedence.NULLS_FIRST ? "nulls first" : "nulls last");
        return orderExpr;
    }

    public String toString() {
        return this.expr.toString() + " " + (this.ascending ? "ASC" : "DESC") + (this.nullPrecedence != null ? (this.nullPrecedence == NullPrecedence.NULLS_FIRST ? " NULLS FIRST" : " NULLS LAST") : "");
    }

    private static enum NullPrecedence {
        NULLS_FIRST,
        NULLS_LAST;

    }
}

