/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa;

import java.util.Hashtable;
import javax.persistence.spi.PersistenceProvider;
import javax.transaction.TransactionManager;
import org.datanucleus.api.jpa.PersistenceProviderImpl;
import org.datanucleus.exceptions.NucleusException;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class OSGiActivator
implements BundleActivator {
    public static final String PERSISTENCE_PROVIDER_ARIES = "javax.persistence.provider";
    public static final String PERSISTENCE_PROVIDER = PersistenceProvider.class.getName();
    public static final String OSGI_PERSISTENCE_PROVIDER = PersistenceProviderImpl.class.getName();
    private static ServiceRegistration jpaService = null;
    private static TransactionManager jtaTxnManager;
    private static ServiceReference jtaServiceRef;
    private static ServiceListener jtaListener;

    public void start(BundleContext ctx) throws Exception {
        PersistenceProviderImpl provider = new PersistenceProviderImpl();
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put(PERSISTENCE_PROVIDER_ARIES, OSGI_PERSISTENCE_PROVIDER);
        props.put(PERSISTENCE_PROVIDER, OSGI_PERSISTENCE_PROVIDER);
        jpaService = ctx.registerService(PERSISTENCE_PROVIDER, (Object)provider, props);
        if (jtaListener != null) {
            throw new NucleusException("Another OSGi service listener has already been registered.");
        }
        jtaListener = new Listener(ctx);
        ctx.addServiceListener(jtaListener, "(objectClass=javax.transaction.TransactionManager)");
        jtaServiceRef = ctx.getServiceReference("javax.transaction.TransactionManager");
        if (jtaServiceRef != null) {
            jtaTxnManager = (TransactionManager)ctx.getService(jtaServiceRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext ctx) throws Exception {
        try {
            if (jtaServiceRef != null) {
                ctx.ungetService(jtaServiceRef);
                jtaTxnManager = null;
                jtaServiceRef = null;
            }
        }
        finally {
            if (jtaListener != null) {
                ctx.removeServiceListener(jtaListener);
                jtaListener = null;
            }
        }
        if (jpaService != null) {
            jpaService.unregister();
            jpaService = null;
        }
    }

    private static final class Listener
    implements ServiceListener {
        final BundleContext bundleContext;
        final Class<OSGiActivator> clazzRef;

        public Listener(BundleContext bundleContext) {
            this.bundleContext = bundleContext;
            this.clazzRef = OSGiActivator.class;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceChanged(ServiceEvent event) {
            Class<OSGiActivator> clazz = this.clazzRef;
            synchronized (clazz) {
                switch (event.getType()) {
                    case 1: {
                        jtaServiceRef = event.getServiceReference();
                        jtaTxnManager = (TransactionManager)this.bundleContext.getService(jtaServiceRef);
                        break;
                    }
                    case 4: {
                        jtaTxnManager = null;
                        jtaServiceRef = null;
                        this.bundleContext.ungetService(event.getServiceReference());
                    }
                }
            }
        }
    }
}

