/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa.criteria;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.datanucleus.api.jpa.criteria.CriteriaBuilderImpl;
import org.datanucleus.api.jpa.criteria.ExpressionImpl;
import org.datanucleus.api.jpa.criteria.JPQLHelper;
import org.datanucleus.query.expression.DyadicExpression;
import org.datanucleus.query.expression.Expression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredicateImpl
extends ExpressionImpl<Boolean>
implements Predicate {
    protected List<Predicate> exprs = null;
    boolean negated = false;
    Predicate.BooleanOperator operator = null;

    public PredicateImpl(CriteriaBuilderImpl cb) {
        super(cb, Boolean.class);
        this.operator = Predicate.BooleanOperator.AND;
    }

    public PredicateImpl(CriteriaBuilderImpl cb, Predicate.BooleanOperator op) {
        super(cb, Boolean.class);
        this.operator = op;
    }

    public Predicate not() {
        this.negated = !this.negated;
        return this;
    }

    public List<Expression<Boolean>> getExpressions() {
        if (this.exprs == null || this.exprs.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList<Predicate>(this.exprs);
    }

    public Predicate.BooleanOperator getOperator() {
        return this.operator;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public PredicateImpl append(Predicate pred) {
        if (this.exprs == null) {
            this.exprs = new ArrayList<Predicate>();
        }
        this.exprs.add(pred);
        return this;
    }

    @Override
    public org.datanucleus.query.expression.Expression getQueryExpression() {
        if (this.exprs != null && !this.exprs.isEmpty()) {
            Expression.DyadicOperator op = this.operator == Predicate.BooleanOperator.AND ? org.datanucleus.query.expression.Expression.OP_AND : org.datanucleus.query.expression.Expression.OP_OR;
            Iterator<Predicate> iter = this.exprs.iterator();
            org.datanucleus.query.expression.Expression left = null;
            org.datanucleus.query.expression.Expression right = null;
            while (iter.hasNext()) {
                PredicateImpl pred = (PredicateImpl)iter.next();
                if (left == null) {
                    right = left = pred.getQueryExpression();
                    continue;
                }
                left = right;
                right = new DyadicExpression(left, op, pred.getQueryExpression());
            }
            if (this.negated) {
                return new DyadicExpression(org.datanucleus.query.expression.Expression.OP_NOT, right);
            }
            return right;
        }
        if (this.negated) {
            return new DyadicExpression(org.datanucleus.query.expression.Expression.OP_NOT, this.queryExpr);
        }
        return this.queryExpr;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        if (this.negated) {
            str.append("!(");
        }
        if (this.exprs == null || this.exprs.isEmpty()) {
            str.append(JPQLHelper.getJPQLForExpression(this.queryExpr));
        } else {
            Iterator<Predicate> iter = this.exprs.iterator();
            while (iter.hasNext()) {
                Predicate pred = iter.next();
                str.append(pred);
                if (!iter.hasNext()) continue;
                str.append(this.operator == Predicate.BooleanOperator.AND ? " AND " : " OR ");
            }
        }
        if (this.negated) {
            str.append(")");
        }
        return str.toString();
    }
}

