/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa.criteria;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.persistence.criteria.CollectionJoin;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.SetJoin;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SetAttribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.datanucleus.api.jpa.criteria.CollectionJoinImpl;
import org.datanucleus.api.jpa.criteria.FetchImpl;
import org.datanucleus.api.jpa.criteria.JoinImpl;
import org.datanucleus.api.jpa.criteria.ListJoinImpl;
import org.datanucleus.api.jpa.criteria.MapJoinImpl;
import org.datanucleus.api.jpa.criteria.PathImpl;
import org.datanucleus.api.jpa.criteria.PredicateImpl;
import org.datanucleus.api.jpa.criteria.SetJoinImpl;
import org.datanucleus.api.jpa.metamodel.AttributeImpl;
import org.datanucleus.api.jpa.metamodel.CollectionAttributeImpl;
import org.datanucleus.api.jpa.metamodel.ListAttributeImpl;
import org.datanucleus.api.jpa.metamodel.MapAttributeImpl;
import org.datanucleus.api.jpa.metamodel.PluralAttributeImpl;
import org.datanucleus.api.jpa.metamodel.SetAttributeImpl;
import org.datanucleus.api.jpa.metamodel.SingularAttributeImpl;
import org.datanucleus.query.expression.ClassExpression;
import org.datanucleus.query.expression.DyadicExpression;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.JoinExpression;
import org.datanucleus.query.expression.PrimaryExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FromImpl<Z, X>
extends PathImpl<Z, X>
implements From<Z, X> {
    protected Set<Join<X, ?>> joins;
    protected Set<Fetch<X, ?>> fetchJoins;
    protected Type<X> type;

    public FromImpl(ManagedType<X> type) {
        super(type.getJavaType());
        this.type = type;
    }

    public FromImpl(PathImpl<?, Z> parent, AttributeImpl<? super Z, ?> type) {
        super(parent, type, type.getJavaType());
        this.type = type.getType();
    }

    public Type<X> getAttributeType() {
        return this.type;
    }

    public From<Z, X> getCorrelationParent() {
        throw new UnsupportedOperationException("Not yet implemented. Provide a testcase that uses this and raise a JIRA issue attaching your testcase");
    }

    public boolean isCorrelated() {
        return this.getCorrelationParent() != null;
    }

    public Set<Join<X, ?>> getJoins() {
        return this.joins;
    }

    public <Y> CollectionJoin<X, Y> join(CollectionAttribute<? super X, Y> attr, JoinType joinType) {
        CollectionJoinImpl join = new CollectionJoinImpl(this, (CollectionAttributeImpl)attr, joinType);
        if (this.joins == null) {
            this.joins = new HashSet();
        }
        this.joins.add(join);
        return join;
    }

    public <Y> CollectionJoin<X, Y> join(CollectionAttribute<? super X, Y> collection) {
        return this.join(collection, JoinType.INNER);
    }

    public <Y> ListJoin<X, Y> join(ListAttribute<? super X, Y> attr, JoinType joinType) {
        ListJoinImpl join = new ListJoinImpl(this, (ListAttributeImpl)attr, joinType);
        if (this.joins == null) {
            this.joins = new HashSet();
        }
        this.joins.add(join);
        return join;
    }

    public <Y> ListJoin<X, Y> join(ListAttribute<? super X, Y> list) {
        return this.join(list, JoinType.INNER);
    }

    public <K, V> MapJoin<X, K, V> join(MapAttribute<? super X, K, V> attr, JoinType joinType) {
        MapJoinImpl join = new MapJoinImpl(this, (PluralAttributeImpl)((MapAttributeImpl)attr), joinType);
        if (this.joins == null) {
            this.joins = new HashSet();
        }
        this.joins.add(join);
        return join;
    }

    public <K, V> MapJoin<X, K, V> join(MapAttribute<? super X, K, V> map) {
        return this.join(map, JoinType.INNER);
    }

    public <Y> SetJoin<X, Y> join(SetAttribute<? super X, Y> attr, JoinType joinType) {
        SetJoinImpl join = new SetJoinImpl(this, (SetAttributeImpl)attr, joinType);
        if (this.joins == null) {
            this.joins = new HashSet();
        }
        this.joins.add(join);
        return join;
    }

    public <Y> SetJoin<X, Y> join(SetAttribute<? super X, Y> set) {
        return this.join(set, JoinType.INNER);
    }

    public <Y> Join<X, Y> join(SingularAttribute<? super X, Y> attr, JoinType joinType) {
        JoinImpl join = new JoinImpl(this, (SingularAttributeImpl)attr, joinType);
        if (this.joins == null) {
            this.joins = new HashSet();
        }
        this.joins.add(join);
        return join;
    }

    public <Y> Join<X, Y> join(SingularAttribute<? super X, Y> singular) {
        return this.join(singular, JoinType.INNER);
    }

    public <X, Y> Join<X, Y> join(String attrName, JoinType joinType) {
        Attribute attr = this.getAttributeForAttributeName(attrName);
        if (attr instanceof SetAttributeImpl) {
            return this.join((SetAttribute)attr, joinType);
        }
        if (attr instanceof ListAttribute) {
            return this.join((ListAttribute)attr, joinType);
        }
        if (attr instanceof MapAttribute) {
            return this.join((MapAttribute)attr, joinType);
        }
        if (attr instanceof CollectionAttribute) {
            return this.join((CollectionAttribute)attr, joinType);
        }
        return this.join((SingularAttribute)attr, joinType);
    }

    public <X, Y> Join<X, Y> join(String attr) {
        return this.join(attr, JoinType.INNER);
    }

    public <X, Y> CollectionJoin<X, Y> joinCollection(String attrName, JoinType joinType) {
        Attribute attr = this.getAttributeForAttributeName(attrName);
        return this.join((CollectionAttribute)attr, joinType);
    }

    public <X, Y> CollectionJoin<X, Y> joinCollection(String attrName) {
        return this.joinCollection(attrName, JoinType.INNER);
    }

    public <X, Y> ListJoin<X, Y> joinList(String attrName, JoinType joinType) {
        Attribute attr = this.getAttributeForAttributeName(attrName);
        return this.join((ListAttribute)attr, joinType);
    }

    public <X, Y> ListJoin<X, Y> joinList(String attrName) {
        return this.joinList(attrName, JoinType.INNER);
    }

    public <X, K, V> MapJoin<X, K, V> joinMap(String attrName, JoinType joinType) {
        Attribute attr = this.getAttributeForAttributeName(attrName);
        return this.join((MapAttribute)attr, joinType);
    }

    public <X, K, V> MapJoin<X, K, V> joinMap(String attrName) {
        return this.joinMap(attrName, JoinType.INNER);
    }

    public <X, Y> SetJoin<X, Y> joinSet(String attrName, JoinType joinType) {
        Attribute attr = this.getAttributeForAttributeName(attrName);
        return this.join((SetAttribute)attr, joinType);
    }

    public <X, Y> SetJoin<X, Y> joinSet(String attr) {
        return this.joinSet(attr, JoinType.INNER);
    }

    public Set<Fetch<X, ?>> getFetches() {
        return this.fetchJoins;
    }

    public <Y> Fetch<X, Y> fetch(PluralAttribute<? super X, ?, Y> attr, JoinType joinType) {
        FetchImpl fetch = new FetchImpl(this, (AttributeImpl)attr, joinType);
        if (this.fetchJoins == null) {
            this.fetchJoins = new HashSet();
        }
        this.fetchJoins.add(fetch);
        return fetch;
    }

    public <Y> Fetch<X, Y> fetch(PluralAttribute<? super X, ?, Y> attr) {
        return this.fetch(attr, JoinType.INNER);
    }

    public <Y> Fetch<X, Y> fetch(SingularAttribute<? super X, Y> attr, JoinType joinType) {
        FetchImpl fetch = new FetchImpl(this, (SingularAttributeImpl)attr, joinType);
        if (this.fetchJoins == null) {
            this.fetchJoins = new HashSet();
        }
        this.fetchJoins.add(fetch);
        return fetch;
    }

    public <Y> Fetch<X, Y> fetch(SingularAttribute<? super X, Y> attr) {
        return this.fetch(attr, JoinType.INNER);
    }

    public <X, Y> Fetch<X, Y> fetch(String attrName, JoinType joinType) {
        Attribute attr = this.getAttributeForAttributeName(attrName);
        if (attr instanceof SetAttributeImpl) {
            return this.fetch((PluralAttribute<? super X, ?, Y>)((SetAttribute)attr), joinType);
        }
        if (attr instanceof ListAttribute) {
            return this.fetch((PluralAttribute<? super X, ?, Y>)((ListAttribute)attr), joinType);
        }
        if (attr instanceof MapAttribute) {
            return this.fetch((PluralAttribute<? super X, ?, Y>)((MapAttribute)attr), joinType);
        }
        if (attr instanceof CollectionAttribute) {
            return this.fetch((PluralAttribute<? super X, ?, Y>)((CollectionAttribute)attr), joinType);
        }
        return this.fetch((SingularAttribute)attr, joinType);
    }

    public <X, Y> Fetch<X, Y> fetch(String attrName) {
        return this.fetch(attrName, JoinType.INNER);
    }

    public Expression getQueryExpression(boolean from) {
        if (from) {
            JoinExpression joinExpr;
            PrimaryExpression primExpr;
            Attribute attr;
            JoinExpression.JoinType jt;
            Fetch join;
            ClassExpression currentExpr;
            Iterator<Join<X, ?>> iter;
            ArrayList<String> tuples;
            ClassExpression expr = new ClassExpression(this.getAlias());
            if (this.joins != null && !this.joins.isEmpty()) {
                tuples = new ArrayList<String>();
                tuples.add(this.getAlias());
                iter = this.joins.iterator();
                currentExpr = expr;
                while (iter.hasNext()) {
                    join = iter.next();
                    jt = JoinExpression.JoinType.JOIN_INNER;
                    if (join.getJoinType() == JoinType.LEFT) {
                        jt = JoinExpression.JoinType.JOIN_LEFT_OUTER;
                    } else if (join.getJoinType() == JoinType.RIGHT) {
                        jt = JoinExpression.JoinType.JOIN_RIGHT_OUTER;
                    }
                    attr = join.getAttribute();
                    tuples.add(attr.getName());
                    primExpr = new PrimaryExpression(new ArrayList(tuples));
                    joinExpr = new JoinExpression(primExpr, join.getAlias(), jt);
                    if (currentExpr instanceof ClassExpression) {
                        currentExpr.setJoinExpression(joinExpr);
                    } else {
                        ((JoinExpression)currentExpr).setJoinExpression(joinExpr);
                    }
                    if (join.getOn() != null) {
                        PredicateImpl onExpr = (PredicateImpl)join.getOn();
                        joinExpr.setOnExpression((DyadicExpression)onExpr.getQueryExpression());
                    }
                    currentExpr = joinExpr;
                }
            }
            if (this.fetchJoins != null && !this.fetchJoins.isEmpty()) {
                tuples = new ArrayList();
                tuples.add(this.getAlias());
                iter = this.fetchJoins.iterator();
                currentExpr = expr;
                while (iter.hasNext()) {
                    join = (Fetch)iter.next();
                    jt = JoinExpression.JoinType.JOIN_INNER;
                    if (join.getJoinType() == JoinType.LEFT) {
                        jt = JoinExpression.JoinType.JOIN_LEFT_OUTER;
                    } else if (join.getJoinType() == JoinType.RIGHT) {
                        jt = JoinExpression.JoinType.JOIN_RIGHT_OUTER;
                    }
                    attr = join.getAttribute();
                    tuples.add(attr.getName());
                    primExpr = new PrimaryExpression(new ArrayList(tuples));
                    joinExpr = new JoinExpression(primExpr, null, jt);
                    if (currentExpr instanceof ClassExpression) {
                        currentExpr.setJoinExpression(joinExpr);
                    } else {
                        ((JoinExpression)currentExpr).setJoinExpression(joinExpr);
                    }
                    currentExpr = joinExpr;
                }
            }
            return expr;
        }
        ArrayList<String> tuples = new ArrayList<String>();
        String alias = this.getAlias();
        if (alias != null) {
            tuples.add(this.getAlias());
        } else {
            String fieldName = this.attribute.getMetadata().getName();
            if (this.parent != null) {
                tuples.add(this.parent.getAlias());
                tuples.add(fieldName);
                return new PrimaryExpression(tuples);
            }
        }
        return new PrimaryExpression(tuples);
    }

    @Override
    public Expression getQueryExpression() {
        return this.getQueryExpression(false);
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean from) {
        if (from) {
            Attribute attr;
            JoinType type;
            Fetch join;
            StringBuilder joinAttrName;
            Iterator<Join<X, ?>> iter;
            StringBuffer str = new StringBuffer();
            str.append(this.getJavaType().getName());
            if (this.getAlias() != null) {
                str.append(" ").append(this.getAlias());
            }
            if (this.joins != null) {
                str.append(" ");
                iter = this.joins.iterator();
                joinAttrName = new StringBuilder(this.getAlias());
                while (iter.hasNext()) {
                    Predicate onPred;
                    join = iter.next();
                    type = join.getJoinType();
                    if (type == JoinType.INNER) {
                        str.append("JOIN ");
                    } else if (type == JoinType.LEFT) {
                        str.append("LEFT JOIN ");
                    } else if (type == JoinType.RIGHT) {
                        str.append("RIGHT JOIN ");
                    }
                    attr = join.getAttribute();
                    joinAttrName.append('.').append(attr.getName());
                    str.append(joinAttrName.toString()).append(" ");
                    if (join.getAlias() != null) {
                        str.append(join.getAlias());
                    }
                    if ((onPred = join.getOn()) == null) continue;
                    str.append(" ");
                    str.append("ON ");
                    str.append(onPred.toString());
                }
            }
            if (this.fetchJoins != null) {
                str.append(" ");
                iter = this.fetchJoins.iterator();
                joinAttrName = new StringBuilder(this.getAlias());
                while (iter.hasNext()) {
                    join = (Fetch)iter.next();
                    type = join.getJoinType();
                    if (type == JoinType.INNER) {
                        str.append("JOIN FETCH ");
                    } else if (type == JoinType.LEFT) {
                        str.append("LEFT JOIN FETCH ");
                    } else if (type == JoinType.RIGHT) {
                        str.append("RIGHT JOIN FETCH ");
                    }
                    attr = join.getAttribute();
                    joinAttrName.append('.').append(attr.getName());
                    str.append(joinAttrName.toString()).append(" ");
                }
            }
            return str.toString();
        }
        if (this.getAlias() != null) {
            return this.getAlias();
        }
        return "(unaliased type=" + this.getJavaType().getName() + ")";
    }

    protected Attribute getAttributeForAttributeName(String attrName) {
        if (attrName == null) {
            throw new IllegalArgumentException("Cannot join to null attribute");
        }
        StringTokenizer tokeniser = new StringTokenizer(attrName, ".");
        if (!tokeniser.hasMoreTokens()) {
            throw new IllegalArgumentException("Cannot join to null attribute");
        }
        String token = tokeniser.nextToken();
        ManagedType currentType = (ManagedType)this.type;
        if (!token.equalsIgnoreCase(this.getAlias())) {
            tokeniser = new StringTokenizer(attrName, ".");
        }
        AttributeImpl currentAttr = null;
        while (tokeniser.hasMoreTokens()) {
            token = tokeniser.nextToken();
            currentAttr = (AttributeImpl)currentType.getAttribute(token);
            if (currentAttr == null) {
                throw new IllegalArgumentException("Unable to access attribute " + token + " of " + currentType + " for join");
            }
            if (!tokeniser.hasMoreTokens()) continue;
            if (currentAttr.getPersistentAttributeType() == Attribute.PersistentAttributeType.BASIC) {
                throw new IllegalArgumentException("Cannot resolve attribute " + attrName + " since " + token + " is not a relation field and the attribute name goes beyond it!");
            }
            currentType = (ManagedType)currentAttr.getType();
        }
        return currentAttr;
    }
}

