/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa;

import javax.persistence.Cache;
import javax.persistence.EntityNotFoundException;
import javax.persistence.PersistenceException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.NucleusContext;
import org.datanucleus.cache.Level2Cache;
import org.datanucleus.metadata.AbstractClassMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPADataStoreCache
implements Cache {
    NucleusContext nucleusCtx;
    Level2Cache cache = null;

    public JPADataStoreCache(NucleusContext nucleusCtx, Level2Cache cache) {
        this.nucleusCtx = nucleusCtx;
        this.cache = cache;
    }

    public Level2Cache getLevel2Cache() {
        return this.cache;
    }

    public boolean contains(Class cls, Object pk) {
        ClassLoaderResolver clr = this.nucleusCtx.getClassLoaderResolver(null);
        AbstractClassMetaData acmd = this.nucleusCtx.getMetaDataManager().getMetaDataForClass(cls, clr);
        if (acmd == null) {
            throw new EntityNotFoundException();
        }
        return this.cache.containsOid(pk);
    }

    public void evictAll() {
        this.cache.evictAll();
    }

    public void evict(Class cls) {
        this.cache.evictAll(cls, true);
    }

    public void evict(Class cls, Object pk) {
        ClassLoaderResolver clr = this.nucleusCtx.getClassLoaderResolver(null);
        AbstractClassMetaData acmd = this.nucleusCtx.getMetaDataManager().getMetaDataForClass(cls, clr);
        if (acmd == null) {
            throw new EntityNotFoundException();
        }
        this.cache.evict(pk);
    }

    public <T> T unwrap(Class<T> cls) {
        if (Level2Cache.class.isAssignableFrom(cls)) {
            return (T)this.cache;
        }
        throw new PersistenceException("Not yet supported");
    }
}

