/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa.criteria;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Selection;
import org.datanucleus.api.jpa.criteria.JPQLHelper;
import org.datanucleus.api.jpa.criteria.PredicateImpl;
import org.datanucleus.query.expression.DyadicExpression;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.Literal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionImpl<T>
implements Selection<T>,
Expression<T> {
    private final Class<T> cls;
    private String alias;
    org.datanucleus.query.expression.Expression queryExpr;

    public ExpressionImpl(Class<T> cls) {
        this.cls = cls;
    }

    public <X> Expression<X> as(Class<X> cls) {
        ExpressionImpl<X> expr = new ExpressionImpl<X>(cls);
        expr.queryExpr = this.queryExpr;
        return expr;
    }

    public Predicate in(Collection<?> coll) {
        PredicateImpl pred = new PredicateImpl(Predicate.BooleanOperator.OR);
        pred.queryExpr = this.queryExpr;
        Iterator<?> iter = coll.iterator();
        while (iter.hasNext()) {
            PredicateImpl predSub = new PredicateImpl();
            Object obj = iter.next();
            predSub.queryExpr = new DyadicExpression(this.getQueryExpression(), org.datanucleus.query.expression.Expression.OP_EQ, (org.datanucleus.query.expression.Expression)new Literal(obj));
            pred.append(predSub);
        }
        return pred;
    }

    public Predicate in(Expression<?> ... exprs) {
        PredicateImpl pred = new PredicateImpl(Predicate.BooleanOperator.OR);
        pred.queryExpr = this.queryExpr;
        for (int i = 0; i < exprs.length; ++i) {
            PredicateImpl predSub = new PredicateImpl();
            predSub.queryExpr = new DyadicExpression(this.getQueryExpression(), org.datanucleus.query.expression.Expression.OP_EQ, ((ExpressionImpl)exprs[i]).getQueryExpression());
            pred.append(predSub);
        }
        return pred;
    }

    public Predicate in(Expression<Collection<?>> collExpr) {
        PredicateImpl pred = new PredicateImpl();
        ArrayList<org.datanucleus.query.expression.Expression> args = new ArrayList<org.datanucleus.query.expression.Expression>();
        args.add(this.getQueryExpression());
        InvokeExpression queryExpr = new InvokeExpression(((ExpressionImpl)collExpr).getQueryExpression(), "contains", args);
        pred.queryExpr = queryExpr;
        return pred;
    }

    public Predicate in(Object ... expr) {
        PredicateImpl pred = new PredicateImpl(Predicate.BooleanOperator.OR);
        pred.queryExpr = this.queryExpr;
        for (int i = 0; i < expr.length; ++i) {
            PredicateImpl predSub = new PredicateImpl();
            predSub.queryExpr = new DyadicExpression(this.getQueryExpression(), org.datanucleus.query.expression.Expression.OP_EQ, (org.datanucleus.query.expression.Expression)new Literal(expr[i]));
            pred.append(predSub);
        }
        return pred;
    }

    public Predicate isNotNull() {
        PredicateImpl pred = new PredicateImpl();
        Literal lit = new Literal(null);
        DyadicExpression queryExpr = new DyadicExpression(this.getQueryExpression(), org.datanucleus.query.expression.Expression.OP_NOTEQ, (org.datanucleus.query.expression.Expression)lit);
        pred.queryExpr = queryExpr;
        return pred;
    }

    public Predicate isNull() {
        PredicateImpl pred = new PredicateImpl();
        Literal lit = new Literal(null);
        DyadicExpression queryExpr = new DyadicExpression(this.getQueryExpression(), org.datanucleus.query.expression.Expression.OP_EQ, (org.datanucleus.query.expression.Expression)lit);
        pred.queryExpr = queryExpr;
        return pred;
    }

    public Selection<T> alias(String alias) {
        this.alias = alias;
        return this;
    }

    public List<Selection<?>> getCompoundSelectionItems() {
        throw new UnsupportedOperationException("Not yet implemented. Provide a testcase that uses this and raise a JIRA attaching your testcase");
    }

    public boolean isCompoundSelection() {
        throw new UnsupportedOperationException("Not yet implemented. Provide a testcase that uses this and raise a JIRA attaching your testcase");
    }

    public String getAlias() {
        return this.alias;
    }

    public Class<? extends T> getJavaType() {
        return this.cls;
    }

    public org.datanucleus.query.expression.Expression getQueryExpression() {
        return this.queryExpr;
    }

    public String toString() {
        return JPQLHelper.getJPQLForExpression(this.queryExpr);
    }
}

