/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo;

import java.lang.reflect.Field;
import java.util.Collection;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.identity.ByteIdentity;
import javax.jdo.identity.CharIdentity;
import javax.jdo.identity.IntIdentity;
import javax.jdo.identity.LongIdentity;
import javax.jdo.identity.ObjectIdentity;
import javax.jdo.identity.ShortIdentity;
import javax.jdo.identity.SingleFieldIdentity;
import javax.jdo.identity.StringIdentity;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.jdo.JDOPersistenceManager;
import org.datanucleus.api.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.api.jdo.JDOQueryCache;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.identity.ByteId;
import org.datanucleus.identity.CharId;
import org.datanucleus.identity.IntId;
import org.datanucleus.identity.LongId;
import org.datanucleus.identity.ObjectId;
import org.datanucleus.identity.ShortId;
import org.datanucleus.identity.SingleFieldId;
import org.datanucleus.identity.StringId;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.util.ClassUtils;

public class DataNucleusHelperJDO {
    public static JDOQueryCache getQueryResultCache(PersistenceManagerFactory pmf) {
        return ((JDOPersistenceManagerFactory)pmf).getQueryCache();
    }

    public static SingleFieldIdentity getSingleFieldIdentityForDataNucleusIdentity(SingleFieldId dnid, Class targetClass) {
        if (dnid instanceof LongId) {
            return new LongIdentity(targetClass, dnid.toString());
        }
        if (dnid instanceof IntId) {
            return new IntIdentity(targetClass, dnid.toString());
        }
        if (dnid instanceof ShortId) {
            return new ShortIdentity(targetClass, dnid.toString());
        }
        if (dnid instanceof ByteId) {
            return new ByteIdentity(targetClass, dnid.toString());
        }
        if (dnid instanceof StringId) {
            return new StringIdentity(targetClass, dnid.toString());
        }
        if (dnid instanceof CharId) {
            return new CharIdentity(targetClass, dnid.toString());
        }
        return new ObjectIdentity(targetClass, dnid.getKeyAsObject());
    }

    public static SingleFieldId getDataNucleusIdentityForSingleFieldIdentity(SingleFieldIdentity sfid) {
        if (sfid instanceof LongIdentity) {
            return new LongId(sfid.getTargetClass(), sfid.toString());
        }
        if (sfid instanceof IntIdentity) {
            return new IntId(sfid.getTargetClass(), sfid.toString());
        }
        if (sfid instanceof ShortIdentity) {
            return new ShortId(sfid.getTargetClass(), sfid.toString());
        }
        if (sfid instanceof ByteIdentity) {
            return new ByteId(sfid.getTargetClass(), sfid.toString());
        }
        if (sfid instanceof StringIdentity) {
            return new StringId(sfid.getTargetClass(), sfid.toString());
        }
        if (sfid instanceof CharIdentity) {
            return new CharId(sfid.getTargetClass(), sfid.toString());
        }
        return new ObjectId(sfid.getTargetClass(), sfid.getKeyAsObject());
    }

    public static String getObjectIdClassForInputIdClass(String objectIdClass) {
        if (objectIdClass != null && objectIdClass.startsWith("javax.jdo.identity")) {
            if (objectIdClass.equals("javax.jdo.identity.ByteIdentity")) {
                return ClassNameConstants.IDENTITY_SINGLEFIELD_BYTE;
            }
            if (objectIdClass.equals("javax.jdo.identity.CharIdentity")) {
                return ClassNameConstants.IDENTITY_SINGLEFIELD_CHAR;
            }
            if (objectIdClass.equals("javax.jdo.identity.IntIdentity")) {
                return ClassNameConstants.IDENTITY_SINGLEFIELD_INT;
            }
            if (objectIdClass.equals("javax.jdo.identity.LongIdentity")) {
                return ClassNameConstants.IDENTITY_SINGLEFIELD_LONG;
            }
            if (objectIdClass.equals("javax.jdo.identity.ShortIdentity")) {
                return ClassNameConstants.IDENTITY_SINGLEFIELD_SHORT;
            }
            if (objectIdClass.equals("javax.jdo.identity.StringIdentity")) {
                return ClassNameConstants.IDENTITY_SINGLEFIELD_STRING;
            }
            if (objectIdClass.equals("javax.jdo.identity.ObjectIdentity")) {
                return ClassNameConstants.IDENTITY_SINGLEFIELD_OBJECT;
            }
        }
        return objectIdClass;
    }

    public static ClassMetaData getMetaDataForClass(PersistenceManagerFactory pmf, Class cls) {
        if (pmf == null || cls == null) {
            return null;
        }
        if (!(pmf instanceof JDOPersistenceManagerFactory)) {
            return null;
        }
        JDOPersistenceManagerFactory myPMF = (JDOPersistenceManagerFactory)pmf;
        MetaDataManager mdmgr = myPMF.getNucleusContext().getMetaDataManager();
        return (ClassMetaData)mdmgr.getMetaDataForClass(cls, myPMF.getNucleusContext().getClassLoaderResolver(null));
    }

    public static String[] getClassesWithMetaData(PersistenceManagerFactory pmf) {
        if (pmf == null || !(pmf instanceof JDOPersistenceManagerFactory)) {
            return null;
        }
        JDOPersistenceManagerFactory myPMF = (JDOPersistenceManagerFactory)pmf;
        Collection classes = myPMF.getNucleusContext().getMetaDataManager().getClassesWithMetaData();
        return classes.toArray(new String[classes.size()]);
    }

    public static Object[] getDetachedStateForObject(Object obj) {
        if (obj == null || !JDOHelper.isDetached((Object)obj)) {
            return null;
        }
        try {
            Field fld = ClassUtils.getFieldForClass(obj.getClass(), (String)"dnDetachedState");
            fld.setAccessible(true);
            return (Object[])fld.get(obj);
        }
        catch (Exception e) {
            throw new NucleusException("Exception accessing dnDetachedState field", (Throwable)e);
        }
    }

    public static String[] getDirtyFields(Object obj, PersistenceManager pm) {
        if (obj == null || !(obj instanceof Persistable)) {
            return null;
        }
        Persistable pc = (Persistable)obj;
        if (JDOHelper.isDetached((Object)pc)) {
            ExecutionContext ec = ((JDOPersistenceManager)pm).getExecutionContext();
            DNStateManager sm = ec.getNucleusContext().getStateManagerFactory().newForDetached(ec, (Object)pc, JDOHelper.getObjectId((Object)pc), null);
            pc.dnReplaceStateManager((StateManager)sm);
            sm.retrieveDetachState(sm);
            String[] dirtyFieldNames = sm.getDirtyFieldNames();
            pc.dnReplaceStateManager(null);
            return dirtyFieldNames;
        }
        ExecutionContext ec = (ExecutionContext)pc.dnGetExecutionContext();
        DNStateManager sm = ec.findStateManager((Object)pc);
        if (sm == null) {
            return null;
        }
        return sm.getDirtyFieldNames();
    }

    public static String[] getLoadedFields(Object obj, PersistenceManager pm) {
        if (obj == null || !(obj instanceof Persistable)) {
            return null;
        }
        Persistable pc = (Persistable)obj;
        if (JDOHelper.isDetached((Object)pc)) {
            ExecutionContext ec = ((JDOPersistenceManager)pm).getExecutionContext();
            DNStateManager sm = ec.getNucleusContext().getStateManagerFactory().newForDetached(ec, (Object)pc, JDOHelper.getObjectId((Object)pc), null);
            pc.dnReplaceStateManager((StateManager)sm);
            sm.retrieveDetachState(sm);
            String[] loadedFieldNames = sm.getLoadedFieldNames();
            pc.dnReplaceStateManager(null);
            return loadedFieldNames;
        }
        ExecutionContext ec = (ExecutionContext)pc.dnGetExecutionContext();
        DNStateManager sm = ec.findStateManager((Object)pc);
        if (sm == null) {
            return null;
        }
        return sm.getLoadedFieldNames();
    }

    public static Boolean isFieldLoaded(Object obj, String memberName, PersistenceManager pm) {
        if (obj == null || !(obj instanceof Persistable)) {
            return null;
        }
        Persistable pc = (Persistable)obj;
        if (JDOHelper.isDetached((Object)pc)) {
            ExecutionContext ec = ((JDOPersistenceManager)pm).getExecutionContext();
            DNStateManager sm = ec.getNucleusContext().getStateManagerFactory().newForDetached(ec, (Object)pc, JDOHelper.getObjectId((Object)pc), null);
            pc.dnReplaceStateManager((StateManager)sm);
            sm.retrieveDetachState(sm);
            int position = sm.getClassMetaData().getAbsolutePositionOfMember(memberName);
            boolean loaded = sm.isFieldLoaded(position);
            pc.dnReplaceStateManager(null);
            return loaded;
        }
        ExecutionContext ec = (ExecutionContext)pc.dnGetExecutionContext();
        DNStateManager sm = ec.findStateManager((Object)pc);
        if (sm == null) {
            return null;
        }
        int position = sm.getClassMetaData().getAbsolutePositionOfMember(memberName);
        return sm.isFieldLoaded(position);
    }

    public static Boolean isFieldDirty(Object obj, String memberName, PersistenceManager pm) {
        if (obj == null || !(obj instanceof Persistable)) {
            return null;
        }
        Persistable pc = (Persistable)obj;
        if (JDOHelper.isDetached((Object)pc)) {
            ExecutionContext ec = ((JDOPersistenceManager)pm).getExecutionContext();
            DNStateManager sm = ec.getNucleusContext().getStateManagerFactory().newForDetached(ec, (Object)pc, JDOHelper.getObjectId((Object)pc), null);
            pc.dnReplaceStateManager((StateManager)sm);
            sm.retrieveDetachState(sm);
            int position = sm.getClassMetaData().getAbsolutePositionOfMember(memberName);
            boolean[] dirtyFieldNumbers = sm.getDirtyFields();
            pc.dnReplaceStateManager(null);
            return dirtyFieldNumbers[position];
        }
        ExecutionContext ec = (ExecutionContext)pc.dnGetExecutionContext();
        DNStateManager sm = ec.findStateManager((Object)pc);
        if (sm == null) {
            return null;
        }
        int position = sm.getClassMetaData().getAbsolutePositionOfMember(memberName);
        boolean[] dirtyFieldNumbers = sm.getDirtyFields();
        return dirtyFieldNumbers[position];
    }
}

