/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo.metadata;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ArrayMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ContainerMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.FetchGroupMemberMetaData;
import org.datanucleus.metadata.FetchGroupMetaData;
import org.datanucleus.metadata.FetchPlanMetaData;
import org.datanucleus.metadata.FieldMetaData;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.ForeignKeyMetaData;
import org.datanucleus.metadata.IdentityMetaData;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.InheritanceMetaData;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.JoinMetaData;
import org.datanucleus.metadata.KeyMetaData;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.metadata.OrderMetaData;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.PrimaryKeyMetaData;
import org.datanucleus.metadata.PropertyMetaData;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.metadata.ValueMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.util.StringUtils;

public class JDOMetaDataHelper {
    public String getXMLForMetaData(AbstractClassMetaData cmd, String prefix, String indent) {
        Set fetchGroups;
        QueryMetaData[] queries;
        List uniqueConstraints;
        List indexes;
        List foreignKeys;
        List joins;
        StringBuilder str = new StringBuilder();
        boolean intf = cmd instanceof InterfaceMetaData;
        if (intf) {
            str.append(prefix).append("<interface name=\"" + cmd.getName() + "\"");
        } else {
            str.append(prefix).append("<class name=\"" + cmd.getName() + "\"");
        }
        if (cmd.getIdentityType() != null) {
            str.append("\n").append(prefix).append("       identity-type=\"" + cmd.getIdentityType() + "\"");
        }
        if (cmd.getObjectidClass() != null) {
            str.append("\n").append(prefix).append("       objectid-class=\"" + cmd.getObjectidClass() + "\"");
        }
        if (!cmd.isRequiresExtent()) {
            str.append("\n").append(prefix).append("       requires-extent=\"" + cmd.isRequiresExtent() + "\"");
        }
        if (cmd.isEmbeddedOnly()) {
            str.append("\n").append(prefix).append("       embedded-only=\"" + cmd.isEmbeddedOnly() + "\"");
        }
        if (cmd.getPersistenceModifier() != null) {
            str.append("\n").append(prefix).append("       persistence-modifier=\"" + cmd.getPersistenceModifier() + "\"");
        }
        if (cmd.getCatalog() != null) {
            str.append("\n").append(prefix).append("       catalog=\"" + cmd.getCatalog() + "\"");
        }
        if (cmd.getSchema() != null) {
            str.append("\n").append(prefix).append("       schema=\"" + cmd.getSchema() + "\"");
        }
        if (cmd.getTable() != null) {
            str.append("\n").append(prefix).append("       table=\"" + cmd.getTable() + "\"");
        }
        if (cmd.isDetachable()) {
            str.append("\n").append(prefix).append("       detachable=\"" + cmd.isDetachable() + "\"");
        }
        str.append(">\n");
        if (cmd.getIdentityMetaData() != null) {
            str.append(this.getXMLForMetaData(cmd.getIdentityMetaData(), prefix + indent, indent));
        }
        if (cmd.getPrimaryKeyMetaData() != null) {
            str.append(this.getXMLForMetaData(cmd.getPrimaryKeyMetaData(), prefix + indent, indent));
        }
        if (cmd.getInheritanceMetaData() != null) {
            str.append(this.getXMLForMetaData(cmd.getInheritanceMetaData(), prefix + indent, indent));
        }
        if (cmd.getVersionMetaData() != null) {
            str.append(this.getXMLForMetaData(cmd.getVersionMetaData(), prefix + indent, indent));
        }
        if ((joins = cmd.getJoinMetaData()) != null) {
            for (JoinMetaData joinmd : joins) {
                str.append(this.getXMLForMetaData(joinmd, prefix + indent, indent));
            }
        }
        if ((foreignKeys = cmd.getForeignKeyMetaData()) != null) {
            for (ForeignKeyMetaData fkmd : foreignKeys) {
                str.append(this.getXMLForMetaData(fkmd, prefix + indent, indent));
            }
        }
        if ((indexes = cmd.getIndexMetaData()) != null) {
            for (IndexMetaData idxmd : indexes) {
                str.append(this.getXMLForMetaData(idxmd, prefix + indent, indent));
            }
        }
        if ((uniqueConstraints = cmd.getUniqueMetaData()) != null) {
            for (UniqueMetaData unimd : uniqueConstraints) {
                str.append(this.getXMLForMetaData(unimd, prefix + indent, indent));
            }
        }
        int numMembers = cmd.getNoOfMembers();
        for (int i = 0; i < numMembers; ++i) {
            AbstractMemberMetaData mmd = cmd.getMetaDataForMemberAtRelativePosition(i);
            str.append(this.getXMLForMetaData(mmd, prefix + indent, indent));
        }
        List unmappedColumns = cmd.getUnmappedColumns();
        if (unmappedColumns != null) {
            for (int i = 0; i < unmappedColumns.size(); ++i) {
                ColumnMetaData col = (ColumnMetaData)unmappedColumns.get(i);
                str.append(this.getXMLForMetaData(col, prefix + indent, indent));
            }
        }
        if ((queries = cmd.getQueries()) != null) {
            for (int i = 0; i < queries.length; ++i) {
                QueryMetaData q = queries[i];
                str.append(this.getXMLForMetaData(q, prefix + indent, indent));
            }
        }
        if ((fetchGroups = cmd.getFetchGroupMetaData()) != null) {
            for (FetchGroupMetaData fgmd : fetchGroups) {
                str.append(this.getXMLForMetaData(fgmd, prefix + indent, indent));
            }
        }
        this.processExtensions(cmd.getExtensions(), str, prefix, indent);
        if (intf) {
            str.append(prefix + "</interface>\n");
        } else {
            str.append(prefix + "</class>\n");
        }
        return str.toString();
    }

    public String getXMLForMetaData(IdentityMetaData idmd, String prefix, String indent) {
        StringBuilder str = new StringBuilder();
        if (idmd.getValueStrategy() != null) {
            str.append(prefix).append("<datastore-identity strategy=\"" + idmd.getValueStrategy() + "\"");
        } else {
            str.append(prefix).append("<datastore-identity");
        }
        if (idmd.getColumnName() != null) {
            str.append("\n").append(prefix).append("        column=\"" + idmd.getColumnName() + "\"");
        }
        if (idmd.getSequence() != null) {
            str.append("\n").append(prefix).append("        sequence=\"" + idmd.getSequence() + "\"");
        }
        if (idmd.getColumnMetaData() != null || idmd.getNoOfExtensions() > 0) {
            str.append(">\n");
            ColumnMetaData columnMetaData = idmd.getColumnMetaData();
            if (columnMetaData != null) {
                str.append(this.getXMLForMetaData(columnMetaData, prefix + indent, indent));
            }
            this.processExtensions(idmd.getExtensions(), str, prefix, indent);
            str.append(prefix).append("</datastore-identity>\n");
        } else {
            str.append("/>\n");
        }
        return str.toString();
    }

    public String getXMLForMetaData(ColumnMetaData colmd, String prefix, String indent) {
        Map extensions;
        StringBuilder str = new StringBuilder();
        str.append(prefix).append("<column");
        if (colmd.getName() != null) {
            str.append(" name=\"" + colmd.getName() + "\"");
        }
        if (colmd.getTarget() != null) {
            str.append(" target=\"" + colmd.getTarget() + "\"");
        }
        if (colmd.getTargetMember() != null) {
            str.append(" target-field=\"" + colmd.getTargetMember() + "\"");
        }
        if (colmd.getJdbcTypeName() != null) {
            str.append(" jdbc-type=\"" + colmd.getJdbcTypeName() + "\"");
        }
        if (colmd.getSqlType() != null) {
            str.append(" sql-type=\"" + colmd.getSqlType() + "\"");
        }
        if (colmd.isAllowsNull()) {
            str.append(" allows-null=\"" + colmd.isAllowsNull() + "\"");
        }
        if (colmd.getLength() != null) {
            str.append(" length=\"" + colmd.getLength() + "\"");
        }
        if (colmd.getScale() != null) {
            str.append(" scale=\"" + colmd.getScale() + "\"");
        }
        if (colmd.getDefaultValue() != null) {
            str.append(" default-value=\"" + colmd.getDefaultValue() + "\"");
        }
        if (colmd.getInsertValue() != null) {
            str.append(" insert-value=\"" + colmd.getInsertValue() + "\"");
        }
        if (colmd.getPosition() != null) {
            str.append(" position=\"" + colmd.getPosition() + "\"");
        }
        if ((extensions = colmd.getExtensions()) != null) {
            this.processExtensions(extensions, str, prefix, indent);
            str.append(prefix).append("</column>\n");
        } else {
            str.append("/>\n");
        }
        return str.toString();
    }

    public String getXMLForMetaData(PrimaryKeyMetaData pkmd, String prefix, String indent) {
        StringBuilder str = new StringBuilder();
        str.append(prefix).append("<primary-key" + (String)(pkmd.getName() != null ? " name=\"" + pkmd.getName() + "\"" : "") + (String)(pkmd.getColumnName() != null ? " column=\"" + pkmd.getColumnName() + "\"" : "") + ">\n");
        ColumnMetaData[] columns = pkmd.getColumnMetaData();
        if (columns != null) {
            for (ColumnMetaData colmd : columns) {
                str.append(this.getXMLForMetaData(colmd, prefix + indent, indent));
            }
        }
        this.processExtensions(pkmd.getExtensions(), str, prefix, indent);
        str.append(prefix).append("</primary-key>\n");
        return str.toString();
    }

    public String getXMLForMetaData(InheritanceMetaData inhmd, String prefix, String indent) {
        StringBuilder str = new StringBuilder();
        str.append(prefix).append("<inheritance strategy=\"" + inhmd.getStrategy() + "\">\n");
        if (inhmd.getJoinMetaData() != null) {
            str.append(this.getXMLForMetaData(inhmd.getJoinMetaData(), prefix + indent, indent));
        }
        if (inhmd.getDiscriminatorMetaData() != null) {
            str.append(this.getXMLForMetaData(inhmd.getDiscriminatorMetaData(), prefix + indent, indent));
        }
        this.processExtensions(inhmd.getExtensions(), str, prefix, indent);
        str.append(prefix).append("</inheritance>\n");
        return str.toString();
    }

    public String getXMLForMetaData(DiscriminatorMetaData dismd, String prefix, String indent) {
        StringBuilder str = new StringBuilder();
        str.append(prefix).append("<discriminator");
        if (dismd.getStrategy() != null) {
            str.append(" strategy=\"" + dismd.getStrategy() + "\"");
        }
        if (dismd.getColumnName() != null && dismd.getColumnMetaData() == null) {
            str.append(" column=\"" + dismd.getColumnName() + "\"");
        }
        if (dismd.getValue() != null) {
            str.append(" value=\"" + dismd.getValue() + "\"");
        }
        if (dismd.getIndexed() != null) {
            str.append(" indexed=\"" + dismd.getIndexed() + "\"");
        }
        str.append(">\n");
        if (dismd.getColumnMetaData() != null) {
            str.append(this.getXMLForMetaData(dismd.getColumnMetaData(), prefix + indent, indent));
        }
        if (dismd.getIndexMetaData() != null) {
            str.append(this.getXMLForMetaData(dismd.getIndexMetaData(), prefix + indent, indent));
        }
        this.processExtensions(dismd.getExtensions(), str, prefix, indent);
        str.append(prefix).append("</discriminator>\n");
        return str.toString();
    }

    public String getXMLForMetaData(IndexMetaData idxmd, String prefix, String indent) {
        String[] columnNames;
        StringBuilder str = new StringBuilder();
        str.append(prefix).append("<index unique=\"" + idxmd.isUnique() + "\"");
        if (idxmd.getTable() != null) {
            str.append(" table=\"" + idxmd.getTable() + "\"");
        }
        str.append((String)(idxmd.getName() != null ? " name=\"" + idxmd.getName() + "\">\n" : ">\n"));
        String[] memberNames = idxmd.getMemberNames();
        if (memberNames != null) {
            for (String memberName : memberNames) {
                str.append(prefix).append(indent).append("<field name=\"" + memberName + "\"/>\n");
            }
        }
        if ((columnNames = idxmd.getColumnNames()) != null) {
            for (String columnName : columnNames) {
                str.append(prefix).append(indent).append("<column name=\"" + columnName + "\"/>\n");
            }
        }
        this.processExtensions(idxmd.getExtensions(), str, prefix, indent);
        str.append(prefix).append("</index>\n");
        return str.toString();
    }

    public String getXMLForMetaData(UniqueMetaData unimd, String prefix, String indent) {
        String[] columnNames;
        StringBuilder str = new StringBuilder();
        str.append(prefix).append("<unique");
        if (unimd.getTable() != null) {
            str.append(" table=\"" + unimd.getTable() + "\"");
        }
        if (unimd.isDeferred()) {
            str.append(" deferred=\"true\"");
        }
        str.append((String)(unimd.getName() != null ? " name=\"" + unimd.getName() + "\">\n" : ">\n"));
        String[] memberNames = unimd.getMemberNames();
        if (memberNames != null) {
            for (String memberName : memberNames) {
                str.append(prefix).append(indent).append("<field name=\"" + memberName + "\"/>\n");
            }
        }
        if ((columnNames = unimd.getColumnNames()) != null) {
            for (String columnName : columnNames) {
                str.append(prefix).append(indent).append("<column name=\"" + columnName + "\"/>\n");
            }
        }
        this.processExtensions(unimd.getExtensions(), str, prefix, indent);
        str.append(prefix).append("</unique>\n");
        return str.toString();
    }

    public String getXMLForMetaData(JoinMetaData joinmd, String prefix, String indent) {
        ColumnMetaData[] columns;
        StringBuilder str = new StringBuilder();
        str.append(prefix).append("<join");
        if (joinmd.getTable() != null) {
            str.append(" table=\"" + joinmd.getTable() + "\"");
        }
        if (joinmd.getColumnName() != null) {
            str.append(" column=\"" + joinmd.getColumnName() + "\"");
        }
        str.append(" outer=\"" + joinmd.isOuter() + "\"");
        str.append(">\n");
        if (joinmd.getPrimaryKeyMetaData() != null) {
            str.append(this.getXMLForMetaData(joinmd.getPrimaryKeyMetaData(), prefix + indent, indent));
        }
        if ((columns = joinmd.getColumnMetaData()) != null) {
            for (ColumnMetaData colmd : columns) {
                str.append(this.getXMLForMetaData(colmd, prefix + indent, indent));
            }
        }
        if (joinmd.getForeignKeyMetaData() != null) {
            str.append(this.getXMLForMetaData(joinmd.getForeignKeyMetaData(), prefix + indent, indent));
        }
        if (joinmd.getIndexMetaData() != null) {
            str.append(this.getXMLForMetaData(joinmd.getIndexMetaData(), prefix + indent, indent));
        }
        if (joinmd.getUniqueMetaData() != null) {
            str.append(this.getXMLForMetaData(joinmd.getUniqueMetaData(), prefix + indent, indent));
        }
        this.processExtensions(joinmd.getExtensions(), str, prefix, indent);
        str.append(prefix).append("</join>\n");
        return str.toString();
    }

    public String getXMLForMetaData(ForeignKeyMetaData fkmd, String prefix, String indent) {
        ColumnMetaData[] columns;
        if (!StringUtils.isWhitespace((String)fkmd.getFkDefinition())) {
            return "<foreign-key name=\"" + fkmd.getName() + "\" definition=\"" + fkmd.getFkDefinition() + "\" definition-applies=" + fkmd.getFkDefinitionApplies() + "/>";
        }
        StringBuilder str = new StringBuilder();
        str.append(prefix).append("<foreign-key deferred=\"" + fkmd.isDeferred() + "\"\n");
        str.append(prefix).append("       unique=\"" + fkmd.isUnique() + "\"");
        if (fkmd.getUpdateAction() != null) {
            str.append("\n").append(prefix).append("       update-action=\"" + fkmd.getUpdateAction() + "\"");
        }
        if (fkmd.getDeleteAction() != null) {
            str.append("\n").append(prefix).append("       delete-action=\"" + fkmd.getDeleteAction() + "\"");
        }
        if (fkmd.getTable() != null) {
            str.append("\n").append(prefix).append("       table=\"" + fkmd.getTable() + "\"");
        }
        if (fkmd.getName() != null) {
            str.append("\n").append(prefix).append("       name=\"" + fkmd.getName() + "\"");
        }
        str.append(">\n");
        String[] memberNames = fkmd.getMemberNames();
        if (memberNames != null) {
            for (String memberName : memberNames) {
                str.append(prefix).append(indent).append("<field name=\"" + memberName + "\"/>\n");
            }
        }
        if ((columns = fkmd.getColumnMetaData()) != null) {
            for (ColumnMetaData colmd : columns) {
                str.append(this.getXMLForMetaData(colmd, prefix + indent, indent));
            }
        }
        this.processExtensions(fkmd.getExtensions(), str, prefix, indent);
        str.append(prefix).append("</foreign-key>\n");
        return str.toString();
    }

    public String getXMLForMetaData(VersionMetaData vermd, String prefix, String indent) {
        StringBuilder str = new StringBuilder();
        str.append(prefix).append("<version " + (String)(vermd.getVersionStrategy() != null ? "strategy=\"" + vermd.getVersionStrategy() + "\"" : "") + (String)(vermd.getIndexed() != null ? " indexed=\"" + vermd.getIndexed() + "\"" : ""));
        if (vermd.getColumnName() != null && vermd.getColumnMetaData() == null) {
            str.append(" column=\"" + vermd.getColumnName() + "\"");
        }
        str.append(">\n");
        if (vermd.getColumnMetaData() != null) {
            str.append(this.getXMLForMetaData(vermd.getColumnMetaData(), prefix + indent, indent));
        }
        if (vermd.getIndexMetaData() != null) {
            str.append(this.getXMLForMetaData(vermd.getIndexMetaData(), prefix + indent, indent));
        }
        this.processExtensions(vermd.getExtensions(), str, prefix, indent);
        str.append(prefix).append("</version>\n");
        return str.toString();
    }

    public String getXMLForMetaData(QueryMetaData qmd, String prefix, String indent) {
        StringBuilder str = new StringBuilder();
        str.append(prefix).append("<query name=\"" + qmd.getName() + "\"\n");
        str.append(prefix).append("       language=\"" + qmd.getLanguage() + "\"\n");
        if (qmd.isUnique()) {
            str.append(prefix).append("       unique=\"true\"\n");
        }
        if (qmd.getResultClass() != null) {
            str.append(prefix).append("       result-class=\"" + qmd.getResultClass() + "\"\n");
        }
        if (qmd.getFetchPlanName() != null) {
            str.append(prefix).append("       fetch-plan=\"" + qmd.getFetchPlanName() + "\"\n");
        }
        str.append(prefix).append("       unmodifiable=\"" + qmd.isUnmodifiable() + "\">\n");
        str.append(prefix).append(qmd.getQuery()).append("\n");
        this.processExtensions(qmd.getExtensions(), str, prefix, indent);
        str.append(prefix + "</query>\n");
        return str.toString();
    }

    public String getXMLForMetaData(FetchGroupMetaData fgmd, String prefix, String indent) {
        Set members;
        StringBuilder str = new StringBuilder();
        str.append(prefix).append("<fetch-group name=\"" + fgmd.getName() + "\">\n");
        Set fetchGroups = fgmd.getFetchGroups();
        if (fetchGroups != null) {
            for (FetchGroupMetaData subfgmd : fetchGroups) {
                str.append(this.getXMLForMetaData(subfgmd, prefix + indent, indent));
            }
        }
        if ((members = fgmd.getMembers()) != null) {
            for (FetchGroupMemberMetaData fgmmd : members) {
                str.append(this.getXMLForMetaData(fgmmd, prefix + indent, indent));
            }
        }
        str.append(prefix + "</fetch-group>\n");
        return str.toString();
    }

    public String getXMLForMetaData(FetchGroupMemberMetaData fgmmd, String prefix, String indent) {
        StringBuilder sb = new StringBuilder();
        if (fgmmd.isProperty()) {
            sb.append(prefix).append("<property ");
        } else {
            sb.append(prefix).append("<field ");
        }
        if (fgmmd.getRecursionDepth() != 1) {
            sb.append("name=\"" + fgmmd.getName() + "\" recursion-depth=\"" + fgmmd.getRecursionDepth() + "\"/>\n");
        } else {
            sb.append("name=\"" + fgmmd.getName() + "\"/>\n");
        }
        return sb.toString();
    }

    public String getXMLForMetaData(AbstractMemberMetaData mmd, String prefix, String indent) {
        ColumnMetaData[] columnMetaData;
        PropertyMetaData propmd;
        String[] fieldTypes;
        if (mmd.isStatic() || mmd.isFinal()) {
            return "";
        }
        boolean field = mmd instanceof FieldMetaData;
        StringBuilder str = new StringBuilder();
        if (field) {
            str.append(prefix).append("<field name=\"" + mmd.getName() + "\"");
        } else {
            str.append(prefix).append("<property name=\"" + mmd.getName() + "\"");
        }
        if (mmd.getPersistenceModifier() != null && !StringUtils.isWhitespace((String)mmd.getPersistenceModifier().toString())) {
            str.append("\n").append(prefix).append("       persistence-modifier=\"" + mmd.getPersistenceModifier() + "\"");
        }
        if (!StringUtils.isWhitespace((String)mmd.getTable())) {
            str.append("\n").append(prefix).append("       table=\"" + mmd.getTable() + "\"");
        }
        if (mmd.isPrimaryKey()) {
            str.append("\n").append(prefix).append("       primary-key=\"" + mmd.isPrimaryKey() + "\"");
        }
        str.append("\n").append(prefix).append("       null-value=\"" + mmd.getNullValue() + "\"");
        if (mmd.isDefaultFetchGroup()) {
            str.append("\n").append(prefix).append("       default-fetch-group=\"" + mmd.isDefaultFetchGroup() + "\"");
        }
        if (mmd.isEmbedded()) {
            str.append("\n").append(prefix).append("       embedded=\"" + mmd.isEmbedded() + "\"");
        }
        if (mmd.isSerialized()) {
            str.append("\n").append(prefix).append("       serialized=\"" + mmd.isSerialized() + "\"");
        }
        if (mmd.isDependent()) {
            str.append("\n").append(prefix).append("       dependent=\"" + mmd.isDependent() + "\"");
        }
        if (mmd.getMappedBy() != null) {
            str.append("\n").append(prefix).append("       mapped-by=\"" + mmd.getMappedBy() + "\"");
        }
        if ((fieldTypes = mmd.getFieldTypes()) != null) {
            str.append("\n").append(prefix).append("       field-type=\"");
            for (int i = 0; i < fieldTypes.length; ++i) {
                str.append(fieldTypes[i]);
            }
            str.append("\"");
        }
        if (!StringUtils.isWhitespace((String)mmd.getLoadFetchGroup())) {
            str.append("\n").append(prefix).append("       load-fetch-group=\"" + mmd.getLoadFetchGroup() + "\"");
        }
        if (mmd.getRecursionDepth() != 1 && mmd.getRecursionDepth() != 0) {
            str.append("\n").append(prefix).append("       recursion-depth=\"" + mmd.getRecursionDepth() + "\"");
        }
        if (mmd.getValueStrategy() != null) {
            str.append("\n").append(prefix).append("       value-strategy=\"" + mmd.getValueStrategy() + "\"");
        }
        if (mmd.getSequence() != null) {
            str.append("\n").append(prefix).append("       sequence=\"" + mmd.getSequence() + "\"");
        }
        if (!field && (propmd = (PropertyMetaData)mmd).getFieldName() != null) {
            str.append("\n").append(prefix).append("       field-name=\"" + propmd.getFieldName() + "\"");
        }
        if (mmd.getIndexMetaData() == null && mmd.getIndexed() != null) {
            str.append("\n").append(prefix).append("       indexed=\"" + mmd.getIndexed() + "\"");
        }
        if (mmd.getUniqueMetaData() == null) {
            str.append("\n").append(prefix).append("       unique=\"" + mmd.isUnique() + "\"");
        }
        str.append(">\n");
        ContainerMetaData contmd = mmd.getContainer();
        if (contmd != null) {
            CollectionMetaData c;
            if (contmd instanceof CollectionMetaData) {
                c = (CollectionMetaData)contmd;
                str.append(this.getXMLForMetaData(c, prefix + indent, indent));
            } else if (contmd instanceof ArrayMetaData) {
                c = (ArrayMetaData)contmd;
                str.append(this.getXMLForMetaData((ArrayMetaData)c, prefix + indent, indent));
            } else if (contmd instanceof MapMetaData) {
                c = (MapMetaData)contmd;
                str.append(this.getXMLForMetaData((MapMetaData)c, prefix + indent, indent));
            }
        }
        if ((columnMetaData = mmd.getColumnMetaData()) != null) {
            for (int i = 0; i < columnMetaData.length; ++i) {
                str.append(this.getXMLForMetaData(columnMetaData[i], prefix + indent, indent));
            }
        }
        if (mmd.getJoinMetaData() != null) {
            str.append(this.getXMLForMetaData(mmd.getJoinMetaData(), prefix + indent, indent));
        }
        if (mmd.getElementMetaData() != null) {
            str.append(this.getXMLForMetaData(mmd.getElementMetaData(), prefix + indent, indent));
        }
        if (mmd.getKeyMetaData() != null) {
            str.append(this.getXMLForMetaData(mmd.getKeyMetaData(), prefix + indent, indent));
        }
        if (mmd.getValueMetaData() != null) {
            str.append(this.getXMLForMetaData(mmd.getValueMetaData(), prefix + indent, indent));
        }
        if (mmd.getOrderMetaData() != null) {
            str.append(this.getXMLForMetaData(mmd.getOrderMetaData(), prefix + indent, indent));
        }
        if (mmd.getEmbeddedMetaData() != null) {
            str.append(this.getXMLForMetaData(mmd.getEmbeddedMetaData(), prefix + indent, indent));
        }
        if (mmd.getIndexMetaData() != null) {
            str.append(this.getXMLForMetaData(mmd.getIndexMetaData(), prefix + indent, indent));
        }
        if (mmd.getUniqueMetaData() != null) {
            str.append(this.getXMLForMetaData(mmd.getUniqueMetaData(), prefix + indent, indent));
        }
        if (mmd.getForeignKeyMetaData() != null) {
            str.append(this.getXMLForMetaData(mmd.getForeignKeyMetaData(), prefix + indent, indent));
        }
        this.processExtensions(mmd.getExtensions(), str, prefix, indent);
        if (field) {
            str.append(prefix).append("</field>\n");
        } else {
            str.append(prefix).append("</property>\n");
        }
        return str.toString();
    }

    public String getXMLForMetaData(EmbeddedMetaData embmd, String prefix, String indent) {
        AbstractMemberMetaData[] members;
        StringBuilder str = new StringBuilder();
        str.append(prefix).append("<embedded");
        if (embmd.getOwnerMember() != null) {
            str.append(" owner-field=\"" + embmd.getOwnerMember() + "\"");
        }
        if (embmd.getNullIndicatorColumn() != null) {
            str.append(" null-indicator-column=\"" + embmd.getNullIndicatorColumn() + "\"");
        }
        if (embmd.getNullIndicatorValue() != null) {
            str.append(" null-indicator-value=\"" + embmd.getNullIndicatorValue() + "\"");
        }
        str.append(">\n");
        if (embmd.getDiscriminatorMetaData() != null) {
            str.append(this.getXMLForMetaData(embmd.getDiscriminatorMetaData(), prefix + indent, indent));
        }
        if ((members = embmd.getMemberMetaData()) != null) {
            for (int i = 0; i < members.length; ++i) {
                str.append(this.getXMLForMetaData(members[i], prefix + indent, indent));
            }
        }
        this.processExtensions(embmd.getExtensions(), str, prefix, indent);
        str.append(prefix + "</embedded>\n");
        return str.toString();
    }

    public String getXMLForMetaData(ElementMetaData elemmd, String prefix, String indent) {
        StringBuilder str = new StringBuilder();
        str.append(prefix).append("<element");
        if (elemmd.getMappedBy() != null) {
            str.append(" mapped-by=\"" + elemmd.getMappedBy() + "\"");
        }
        if (!StringUtils.isWhitespace((String)elemmd.getTable())) {
            str.append(" table=\"" + elemmd.getTable() + "\"");
        }
        if (!StringUtils.isWhitespace((String)elemmd.getColumnName())) {
            str.append(" column=\"" + elemmd.getColumnName() + "\"");
        }
        str.append(">\n");
        ColumnMetaData[] columns = elemmd.getColumnMetaData();
        if (columns != null) {
            for (ColumnMetaData colmd : columns) {
                str.append(this.getXMLForMetaData(colmd, prefix + indent, indent));
            }
        }
        if (elemmd.getIndexMetaData() != null) {
            str.append(this.getXMLForMetaData(elemmd.getIndexMetaData(), prefix + indent, indent));
        }
        if (elemmd.getUniqueMetaData() != null) {
            str.append(this.getXMLForMetaData(elemmd.getUniqueMetaData(), prefix + indent, indent));
        }
        if (elemmd.getEmbeddedMetaData() != null) {
            str.append(this.getXMLForMetaData(elemmd.getEmbeddedMetaData(), prefix + indent, indent));
        }
        if (elemmd.getForeignKeyMetaData() != null) {
            str.append(this.getXMLForMetaData(elemmd.getForeignKeyMetaData(), prefix + indent, indent));
        }
        this.processExtensions(elemmd.getExtensions(), str, prefix, indent);
        str.append(prefix).append("</element>\n");
        return str.toString();
    }

    public String getXMLForMetaData(KeyMetaData keymd, String prefix, String indent) {
        StringBuilder str = new StringBuilder();
        str.append(prefix).append("<key");
        if (keymd.getMappedBy() != null) {
            str.append(" mapped-by=\"" + keymd.getMappedBy() + "\"");
        }
        if (!StringUtils.isWhitespace((String)keymd.getTable())) {
            str.append(" table=\"" + keymd.getTable() + "\"");
        }
        if (!StringUtils.isWhitespace((String)keymd.getColumnName())) {
            str.append(" column=\"" + keymd.getColumnName() + "\"");
        }
        str.append(">\n");
        ColumnMetaData[] columns = keymd.getColumnMetaData();
        if (columns != null) {
            for (ColumnMetaData colmd : columns) {
                str.append(this.getXMLForMetaData(colmd, prefix + indent, indent));
            }
        }
        if (keymd.getIndexMetaData() != null) {
            str.append(this.getXMLForMetaData(keymd.getIndexMetaData(), prefix + indent, indent));
        }
        if (keymd.getUniqueMetaData() != null) {
            str.append(this.getXMLForMetaData(keymd.getUniqueMetaData(), prefix + indent, indent));
        }
        if (keymd.getEmbeddedMetaData() != null) {
            str.append(this.getXMLForMetaData(keymd.getEmbeddedMetaData(), prefix + indent, indent));
        }
        if (keymd.getForeignKeyMetaData() != null) {
            str.append(this.getXMLForMetaData(keymd.getForeignKeyMetaData(), prefix + indent, indent));
        }
        this.processExtensions(keymd.getExtensions(), str, prefix, indent);
        str.append(prefix).append("</key>\n");
        return str.toString();
    }

    public String getXMLForMetaData(ValueMetaData valmd, String prefix, String indent) {
        StringBuilder str = new StringBuilder();
        str.append(prefix).append("<value");
        if (valmd.getMappedBy() != null) {
            str.append(" mapped-by=\"" + valmd.getMappedBy() + "\"");
        }
        if (!StringUtils.isWhitespace((String)valmd.getTable())) {
            str.append(" table=\"" + valmd.getTable() + "\"");
        }
        if (!StringUtils.isWhitespace((String)valmd.getColumnName())) {
            str.append(" column=\"" + valmd.getColumnName() + "\"");
        }
        str.append(">\n");
        ColumnMetaData[] columns = valmd.getColumnMetaData();
        if (columns != null) {
            for (ColumnMetaData colmd : columns) {
                str.append(this.getXMLForMetaData(colmd, prefix + indent, indent));
            }
        }
        if (valmd.getIndexMetaData() != null) {
            str.append(this.getXMLForMetaData(valmd.getIndexMetaData(), prefix + indent, indent));
        }
        if (valmd.getUniqueMetaData() != null) {
            str.append(this.getXMLForMetaData(valmd.getUniqueMetaData(), prefix + indent, indent));
        }
        if (valmd.getEmbeddedMetaData() != null) {
            str.append(this.getXMLForMetaData(valmd.getEmbeddedMetaData(), prefix + indent, indent));
        }
        if (valmd.getForeignKeyMetaData() != null) {
            str.append(this.getXMLForMetaData(valmd.getForeignKeyMetaData(), prefix + indent, indent));
        }
        this.processExtensions(valmd.getExtensions(), str, prefix, indent);
        str.append(prefix).append("</value>\n");
        return str.toString();
    }

    public String getXMLForMetaData(OrderMetaData ordermd, String prefix, String indent) {
        StringBuilder str = new StringBuilder();
        str.append(prefix).append("<order");
        if (ordermd.getColumnName() != null) {
            str.append(" column=\"" + ordermd.getColumnName() + "\"");
        }
        if (ordermd.getIndexed() != null) {
            str.append(" indexed=\"" + ordermd.getIndexed() + "\"");
        }
        if (ordermd.getMappedBy() != null) {
            str.append(" mapped-by=\"" + ordermd.getMappedBy() + "\"");
        }
        str.append(">\n");
        ColumnMetaData[] columns = ordermd.getColumnMetaData();
        if (columns != null) {
            for (int i = 0; i < columns.length; ++i) {
                str.append(this.getXMLForMetaData(columns[i], prefix + indent, indent));
            }
        }
        if (ordermd.getIndexMetaData() != null) {
            str.append(this.getXMLForMetaData(ordermd.getIndexMetaData(), prefix + indent, indent));
        }
        this.processExtensions(ordermd.getExtensions(), str, prefix, indent);
        str.append(prefix).append("</order>\n");
        return str.toString();
    }

    public String getXMLForMetaData(CollectionMetaData collmd, String prefix, String indent) {
        StringBuilder str = new StringBuilder();
        str.append(prefix).append("<collection element-type=\"").append(collmd.getElementType()).append("\"");
        if (collmd.isEmbeddedElement()) {
            str.append(" embedded-element=\"").append(collmd.isEmbeddedElement()).append("\"");
        }
        if (collmd.isDependentElement()) {
            str.append(" dependent-element=\"").append(collmd.isDependentElement()).append("\"");
        }
        if (collmd.isSerializedElement()) {
            str.append(" serialized-element=\"").append(collmd.isSerializedElement()).append("\"");
        }
        str.append(">\n");
        this.processExtensions(collmd.getExtensions(), str, prefix, indent);
        str.append(prefix).append("</collection>\n");
        return str.toString();
    }

    public String getXMLForMetaData(MapMetaData mapmd, String prefix, String indent) {
        StringBuilder str = new StringBuilder();
        str.append(prefix).append("<map key-type=\"").append(mapmd.getKeyType()).append("\" value-type=\"").append(mapmd.getValueType()).append("\"");
        if (mapmd.isEmbeddedKey()) {
            str.append(" embedded-key=\"").append(mapmd.isEmbeddedKey()).append("\"");
        }
        if (mapmd.isEmbeddedValue()) {
            str.append(" embedded-value=\"").append(mapmd.isEmbeddedValue()).append("\"");
        }
        if (mapmd.isDependentKey()) {
            str.append(" dependent-key=\"").append(mapmd.isDependentKey()).append("\"");
        }
        if (mapmd.isDependentValue()) {
            str.append(" dependent-value=\"").append(mapmd.isDependentValue()).append("\"");
        }
        if (mapmd.isSerializedKey()) {
            str.append(" serialized-key=\"").append(mapmd.isSerializedKey()).append("\"");
        }
        if (mapmd.isSerializedValue()) {
            str.append(" serialized-value=\"").append(mapmd.isSerializedValue()).append("\"");
        }
        str.append(">\n");
        this.processExtensions(mapmd.getExtensions(), str, prefix, indent);
        str.append(prefix).append("</map>\n");
        return str.toString();
    }

    public String getXMLForMetaData(ArrayMetaData arrmd, String prefix, String indent) {
        Map extensions;
        StringBuilder str = new StringBuilder();
        str.append(prefix).append("<array");
        if (arrmd.getElementType() != null) {
            str.append(" element-type=\"").append(arrmd.getElementType()).append("\"");
        }
        if (arrmd.isEmbeddedElement()) {
            str.append(" embedded-element=\"").append(arrmd.isEmbeddedElement()).append("\"");
        }
        if (arrmd.isSerializedElement()) {
            str.append(" serialized-element=\"").append(arrmd.isSerializedElement()).append("\"");
        }
        if (arrmd.isDependentElement()) {
            str.append(" dependent-element=\"").append(arrmd.isDependentElement()).append("\"");
        }
        if ((extensions = arrmd.getExtensions()) != null) {
            str.append(">\n");
            this.processExtensions(extensions, str, prefix, indent);
            str.append(prefix).append("</array>\n");
        } else {
            str.append(prefix).append("/>\n");
        }
        return str.toString();
    }

    public String getXMLForMetaData(PackageMetaData pmd, String prefix, String indent) {
        SequenceMetaData[] seqmds;
        int i;
        StringBuilder str = new StringBuilder();
        str.append(prefix).append("<package name=\"" + pmd.getName() + "\"");
        if (pmd.getCatalog() != null) {
            str.append(" catalog=\"" + pmd.getCatalog() + "\"");
        }
        if (pmd.getSchema() != null) {
            str.append(" schema=\"" + pmd.getSchema() + "\"");
        }
        str.append(">\n");
        if (pmd.getNoOfInterfaces() > 0) {
            for (i = 0; i < pmd.getNoOfInterfaces(); ++i) {
                InterfaceMetaData imd = pmd.getInterface(i);
                str.append(this.getXMLForMetaData((AbstractClassMetaData)imd, prefix + indent, indent));
            }
        }
        if (pmd.getNoOfClasses() > 0) {
            for (i = 0; i < pmd.getNoOfClasses(); ++i) {
                ClassMetaData cmd = pmd.getClass(i);
                str.append(this.getXMLForMetaData((AbstractClassMetaData)cmd, prefix + indent, indent));
            }
        }
        if ((seqmds = pmd.getSequences()) != null) {
            for (SequenceMetaData seqmd : seqmds) {
                str.append(this.getXMLForMetaData(seqmd, prefix + indent, indent));
            }
        }
        this.processExtensions(pmd.getExtensions(), str, prefix, indent);
        str.append(prefix).append("</package>\n");
        return str.toString();
    }

    public String getXMLForMetaData(SequenceMetaData seqmd, String prefix, String indent) {
        StringBuilder str = new StringBuilder();
        str.append(prefix).append("<sequence name=\"" + seqmd.getName() + "\"");
        if (seqmd.getDatastoreSequence() != null) {
            str.append(" datastore-sequence=\"" + seqmd.getDatastoreSequence() + "\"");
        }
        if (seqmd.getFactoryClass() != null) {
            str.append(" factory-class=\"" + seqmd.getFactoryClass() + "\"");
        }
        if (seqmd.getInitialValue() >= 0) {
            str.append(" initial-value=\"" + seqmd.getInitialValue() + "\"");
        }
        if (seqmd.getAllocationSize() >= 0) {
            str.append(" allocation-size=\"" + seqmd.getAllocationSize() + "\"");
        }
        if (seqmd.getStrategy() != null) {
            str.append(" strategy=\"" + seqmd.getStrategy() + "\">");
        }
        str.append(">\n");
        this.processExtensions(seqmd.getExtensions(), str, prefix, indent);
        str.append(prefix + "</sequence>\n");
        return str.toString();
    }

    public String getXMLForMetaData(FileMetaData filemd, String prefix, String indent) {
        FetchPlanMetaData[] fetchPlans;
        PackageMetaData queries;
        StringBuilder str = new StringBuilder();
        str.append(prefix).append("<jdo");
        if (filemd.getCatalog() != null) {
            str.append(" catalog=\"" + filemd.getCatalog() + "\"");
        }
        if (filemd.getSchema() != null) {
            str.append(" schema=\"" + filemd.getSchema() + "\"");
        }
        str.append(">\n");
        if (filemd.getNoOfPackages() > 0) {
            for (int i = 0; i < filemd.getNoOfPackages(); ++i) {
                PackageMetaData pmd = filemd.getPackage(i);
                str.append(this.getXMLForMetaData(pmd, prefix + indent, indent));
            }
        }
        if ((queries = filemd.getQueries()) != null) {
            for (PackageMetaData qmd : queries) {
                str.append(this.getXMLForMetaData((QueryMetaData)qmd, prefix + indent, indent));
            }
        }
        if ((fetchPlans = filemd.getFetchPlans()) != null) {
            for (FetchPlanMetaData fpmd : fetchPlans) {
                str.append(this.getXMLForMetaData(fpmd, prefix + indent, indent));
            }
        }
        this.processExtensions(filemd.getExtensions(), str, prefix, indent);
        str.append("</jdo>");
        return str.toString();
    }

    protected void processExtensions(Map<String, String> extensions, StringBuilder str, String prefix, String indent) {
        if (extensions != null) {
            for (Map.Entry<String, String> entry : extensions.entrySet()) {
                str.append(this.getXMLForMetaData(entry.getKey(), entry.getValue(), prefix + indent, indent)).append("\n");
            }
        }
    }

    public String getXMLForMetaData(FetchPlanMetaData fpmd, String prefix, String indent) {
        StringBuilder str = new StringBuilder();
        str.append(prefix).append("<fetch-plan name=\"" + fpmd.getName() + "\" max-fetch-depth=\"" + fpmd.getMaxFetchDepth() + "\" fetch-size=\"" + fpmd.getFetchSize() + "\">\n");
        FetchGroupMetaData[] fetchGroups = fpmd.getFetchGroupMetaData();
        if (fetchGroups != null) {
            for (FetchGroupMetaData fgmd : fetchGroups) {
                str.append(this.getXMLForMetaData(fgmd, prefix + indent, indent));
            }
        }
        str.append(prefix + "</fetch-plan>\n");
        return str.toString();
    }

    public String getXMLForMetaData(String key, String value, String prefix, String indent) {
        StringBuilder str = new StringBuilder();
        str.append(prefix).append("<extension vendor-name=\"").append("datanucleus").append("\" ").append("key=\"").append(key).append("\" ").append("value=\"").append(value).append("\"/>");
        return str.toString();
    }
}

