/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo;

import java.util.Iterator;
import javax.jdo.FetchPlan;
import javax.jdo.PersistenceManager;
import org.datanucleus.api.jdo.JDOFetchPlan;
import org.datanucleus.store.Extent;

public class JDOExtent<E>
implements javax.jdo.Extent<E> {
    private boolean closed = false;
    PersistenceManager pm;
    Extent<E> extent;
    JDOFetchPlan fetchPlan = null;

    public JDOExtent(PersistenceManager pm, Extent extent) {
        this.pm = pm;
        this.extent = extent;
        this.fetchPlan = new JDOFetchPlan(extent.getFetchPlan());
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closeAll();
        this.fetchPlan.clearGroups();
        this.fetchPlan = null;
        this.extent = null;
        this.pm = null;
        this.closed = true;
    }

    public void close(Iterator<E> iterator) {
        this.extent.close(iterator);
    }

    public void closeAll() {
        this.extent.closeAll();
    }

    public Class<E> getCandidateClass() {
        return this.extent.getCandidateClass();
    }

    public boolean hasSubclasses() {
        return this.extent.hasSubclasses();
    }

    public FetchPlan getFetchPlan() {
        return this.fetchPlan;
    }

    public PersistenceManager getPersistenceManager() {
        return this.pm;
    }

    public Extent<E> getExtent() {
        return this.extent;
    }

    public Iterator<E> iterator() {
        return this.extent.iterator();
    }
}

