/*
 * Copyright (C) 2004-2014 Volker Bergmann (volker.bergmann@bergmann-it.de).
 * All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.databene.commons.ui;

/**
 * Platform-independent abstraction of a progress monitor.<br/>
 * <br/>
 * Created at 14.12.2008 20:29:28
 * @since 0.4.7
 * @author Volker Bergmann
 */

public interface ProgressMonitor {

	int getMaximum();
	void setMaximum(int i);

	int getProgress();
	void setProgress(int i);

	void setNote(String note);

	void advance();

	boolean isCanceled();
}
