/*
 * Copyright (C) 2004-2014 Volker Bergmann (volker.bergmann@bergmann-it.de).
 * All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.databene.commons.tree;

/**
 * Defines a contract of mapping arbitrary objects to a parent/child structure.<br/>
 * <br/>
 * Created: 31.07.2007 06:32:11
 * @author Volker Bergmann
 */
public interface ChildModel<I, V> {
    I getId(V element);
    I getParentId(V child);
}
