/*
 * Copyright (C) 2004-2014 Volker Bergmann (volker.bergmann@bergmann-it.de).
 * All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.databene.commons.converter;

import org.databene.commons.ConversionException;

import java.sql.Timestamp;
import java.util.Date;

/**
 * Converts {@link Date} to {@link Timestamp} Objects.<br/>
 * <br/>
 * Created: 28.11.2007 20:07:16
 * @author Volker Bergmann
 * @since 0.2.04
 */
public class Date2TimestampConverter extends ThreadSafeConverter<Date, Timestamp> {

    public Date2TimestampConverter() {
        super(Date.class, Timestamp.class);
    }

    @Override
	public Timestamp convert(Date sourceValue) throws ConversionException {
        return new Timestamp(sourceValue.getTime());
    }

}
