/*
 * Copyright (C) 2004-2014 Volker Bergmann (volker.bergmann@bergmann-it.de).
 * All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.databene.commons.collection;

import java.util.Map;

import org.databene.commons.OrderedMap;

/**
 * {@link OrderedMap} implementation which assigns names to objects.<br/><br/>
 * Created: 12.12.2012 11:04:02
 * @since 0.5.21
 * @author Volker Bergmann
 */
public class CaseSensitiveOrderedNameMap<E> extends OrderedMap<String, E> {
	
    private static final long serialVersionUID = -7129079585162733858L;

	public CaseSensitiveOrderedNameMap() {
	}
    
    public CaseSensitiveOrderedNameMap(Map<String, E> that) {
		super(that);
	}

}
