/*
 * Copyright (C) 2004-2014 Volker Bergmann (volker.bergmann@bergmann-it.de).
 * All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.databene.commons.bean;

import org.databene.commons.mutator.NamedMutator;

/**
 * Creates PropertyMutator objects by availability of 
 * bean class name and/or property name and/or property type.<br/>
 * <br/>
 * Created: 13.05.2005 09:26:14
 * @since 0.1
 * @author Volker Bergmann
 */
public class PropertyMutatorFactory {

    public static NamedMutator getPropertyMutator(String propertyName) {
        return getPropertyMutator(null, propertyName, true, true);
    }

    public static NamedMutator getPropertyMutator(Class<?> beanClass, String propertyName) {
        return getPropertyMutator(beanClass, propertyName, true, false);
    }

    public static NamedMutator getPropertyMutator(Class<?> beanClass, String propertyName, boolean required, boolean autoConvert) {
        if (propertyName.contains("."))
            return new PropertyGraphMutator(beanClass, propertyName, required, autoConvert);
        else if (beanClass != null)
            return new TypedPropertyMutator(beanClass, propertyName, required, autoConvert);
        else
            return new UntypedPropertyMutator(propertyName, required, autoConvert);
    }

}
