/*
 * Copyright (C) 2004-2014 Volker Bergmann (volker.bergmann@bergmann-it.de).
 * All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.databene.commons.bean;

import org.databene.commons.mutator.NamedMutator;

/**
 * Abstraction of a Mutator to which a name is assigned.<br/>
 * <br/>
 * Created at 04.11.2008 09:20:51
 * @since 0.4.6
 * @author Volker Bergmann
 */
public abstract class AbstractNamedMutator implements NamedMutator {

    protected String name;

    protected AbstractNamedMutator(String name) {
        this.name = name;
    }

    @Override
	public String getName() {
        return name;
    }
    
}
