/*
 * Decompiled with CFR 0.152.
 */
package org.danilopianini.gradle.git.hooks;

import java.io.File;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.danilopianini.gradle.git.hooks.CommitMsgScriptContext;
import org.danilopianini.gradle.git.hooks.CommonScriptContext;
import org.danilopianini.gradle.git.hooks.GitHooksExtension;
import org.danilopianini.gradle.git.hooks.ScriptContext;
import org.gradle.api.initialization.Settings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000  2\u00020\u0001:\u0001 B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\u0010\u001a\u00020\u00112\u0017\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00110\u0013\u00a2\u0006\u0002\b\u0015J\u0010\u0010\u0016\u001a\u00020\u00112\b\b\u0002\u0010\u0017\u001a\u00020\u0018J9\u0010\u0019\u001a\u00020\u0011\"\b\b\u0000\u0010\u001a*\u00020\u001b2\u0006\u0010\u001c\u001a\u0002H\u001a2\u0017\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u00020\u00110\u0013\u00a2\u0006\u0002\b\u0015H\u0082\b\u00a2\u0006\u0002\u0010\u001dJ'\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00072\u0017\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00110\u0013\u00a2\u0006\u0002\b\u0015J\u001f\u0010\u001f\u001a\u00020\u00112\u0017\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00110\u0013\u00a2\u0006\u0002\b\u0015R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0004\u0018\u00010\t8FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Lorg/danilopianini/gradle/git/hooks/GitHooksExtension;", "Ljava/io/Serializable;", "settings", "Lorg/gradle/api/initialization/Settings;", "(Lorg/gradle/api/initialization/Settings;)V", "hooks", "", "", "path", "Ljava/io/File;", "getPath", "()Ljava/io/File;", "setPath", "(Ljava/io/File;)V", "getSettings", "()Lorg/gradle/api/initialization/Settings;", "commitMsg", "", "configuration", "Lkotlin/Function1;", "Lorg/danilopianini/gradle/git/hooks/CommitMsgScriptContext;", "Lkotlin/ExtensionFunctionType;", "createHooks", "overwriteExisting", "", "hook", "H", "Lorg/danilopianini/gradle/git/hooks/ScriptContext;", "context", "(Lorg/danilopianini/gradle/git/hooks/ScriptContext;Lkotlin/jvm/functions/Function1;)V", "hookName", "preCommit", "Companion", "gradle-pre-commit-git-hooks"})
public class GitHooksExtension
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Settings settings;
    @NotNull
    private Map<String, String> hooks;
    @Nullable
    private File path;
    private static final long serialVersionUID = 1L;
    @NotNull
    public static final String name = "gitHooks";

    public GitHooksExtension(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.settings = settings;
        this.hooks = MapsKt.emptyMap();
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @Nullable
    public final File getPath() {
        File file = this.path;
        if (file == null) {
            Object v1;
            Sequence sequence;
            block3: {
                Sequence sequence2 = sequence = SequencesKt.generateSequence((Object)this.settings.getSettingsDir(), (Function1)path.1.INSTANCE);
                for (Object e : sequence2) {
                    File it = (File)e;
                    boolean bl = false;
                    if (!GitHooksExtension.Companion.isGitRoot(it)) continue;
                    v1 = e;
                    break block3;
                }
                v1 = null;
            }
            Sequence sequence3 = sequence = v1;
            if (sequence3 == null) {
                boolean bl = false;
                String string = "No git root could be found in " + this.settings.getSettingsDir().getAbsolutePath() + " or any of its parent directories";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            file = (File)sequence3;
        }
        return file;
    }

    public final void setPath(@Nullable File file) {
        this.path = file;
    }

    private final <H extends ScriptContext> void hook(H context, Function1<? super H, Unit> configuration) {
        boolean bl;
        boolean $i$f$hook = false;
        boolean bl2 = bl = !this.hooks.containsKey(context.getName());
        if (!bl) {
            boolean bl3 = false;
            String string = "it looks like the hook " + context.getName() + " is being defined twice";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String string = context.getName();
        H h = context;
        configuration.invoke(h);
        this.hooks = MapsKt.plus(this.hooks, (Pair)TuplesKt.to((Object)string, (Object)h.getScript()));
    }

    /*
     * WARNING - void declaration
     */
    public final void hook(@NotNull String hookName, @NotNull Function1<? super ScriptContext, Unit> configuration) {
        void this_$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)hookName, (String)"hookName");
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        GitHooksExtension gitHooksExtension = this;
        ScriptContext context$iv = new CommonScriptContext(hookName);
        boolean $i$f$hook = false;
        boolean bl2 = bl = !this_$iv.hooks.containsKey(context$iv.getName());
        if (!bl) {
            boolean bl3 = false;
            String string = "it looks like the hook " + context$iv.getName() + " is being defined twice";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Map<String, String> map = this_$iv.hooks;
        String string = context$iv.getName();
        ScriptContext scriptContext = context$iv;
        configuration.invoke((Object)scriptContext);
        this_$iv.hooks = MapsKt.plus(map, (Pair)TuplesKt.to((Object)string, (Object)scriptContext.getScript()));
    }

    public final void preCommit(@NotNull Function1<? super ScriptContext, Unit> configuration) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        this.hook("pre-commit", configuration);
    }

    /*
     * WARNING - void declaration
     */
    public final void commitMsg(@NotNull Function1<? super CommitMsgScriptContext, Unit> configuration) {
        void this_$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        GitHooksExtension gitHooksExtension = this;
        ScriptContext context$iv = new CommitMsgScriptContext();
        boolean $i$f$hook = false;
        boolean bl2 = bl = !this_$iv.hooks.containsKey(context$iv.getName());
        if (!bl) {
            boolean bl3 = false;
            String string = "it looks like the hook " + context$iv.getName() + " is being defined twice";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Map<String, String> map = this_$iv.hooks;
        String string = context$iv.getName();
        ScriptContext scriptContext = context$iv;
        configuration.invoke((Object)scriptContext);
        this_$iv.hooks = MapsKt.plus(map, (Pair)TuplesKt.to((Object)string, (Object)scriptContext.getScript()));
    }

    public final void createHooks(boolean overwriteExisting) {
        File file;
        File file2;
        File file3 = this.getPath();
        if (file3 != null) {
            File file4;
            File it = file4 = file3;
            boolean bl = false;
            file2 = GitHooksExtension.Companion.isGitRoot(it) ? file4 : null;
        } else {
            file2 = null;
        }
        File file5 = file = file2;
        if (file5 == null) {
            boolean $i$a$-requireNotNull-GitHooksExtension$createHooks$root$32 = false;
            File file6 = this.getPath();
            String $i$a$-requireNotNull-GitHooksExtension$createHooks$root$32 = (file6 != null ? file6.getAbsolutePath() : null) + " is not a valid git root";
            throw (Throwable)new IllegalArgumentException($i$a$-requireNotNull-GitHooksExtension$createHooks$root$32.toString());
        }
        File root = file5;
        Map<String, String> $this$forEach$iv = this.hooks;
        boolean $i$f$forEach = false;
        Map<String, String> map = $this$forEach$iv;
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            String name = entry.getKey();
            String script = entry.getValue();
            File hook = new File(root.getAbsolutePath(), "/.git/hooks/" + name);
            if (!hook.exists()) {
                boolean bl2 = hook.createNewFile();
                if (!bl2) {
                    boolean bl3 = false;
                    String string = "Cannot create file " + hook.getAbsolutePath();
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                GitHooksExtension.Companion.writeScript(hook, script);
                continue;
            }
            String oldScript = FilesKt.readText$default((File)hook, null, (int)1, null);
            if (Intrinsics.areEqual((Object)oldScript, (Object)script)) continue;
            String string = CollectionsKt.joinToString$default((Iterable)StringsKt.lines((CharSequence)StringsKt.trimMargin$default((String)("\n                        |The hook " + name + " exists, but its content differs from the one generated by the git-hooks plugin.\n                        |\n                        |Original content:\n                        " + GitHooksExtension.Companion.withMargins(oldScript) + "\n                        |\n                        |New content:\n                        " + GitHooksExtension.Companion.withMargins(script) + "\n                        "), null, (int)1, null)), (CharSequence)"\n", null, null, (int)0, null, (Function1)createHooks.1.2.INSTANCE, (int)30, null);
            System.out.println((Object)string);
            if (!overwriteExisting) continue;
            string = "WARNING: Overwriting git hook " + name;
            System.out.println((Object)string);
            GitHooksExtension.Companion.writeScript(hook, script);
        }
    }

    public static /* synthetic */ void createHooks$default(GitHooksExtension gitHooksExtension, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createHooks");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        gitHooksExtension.createHooks(bl);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0002J\f\u0010\n\u001a\u00020\u0004*\u00020\u0004H\u0002J\u0014\u0010\u000b\u001a\u00020\f*\u00020\t2\u0006\u0010\r\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/danilopianini/gradle/git/hooks/GitHooksExtension$Companion;", "", "()V", "name", "", "serialVersionUID", "", "isGitRoot", "", "Ljava/io/File;", "withMargins", "writeScript", "", "script", "gradle-pre-commit-git-hooks"})
    public static final class Companion {
        private Companion() {
        }

        private final String withMargins(String $this$withMargins) {
            return CollectionsKt.joinToString$default((Iterable)StringsKt.lines((CharSequence)$this$withMargins), (CharSequence)"\n|", (CharSequence)"|", null, (int)0, null, null, (int)60, null);
        }

        private final void writeScript(File $this$writeScript, String script) {
            FilesKt.writeText$default((File)$this$writeScript, (String)script, null, (int)2, null);
            $this$writeScript.setExecutable(true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isGitRoot(File $this$isGitRoot) {
            File[] fileArray = $this$isGitRoot.listFiles();
            if (fileArray == null) return false;
            File[] $this$any$iv = fileArray;
            boolean $i$f$any = false;
            File[] fileArray2 = $this$any$iv;
            int n = fileArray2.length;
            int n2 = 0;
            while (n2 < n) {
                File element$iv;
                File folder = element$iv = fileArray2[n2];
                boolean bl = false;
                if (folder.isDirectory() && Intrinsics.areEqual((Object)folder.getName(), (Object)".git")) {
                    boolean bl2;
                    File[] fileArray3;
                    if (fileArray3 != null) {
                        fileArray3 = folder.listFiles();
                        Intrinsics.checkNotNullExpressionValue((Object)fileArray3, (String)"listFiles()");
                        File[] $this$any$iv2 = fileArray3;
                        boolean $i$f$any2 = false;
                        File[] fileArray4 = $this$any$iv2;
                        int n3 = fileArray4.length;
                        for (int i = 0; i < n3; ++i) {
                            File element$iv2;
                            File it = element$iv2 = fileArray4[i];
                            boolean bl3 = false;
                            if (it.isDirectory() && Intrinsics.areEqual((Object)it.getName(), (Object)"hooks")) {
                                return true;
                            }
                            boolean bl4 = false;
                            if (!bl4) continue;
                            return true;
                        }
                        bl2 = false;
                    } else {
                        bl2 = false;
                    }
                    if (bl2) {
                        return true;
                    }
                }
                boolean bl5 = false;
                if (bl5) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

