/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.braille.css.impl;

import com.google.common.collect.Iterables;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.Rule;
import cz.vutbr.web.css.RuleBlock;
import cz.vutbr.web.css.RulePage;
import cz.vutbr.web.css.Selector;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermFunction;
import cz.vutbr.web.css.TermInteger;
import cz.vutbr.web.css.TermList;
import cz.vutbr.web.css.TermNumber;
import cz.vutbr.web.css.TermPair;
import cz.vutbr.web.css.TermPercent;
import cz.vutbr.web.css.TermString;
import cz.vutbr.web.css.TermURI;
import cz.vutbr.web.csskit.OutputUtil;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.daisy.braille.css.InlineStyle;
import org.daisy.braille.css.PropertyValue;
import org.daisy.braille.css.SimpleInlineStyle;
import org.daisy.common.file.URLs;
import org.daisy.common.stax.XMLStreamWriterHelper;
import org.daisy.pipeline.braille.css.impl.BrailleCssTreeBuilder;

public final class BrailleCssSerializer {
    private static final String XMLNS_CSS = "http://www.daisy.org/ns/pipeline/braille-css";
    private static final QName CSS_RULE = new QName("http://www.daisy.org/ns/pipeline/braille-css", "rule", "css");
    private static final QName CSS_PROPERTY = new QName("http://www.daisy.org/ns/pipeline/braille-css", "property", "css");
    private static final QName SELECTOR = new QName("selector");
    private static final QName STYLE = new QName("style");
    private static final QName NAME = new QName("name");
    private static final QName VALUE = new QName("value");

    private BrailleCssSerializer() {
    }

    public static String toString(Term<?> term) {
        if (term instanceof TermInteger) {
            TermInteger integer = (TermInteger)term;
            return "" + integer.getIntValue();
        }
        if (term instanceof TermNumber) {
            TermNumber number = (TermNumber)term;
            Double value = ((Float)number.getValue()).doubleValue();
            if (value == Math.floor(value)) {
                return "" + value.intValue();
            }
            return "" + value;
        }
        if (term instanceof TermPercent) {
            TermPercent percent = (TermPercent)term;
            Double value = ((Float)percent.getValue()).doubleValue();
            if (value == Math.floor(value)) {
                return "" + value.intValue() + "%";
            }
            return "" + value + "%";
        }
        if (term instanceof TermList || term instanceof Declaration) {
            String s = BrailleCssSerializer.serializeTermList((List)term);
            if (term instanceof TermFunction) {
                TermFunction function = (TermFunction)term;
                s = function.getFunctionName() + "(" + s + ")";
            }
            return s;
        }
        if (term instanceof TermPair) {
            TermPair pair = (TermPair)term;
            Object val = pair.getValue();
            return "" + pair.getKey() + " " + (val instanceof Term ? BrailleCssSerializer.toString((Term)val) : val.toString());
        }
        if (term instanceof TermURI) {
            TermURI termURI = (TermURI)term;
            URI uri = URLs.asURI((String)((String)termURI.getValue()));
            if (termURI.getBase() != null) {
                uri = URLs.resolve((URI)URLs.asURI((URL)termURI.getBase()), (URI)uri);
            }
            return "url(\"" + uri + "\")";
        }
        if (term instanceof TermString) {
            TermString string = (TermString)term;
            return "'" + ((String)string.getValue()).replaceAll("\n", "\\\\A ").replaceAll("'", "\\\\27 ") + "'";
        }
        return term.toString().replaceAll("^[,/ ]+", "");
    }

    public static String toString(Declaration declaration) {
        return declaration.getProperty() + ": " + BrailleCssSerializer.serializeTermList(declaration) + ";";
    }

    public static String toString(BrailleCssTreeBuilder.Style style) {
        return BrailleCssSerializer.toString(style, null);
    }

    private static String toString(BrailleCssTreeBuilder.Style style, String base) {
        StringBuilder b = new StringBuilder();
        StringBuilder rel = new StringBuilder();
        if (style.declarations != null) {
            b.append(BrailleCssSerializer.serializeDeclarationList(style.declarations));
        }
        if (style.nestedStyles != null) {
            for (Map.Entry<String, BrailleCssTreeBuilder.Style> e : style.nestedStyles.entrySet()) {
                if (base != null && e.getKey().startsWith("&")) {
                    if (rel.length() > 0) {
                        rel.append(" ");
                    }
                    rel.append(BrailleCssSerializer.toString(e.getValue(), base + e.getKey().substring(1)));
                    continue;
                }
                if (b.length() > 0) {
                    b.append(" ");
                }
                b.append(BrailleCssSerializer.toString(e.getValue(), e.getKey()));
            }
        }
        if (base != null && b.length() > 0) {
            b.insert(0, base + " { ");
            b.append(" }");
        }
        if (rel.length() > 0) {
            if (b.length() > 0) {
                b.append(" ");
            }
            b.append((CharSequence)rel);
        }
        return b.toString();
    }

    public static String toString(InlineStyle style) {
        return BrailleCssSerializer.toString(BrailleCssTreeBuilder.Style.of(style));
    }

    public static String toString(SimpleInlineStyle style) {
        ArrayList<String> declarations = new ArrayList<String>();
        for (String p : style.getPropertyNames()) {
            declarations.add(p + ": " + BrailleCssSerializer.serializePropertyValue(style.get(p)));
        }
        Collections.sort(declarations);
        StringBuilder s = new StringBuilder();
        Iterator it = declarations.iterator();
        while (it.hasNext()) {
            s.append((String)it.next());
            if (!it.hasNext()) continue;
            s.append("; ");
        }
        return s.toString();
    }

    public static String serializePropertyValue(PropertyValue propValue) {
        Term value = propValue.getValue();
        if (value != null) {
            return BrailleCssSerializer.toString(value);
        }
        return propValue.getProperty().toString();
    }

    public static String toString(InlineStyle.RuleMainBlock rule) {
        return BrailleCssSerializer.serializeDeclarationList((Iterable<Declaration>)rule);
    }

    public static String toString(InlineStyle.RuleRelativeBlock rule) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (Selector s : rule.getSelector()) {
            Selector.Combinator c = s.getCombinator();
            if (first) {
                if (c == null) {
                    b.append("&");
                } else if (c != Selector.Combinator.CHILD) {
                    b.append(c.value());
                }
                first = false;
            } else if (c != null) {
                b.append(c.value());
            }
            b = OutputUtil.appendList((StringBuilder)b, (List)s, (String)"");
        }
        b.append(" { ");
        b.append(BrailleCssSerializer.toString(rule));
        b.append(" }");
        return b.toString();
    }

    public static String toString(RuleBlock<? extends Rule<?>> ruleBlock) {
        StringBuilder b = new StringBuilder();
        b.append(BrailleCssSerializer.serializeDeclarationList(Iterables.filter(ruleBlock, Declaration.class)));
        for (Rule r : ruleBlock) {
            if (r instanceof Declaration) continue;
            if (r instanceof RulePage) {
                b.append(BrailleCssSerializer.toString((RulePage)r));
                continue;
            }
            throw new RuntimeException("not implemented");
        }
        return b.toString();
    }

    public static String toString(RulePage page) {
        return BrailleCssSerializer.toString(new BrailleCssTreeBuilder.Style().add("@page", BrailleCssTreeBuilder.Style.of(page)));
    }

    public static String serializeRuleBlockList(Iterable<? extends RuleBlock<? extends Rule<?>>> ruleBlocks) {
        String b = null;
        for (RuleBlock<Rule<?>> ruleBlock : ruleBlocks) {
            String s = ruleBlock instanceof InlineStyle.RuleMainBlock ? BrailleCssSerializer.toString((InlineStyle.RuleMainBlock)ruleBlock) : (ruleBlock instanceof InlineStyle.RuleRelativeBlock ? BrailleCssSerializer.toString((InlineStyle.RuleRelativeBlock)ruleBlock) : BrailleCssSerializer.toString(ruleBlock));
            if (s.isEmpty()) continue;
            if (b == null) {
                b = s;
                continue;
            }
            if (!b.endsWith("}") && !b.endsWith(";")) {
                b = b + ";";
            }
            b = b + " ";
            b = b + s;
        }
        if (b == null) {
            b = "";
        }
        return b;
    }

    public static String serializeTermList(List<Term<?>> termList) {
        String s = "";
        for (Term<?> t : termList) {
            if (!s.isEmpty()) {
                Term.Operator o = t.getOperator();
                if (o != null) {
                    switch (o) {
                        case COMMA: {
                            s = s + ",";
                        }
                    }
                }
                s = s + " ";
            }
            s = s + BrailleCssSerializer.toString(t);
        }
        return s;
    }

    private static String serializeDeclarationList(Iterable<Declaration> declarations) {
        ArrayList<Declaration> sortedDeclarations = new ArrayList<Declaration>();
        for (Declaration d : declarations) {
            sortedDeclarations.add(d);
        }
        Collections.sort(sortedDeclarations);
        StringBuilder s = new StringBuilder();
        Iterator it = sortedDeclarations.iterator();
        while (it.hasNext()) {
            s.append(BrailleCssSerializer.toString((Declaration)it.next()));
            if (!it.hasNext()) continue;
            s.append(" ");
        }
        return s.toString();
    }

    public static void toXml(BrailleCssTreeBuilder.Style style, XMLStreamWriter writer, boolean deep) throws XMLStreamException {
        BrailleCssSerializer.toXml(style, writer, deep, false);
    }

    private static void toXml(BrailleCssTreeBuilder.Style style, XMLStreamWriter w, boolean deep, boolean recursive) throws XMLStreamException {
        if (style.declarations != null) {
            if (!deep || !recursive || style.nestedStyles != null) {
                XMLStreamWriterHelper.writeStartElement((XMLStreamWriter)w, (QName)CSS_RULE);
            }
            if (!deep) {
                XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)w, (QName)STYLE, (String)BrailleCssSerializer.serializeDeclarationList(style.declarations));
            }
            if (deep) {
                for (Declaration d : style.declarations) {
                    XMLStreamWriterHelper.writeStartElement((XMLStreamWriter)w, (QName)CSS_PROPERTY);
                    XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)w, (QName)NAME, (String)d.getProperty());
                    XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)w, (QName)VALUE, (String)BrailleCssSerializer.serializeTermList(d));
                    w.writeEndElement();
                }
            }
            if (!deep || !recursive || style.nestedStyles != null) {
                w.writeEndElement();
            }
        }
        if (style.nestedStyles != null) {
            for (Map.Entry<String, BrailleCssTreeBuilder.Style> e : style.nestedStyles.entrySet()) {
                XMLStreamWriterHelper.writeStartElement((XMLStreamWriter)w, (QName)CSS_RULE);
                XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)w, (QName)SELECTOR, (String)e.getKey());
                if (!deep) {
                    XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)w, (QName)STYLE, (String)e.getValue().toString());
                }
                if (deep) {
                    BrailleCssSerializer.toXml(e.getValue(), w, true, true);
                }
                w.writeEndElement();
            }
        }
    }
}

