/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.braille.css;

import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.SupportedCSS;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupportedPrintCSS
implements SupportedCSS {
    private static Logger log = LoggerFactory.getLogger(SupportedPrintCSS.class);
    private static final int TOTAL_SUPPORTED_DECLARATIONS = 4;
    private static final TermFactory tf = CSSFactory.getTermFactory();
    private static final Term<?> DEFAULT_UA_COLOR = tf.createColor("#000000");
    private Map<String, CSSProperty> defaultCSSproperties;
    private Map<String, Term<?>> defaultCSSvalues;
    private Map<String, Integer> ordinals;
    private Map<Integer, String> ordinalsRev;
    private Set<String> properties;
    private static SupportedPrintCSS instance;

    public static final SupportedPrintCSS getInstance() {
        if (instance == null) {
            instance = new SupportedPrintCSS();
        }
        return instance;
    }

    private SupportedPrintCSS() {
        this.setSupportedCSS();
        this.setOridinals();
    }

    public boolean isSupportedMedia(String media) {
        if (media == null) {
            return false;
        }
        return media.toLowerCase().equals("print");
    }

    public final boolean isSupportedCSSProperty(String property) {
        return this.properties.contains(property);
    }

    public final CSSProperty getDefaultProperty(String property) {
        CSSProperty value = this.defaultCSSproperties.get(property);
        log.debug("Asked for property {}'s default value: {}", (Object)property, (Object)value);
        return value;
    }

    public final Term<?> getDefaultValue(String property) {
        return this.defaultCSSvalues.get(property);
    }

    public final int getTotalProperties() {
        return this.defaultCSSproperties.size();
    }

    public final Set<String> getDefinedPropertyNames() {
        return this.defaultCSSproperties.keySet();
    }

    public String getRandomPropertyName() {
        Random generator = new Random();
        int o = generator.nextInt(this.getTotalProperties());
        return this.getPropertyName(o);
    }

    public int getOrdinal(String propertyName) {
        Integer i = this.ordinals.get(propertyName);
        return i == null ? -1 : i;
    }

    public String getPropertyName(int o) {
        return this.ordinalsRev.get(o);
    }

    private void setSupportedCSS() {
        HashMap<String, CSSProperty> props = new HashMap<String, CSSProperty>(4, 1.0f);
        HashMap values = new HashMap(4, 1.0f);
        this.properties = new HashSet<String>();
        props.put("color", (CSSProperty)CSSProperty.Color.color);
        values.put("color", DEFAULT_UA_COLOR);
        this.properties.add("color");
        props.put("font-style", (CSSProperty)CSSProperty.FontStyle.NORMAL);
        this.properties.add("font-style");
        props.put("font-weight", (CSSProperty)CSSProperty.FontWeight.NORMAL);
        this.properties.add("font-weight");
        props.put("text-decoration", (CSSProperty)CSSProperty.TextDecoration.NONE);
        this.properties.add("text-decoration");
        this.defaultCSSproperties = props;
        this.defaultCSSvalues = values;
    }

    private void setOridinals() {
        HashMap<String, Integer> ords = new HashMap<String, Integer>(this.getTotalProperties(), 1.0f);
        HashMap<Integer, String> ordsRev = new HashMap<Integer, String>(this.getTotalProperties(), 1.0f);
        int i = 0;
        for (String key : this.defaultCSSproperties.keySet()) {
            ords.put(key, i);
            ordsRev.put(i, key);
            ++i;
        }
        this.ordinals = ords;
        this.ordinalsRev = ordsRev;
    }
}

