/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.zip;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtils {
    private static final Logger logger = LoggerFactory.getLogger(ZipUtils.class);

    public static byte[] deflate(String str) throws IOException {
        if (!str.isEmpty()) {
            ByteArrayInputStream inByte = new ByteArrayInputStream(str.getBytes());
            ByteArrayOutputStream outByte = new ByteArrayOutputStream();
            GZIPOutputStream outZip = new GZIPOutputStream(outByte);
            long copied = ByteStreams.copy((InputStream)inByte, (OutputStream)outZip);
            outByte.close();
            outZip.close();
            inByte.close();
            logger.debug(String.format("Deflated %f%%", (double)str.length() / (double)copied));
            return outByte.toByteArray();
        }
        return new byte[0];
    }

    public static String inflate(byte[] bytes) throws IOException {
        if (bytes.length > 0) {
            ByteArrayInputStream inByte = new ByteArrayInputStream(bytes);
            GZIPInputStream inZip = new GZIPInputStream(inByte);
            ByteArrayOutputStream outByte = new ByteArrayOutputStream();
            long copied = ByteStreams.copy((InputStream)inZip, (OutputStream)outByte);
            outByte.close();
            inByte.close();
            inZip.close();
            logger.debug(String.format("Inflated %f%%", (double)bytes.length / (double)copied));
            return new String(outByte.toByteArray());
        }
        return new String("");
    }
}

