/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.xslt;

import com.xmlcalabash.core.XProcConfiguration;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XsltCompiler;
import org.daisy.common.xslt.CompiledStylesheet;

public class XslTransformCompiler {
    private URIResolver uriResolver;
    private XsltCompiler xsltCompiler;

    public XslTransformCompiler(Configuration config) {
        this.setConfiguration(config);
    }

    public XslTransformCompiler(XProcConfiguration config) {
        this.setConfiguration(config);
    }

    public XslTransformCompiler(Configuration config, URIResolver uriResolver) {
        this.uriResolver = uriResolver;
        this.setConfiguration(config);
    }

    public XslTransformCompiler(XProcConfiguration config, URIResolver uriResolver) {
        this.uriResolver = uriResolver;
        this.setConfiguration(config);
    }

    public CompiledStylesheet compileStylesheet(InputStream stylesheet) throws SaxonApiException {
        CompiledStylesheet cs = new CompiledStylesheet(this.xsltCompiler.compile((Source)new StreamSource(stylesheet)));
        if (this.uriResolver != null) {
            cs.setURIResolver(this.uriResolver);
        }
        return cs;
    }

    private void setConfiguration(Configuration config) {
        this.initCompiler(config);
    }

    private void setConfiguration(XProcConfiguration config) {
        this.initCompiler(config.getProcessor().getUnderlyingConfiguration());
    }

    private void initCompiler(Configuration config) {
        this.xsltCompiler = new Processor(config).newXsltCompiler();
        if (this.uriResolver != null) {
            this.xsltCompiler.setURIResolver(this.uriResolver);
        }
    }
}

