/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.properties;

public class Property {
    private String bundleName;
    private long bundleId;
    private String propertyName;
    private String value;

    public boolean equals(Object obj) {
        if (!(obj instanceof Property)) {
            return false;
        }
        Property other = (Property)obj;
        boolean eq = true;
        eq &= this.bundleId == other.bundleId;
        eq &= this.bundleName.equals(other.bundleName);
        eq &= this.propertyName.equals(other.propertyName);
        return eq &= this.value.equals(other.value);
    }

    public String toString() {
        return String.format("%s: %s (Provided by %s [%d])", this.propertyName, this.value, this.bundleName, this.bundleId);
    }

    private Property(String bundleName, long bundleId, String propertyName, String value) {
        this.bundleName = bundleName;
        this.bundleId = bundleId;
        this.propertyName = propertyName;
        this.value = value;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getValue() {
        return this.value;
    }

    public static class Builder {
        private String bundleName;
        private long bundleId;
        private String propertyName;
        private String value;

        public Builder withBundleName(String name) {
            this.bundleName = name;
            return this;
        }

        public Builder withBundleId(long id) {
            this.bundleId = id;
            return this;
        }

        public Builder withPropertyName(String propertyName) {
            this.propertyName = propertyName;
            return this;
        }

        public Builder withValue(String value) {
            this.value = value;
            return this;
        }

        public Property build() {
            return new Property(this.bundleName, this.bundleId, this.propertyName, this.value);
        }
    }
}

