/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.priority.timetracking;

import com.google.common.base.Function;
import java.util.Collection;
import org.daisy.common.priority.PrioritizableRunnable;
import org.daisy.common.priority.UpdatablePriorityBlockingQueue;
import org.daisy.common.priority.timetracking.TimeFunctionFactory;
import org.daisy.common.priority.timetracking.TimeStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeTracker<T> {
    private int counter = 0;
    private final int frequency;
    private final UpdatablePriorityBlockingQueue<T> queue;
    private final TimeFunctionFactory functionFactory;
    private static final Logger logger = LoggerFactory.getLogger(TimeTracker.class);

    public TimeTracker(int frequency, UpdatablePriorityBlockingQueue<T> queue, TimeFunctionFactory functionFactory) {
        this.frequency = frequency;
        this.queue = queue;
        this.functionFactory = functionFactory;
    }

    public synchronized void executing() {
        ++this.counter;
        if (this.counter == this.frequency) {
            Collection<PrioritizableRunnable<T>> waiting = this.queue.asCollection();
            long[] times = new long[waiting.size()];
            int i = 0;
            for (PrioritizableRunnable<T> r : waiting) {
                times[i++] = r.getTimestamp();
            }
            this.update(times);
            this.counter = 0;
        }
    }

    void update(long[] times) {
        logger.debug("Updating queue");
        TimeStats stats = new TimeStats(System.nanoTime(), times);
        final Function<Long, Double> timeUpdater = this.functionFactory.getFunction(stats);
        this.queue.update(new Function<PrioritizableRunnable<T>, Void>(){

            public Void apply(PrioritizableRunnable<T> runnable) {
                runnable.setRelativeWaitingTime((Function<Long, Double>)timeUpdater);
                return null;
            }
        });
    }
}

